.\" $Id: nntplink.man,v 1.13 1993/12/22 00:57:43 root Exp $
.\" Copyright (c) 1991,1992,1993 David J Alden
.\" Copyright (c) 1991,1992,1993 The Ohio State University.
.\" All rights reserved.
.\"
.\" Permission is hereby granted to copy, reproduce, redistribute or
.\" otherwise use this software as long as: (1) there is no monetary
.\" profit gained specifically from the use or reproduction of this
.\" software, (2) it is not sold, rented, traded, or otherwise marketed,
.\" (3) the above copyright notice and this paragraph is included
.\" prominently in any copy made, and (4) that the name of The Ohio State
.\" University is not used to endorse or promote products derived from
.\" this software without the specific prior written permission of The
.\" Ohio State University.
.\"
.\" THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
.\" IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
.\" WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
.\"
.TH NNTPLINK 8 "29 Nov 1993"
.SH NAME
.I nntplink
\- transmit netnews articles to a remote NNTP server
.SH SYNOPSIS
.B nntplink
[
.B \-AdfkLoOqrUvVx
] [
.BI \-a " close-after"
] [
.BI \-b " batchfile"
] [
.BI \-B " batch-directory"
] [
.BI \-c " clear-batchfile"
] [
.BI \-C " close-timeout"
] [
.BI \-D " debug-outfile"
] [
.BI \-e " exit-timeout"
] [
.BI \-E " entry-sleep"
] [
.BI \-F " datafile"
] [
.BI \-H " history-file"
] [
.BI \-i " batchfile | funnel | logfile | stdin"
] [
.BI \-l " log-after"
] [
.BI \-m " fail-minutes"
] [
.BI \-n " batchfile-naptime"
] [
.BI \-N " datafile-naptime"
] [
.BI \-p " decnet | tcp | dkhost"
] [
.BI \-P " port"
] [
.BI \-R " repeat-minutes"
] [
.BI \-s " sysname"
] [
.BI \-S " spool-directory"
] [
.BI \-y " delay"
]
.I host
.SH DESCRIPTION
.B Nntplink
offers netnews articles [RFC1036] to the specified
.I host
which must be running the NNTP (Network News Transfer
Protocol, [RFC977]) server, transmitting those articles that the remote
server indicates that it does not already have.
.LP
.B Nntplink
only closes the connection when a specified number of articles have been
offered to the remote end since the last such closure (this allows the
other end to log transfer statistics)
.I or
one can request closure to take place when
.B nntplink 
has been idle for a specified amount of time.
.B Nntplink
can also be set to exit (as opposed to simply closing the connection)
when it has been idle for a specified time.
.SH OPTIONS
.TP
.B \-A
Autobackground.
Automatically runs in the background.
.TP
.B \-d
Debug.
Prints debug messages to help trace down any problems.
.TP
.B \-f
Retry fails.
If the remote site returns "436" then 
.B nntplink 
will keep on trying to offer the current offer.  (As opposed to either
saving it or junking it according to the definition in conf.h).
.TP
.B \-k
Kill old nntplink processes.
If the pid field of the datafile isn't zero (i.e., there is another nntplink
process already running to this site) -- go ahead and kill it.
.TP
.B \-L
Log closings.
Log statistics each time the connection is closed.
.TP
.B \-o
One shot.
Goes through the specified input file once.  It doesn't update the link
datafile, however it does remove the input file when it is finished.
.TP
.B \-O
Open article first.
Open the article before trying to send it.
.TP
.B \-q
Queue backlogs.  If using stdin to retrieve articles and the remote site goes
down, begin saving all incoming articles to a batchfile.  When the remote site
comes up, close the batchfile and begin sending articles from stdin again.
Note that nntplink will NOT do anything with the batchfile - you must process
it via some other method.
.TP
.B \-r
Don't report statistics.
Turns off the statistics reporting.
.TP
.B \-U
Use ".nntp" instead of ".<pid>" for the batchfile name extension.
.TP
.B \-v
Print version.
Displays the version on standard error and exits.
.TP
.B \-V
Print version and config.
Displays the version and configuration information on standard error and
exits.
.TP
.B \-x
XREPLIC.
XREPLIC is a protocol extension used by INN to permit master/slave netnews
replication.
.TP
.B \-a " close-after"
Specify the number of articles that will be offered before
.B nntplink
will close the connection to allow the remote end to log statistics.
[Default: @@CLOSE_AFTER@@]
.TP
.B \-b " batchfile"
Specify the batchfile that
.B nntplink
will use.
.TP
.B \-B " batch-directory"
Specify the directory in which the batchfile is located.
[Default: @@BATCHDIR@@]
.TP
.B \-c " clear-batchfile"
Specify the number of articles that will be offered before
.B nntplink
will remove the old batchfile.
[Default: @@CLEAR_BATCHFILE@@]
.TP
.B \-C " close-timeout"
Specify the amount of idle time (in seconds) before
.B nntplink
closes the connection.
[Default: @@CLOSE_TIMEOUT@@]
.TP
.B \-D " debug-outfile"
Specify a debug file in which
.B nntplink
will record the debug output.  Note that nntplink will actually send debug
output to the file <debug-outfile><pid> -- adding the pid of the nntplink
process to the filename.
.TP
.B \-e " exit-timeout"
Specify the amount of idle time (in seconds) before
.B nntplink
closes the connection and exits.
[Default: @@EXIT_TIMEOUT@@]
.TP
.B \-E " entry-sleep"
Specify the amount of time (in seconds) that
.B nntplink
sleeps between checking for new input from the input file.
[Default: @@ENTRY_SLEEP@@]
.TP
.B \-F " datafile"
Specify the datafile (either the logfile or funnel file) that
.B nntplink
will use.
[Default: @@DATAFILE@@]
.TP
.B \-H " history-file"
Specify the history file that
.B nntplink
will use.  (Only used if
.B nntplink
must look up the article pathname.)
[Default: @@HISTORYFILE@@]
.TP
.B \-i " batchfile | funnel | logfile | stdin"
Specify the method which
.B nntplink
will use to get its articles.
[Default: @@DEF_INPUT_FROM@@]
.TP
.B \-l " log-after"
Specify the number of articles that will be offered before
.B nntplink
will log the statistics.
[Default: @@LOG_AFTER@@]
.TP
.B \-m " fail-minutes"
Specify the amount of time (in minutes) that must pass between
successful article transmissions before 
.B nntplink
logs an error message.
[Default: @@FAIL_MINUTES@@]
.TP
.B \-n " batchfile-naptime"
Specify the amount of time (in seconds) which
.B nntplink
will sleep between checks for the new batchfile.
[Default: @@BATCHFILE_NAPTIME@@]
.TP
.B \-N " datafile-naptime"
Specify the amount of time (in seconds) which
.B nntplink
will sleep between checks for the new datafile (either logfile or
funnel file).
[Default: @@DATAFILE_NAPTIME@@]
.TP
.B \-p " decnet | tcp | dkhost"
Specify the protocol which
.B nntplink
will use to connect the remote NNTP host.
[Default: @@HOST_TRANSPORT@@]
.TP
.B \-P " port"
Specify the port which nntplink should use when connecting to the
remote NNTP host.
.TP
.B \-R " repeat-minutes"
Specify the amount of time (in minutes) which must pass after
.B nntplink
has logged a failure message before it will log another one.
[Default: @@REPEAT_MINUTES@@]
.TP
.B \-s " sysname"
Specify the sysname of the remote NNTP host.  This is only used for
matching the sysname in the datafile when using either the logfile
or funnel mode to get the articles.
.TP
.B \-S " spool-directory"
Specify the directory in which the news articles are spooled.
[Default: @@SPOOLDIR@@]
.TP
.B \-y " delay"
Specify the amount of time to delay before sending the article.  If a
timestamp is not added to each entry, it will retrieve the information
from the history file.  When using stdin mode you must ensure that the
feeding software can hold a large enough buffer, particularly if the
delay is important.
.SH SIGNALS
.TP
.B INT
The INT signal causes
.B nntplink
to exit.  If
.B nntplink
is using the funnel file, logfile, or stdin input mode then it will create
a batchfile containing the rest of the unsent articles before exiting.
.TP
.B TERM
The TERM signal is the same as the INT signal.
.TP
.B HUP
The HUP signal is the same as the INT signal unless
.B nntplink
is using the funnel file or logfile without the 
.B \-o (one shot)
option.  If the funnel file or logfile mode is selected (and the
.B \-o
option is not), then 
.B nntplink
will create a batchfile containing the rest of the unsent articles and
close and reopen the datafile (either the logfile or funnel file).
This signal should be sent to nntplink after the datafile gets recreated
if you are using either the funnel or logfile input mode.
.TP
.B USR1
The USR1 signal is used to reset the fake syslog file when you are using
the FAKESYSLOG support.
.TP
.B USR2
The USR2 signal is used to start/stop debugging.  If debugging is started,
then nntplink will open a file /tmp/nntplink.<pid> and begin sending the
debugging output to it.  If it is already in debug mode, it will stop
debugging.
.SH FILES
.PD 0
.TP
.B @@BATCHDIR@@
Directory where nntplink finds the batchfile and related files.
.TP
.B <batchfile>
File in which
.B nntplink
retrieves the queued article information from.
.TP
.B <batchfile.nntp>
Temporary file which
.B nntplink
uses to store (and retrieve) the queued article information from.
.TP
.B <batchfile.fail>
File in which
.B nntplink
stores failed article information in (only if the
.B \-f
option was not specified).
.TP
.B <batchfile.link>
File in which
.B nntplink
stores its status information - used so that
.B nntplink
can keep track of its status between invocations.
.TP
.B @@HISTORYFILE@@
File which
.B nntplink
retrieves the article pathname from (if it needs to).
.TP
.B @@DATAFILE@@
File which
.B nntplink
retrieves the article information from (if using the funnel file or logfile
input mode).
.TP
.B @@SPOOLDIR@@
Directory where
.B nntplink
finds the articles which it sends to the remote NNTP host.
.PD
.SH "SEE ALSO"
.BR iinnxmit (1),
.BR nntpd (8),
.BR nntpxmit (1),
.LP
.I "RFC977 \- Network News Transfer Protocol"
.LP
.I "RFC1036 \- Standard for Interchange of USENET Messages"
.SH AUTHOR
David Alden <alden@math.ohio-state.edu>, Department of Mathematics, The Ohio
State University, Columbus, OH, USA
