/**
 ** Routine that deals with signal interrupts.
 **
 ** $Id: sig.c,v 1.8 1994/01/09 18:46:45 alden Exp $
 **
 ** $Log: sig.c,v $
 ** Revision 1.8  1994/01/09  18:46:45  alden
 ** Removed trailing '\n' from logmsg() calls -- syslog() will add them for us
 **
 ** Revision 1.7  1993/12/20  14:41:12  alden
 ** Replaced "Host.name" with "Host.sysname" in fail() and logmsg() calls
 **
 ** Revision 1.6  1993/11/19  20:46:01  alden
 ** Added code to handle SIGUSR2
 **
 ** Revision 1.5  1993/11/10  01:52:19  alden
 ** Changed all occurrences of log() to logmsg().
 **
 ** Revision 1.4  1993/10/13  20:26:54  root
 ** modified to deal with new '-y' option
 **
 ** Revision 1.3  1993/05/28  12:54:05  alden
 ** Changed "#ifdef HAVE_BROKEN_SIGNAL" to "#ifndef HAVE_WORKING_SIGNAL"
 **
 ** Revision 1.2  1993/05/04  23:38:49  alden
 ** Cleaned up tabs
 **
 ** Revision 1.1  1993/03/30  13:19:38  alden
 ** Initial revision
 **
 **
 **
 **/
#include "conf.h"
#include "readline.h"
#include "nntplink.h"

#include <signal.h>

extern Boolean Debug;
extern int Input_from;
extern Boolean One_shot;

extern Boolean Reset_log;

Boolean Abort_signaled = FALSE;
Boolean Debug_signaled = FALSE;
Boolean Reset_signaled = FALSE;

extern void fail();
extern void logmsg();

void
  sighandler(sig)
int sig;
{
  static char *fname = "sighandler: ";
  
#ifndef HAVE_WORKING_SIGNAL
  signal(sig, SIG_IGN);
  signal(sig, sighandler);
#endif
  
  dlogmsg(LOG_DEBUG, fname, "%s%s: received signal %d", Host.sysname, sig);
  
  switch(sig) {
  case SIGINT:
  case SIGTERM:
    Abort_signaled = TRUE;
    break;
    
  case SIGHUP:
    if (((Input_from & FLG_FUNNEL) || (Input_from & FLG_LOGFILE)) && !One_shot)
      Reset_signaled = TRUE;
    else
      Abort_signaled = TRUE;
    
#ifndef HAVE_SYSLOG_H
  case SIGUSR1:
    Reset_log = TRUE;
#endif

    break;
    
  case SIGPIPE:
#ifdef SIGURG
  case SIGURG:
#endif
    logmsg(LOG_DEBUG, fname, "%s%s: received signal %d - continuing",
	   Host.sysname, sig);
    break;
    
#ifdef SIGUSR2
  case SIGUSR2:
    Debug_signaled = TRUE;
    break;
#endif    
    
  default:
    fail(fname, "%s%s: Received unknown signal %d", Host.sysname, sig);
    /*NOTREACHED*/
  }
  return;
}
