/**
 ** Routine that deals with sending authorization info to remote host.
 **
 ** $Id: xmitauth.c,v 1.9 1994/02/03 23:17:11 alden Exp $
 **
 ** $Log: xmitauth.c,v $
 ** Revision 1.9  1994/02/03  23:17:11  alden
 ** Allow ":" to be the sperator character for the password file
 **
 ** Revision 1.8  1994/01/09  18:46:58  alden
 ** Removed trailing '\n' from logmsg() calls -- syslog() will add them for us
 ** Call sleep_fail() instead of fail() -- this way we sleep for 60 seconds
 **     before exiting
 **
 ** Revision 1.7  1993/12/20  14:41:15  alden
 ** Replaced "Host.name" with "Host.sysname" in fail() and logmsg() calls
 **
 ** Revision 1.6  1993/11/10  01:53:02  alden
 ** Changed all occurrences of log() to logmsg().
 **
 ** Revision 1.5  1993/09/22  23:14:26  root
 ** Modified a few of the printf() statements to be a little more clear
 **
 ** Revision 1.4  1993/08/27  18:36:35  root
 ** Print PASSFILE instead of "nntp.sys" in a fail() message
 **
 ** Revision 1.3  1993/05/04  23:39:06  alden
 ** Cleaned up tabs
 **
 ** Revision 1.2  1993/04/17  22:28:57  root
 ** Changed logmsg() messages to include filename
 **
 ** Revision 1.1  1993/03/30  13:19:50  alden
 ** Initial revision
 **
 **
 **
 **/
#include "conf.h"
#include "readline.h"
#include "nntplink.h"
#include "nntp.h"
#include "strfuns.h"

extern char *converse();
extern void sleep_fail();
extern void logmsg();

#ifndef PASSFILE
#define PASSFILE "<none-specified>"
#endif

void
  xmitauth(host)
char *host;
{
  static char *fname = "xmitauth: ";
  char *remote, *user, *pass;
  char *line, *reply;
  int resp;
  int sys_fd;
  FileBuf *sys_fbp;
  
  
  if ((sys_fd = open(PASSFILE, O_RDONLY)) == FAIL)
    sleep_fail("%s%s: Password file %s not found", Host.sysname, PASSFILE);
  
  sys_fbp = fb_fdopen(sys_fd);
  
  while((line = fb_readline(sys_fbp, NULL)) != NULL)
    if (*line != '#') {
      
      remote = line;
      
      if (((line = strchr(remote, ' ')) == NULL) &&
	  ((line = strchr(remote, ':')) == NULL))
	logmsg(LOG_NOTICE, fname, "%s%s: malformed entry in %s",
	       Host.sysname, PASSFILE);
      else {
	*line++ = '\0';
	user = line;
	if (((line = strchr(user, ' ')) == NULL) &&
	    ((line = strchr(user, ':')) == NULL))
	  logmsg(LOG_NOTICE, fname, "%s%s: malformed entry in %s",
		 Host.sysname, PASSFILE);
	else {
	  *line++ = '\0';
	  pass = line;
	  if (strcasecmp(remote, host) == MATCH)
	    break;
	}
      }
    }
  
  if (fb_error(sys_fbp))
    logmsg(LOG_WARNING, fname, "%s%s: error reading %s: %s",
	   Host.sysname, PASSFILE, errmsg(errno));
  
  if (line == NULL)
    sleep_fail(fname, "%s%s: host %s authinfo not in %s", Host.sysname,
	       host, PASSFILE);
  
  line = str2save("authinfo user ", user);
  reply = converse(line, &resp);
  FREE(line);
  
  if (reply == NULL)
    sleep_fail(fname, "%s%s: sent authinfo user, remote closed connection",
	 Host.sysname);

  if (resp != NEED_AUTHDATA)
    if (resp == FAIL)
      sleep_fail(fname,
		 "%s%s: sent authinfo user, exiting due to bad response",
		 Host.sysname);
    else
      sleep_fail(fname,
		 "%s%s: sent authinfo user, exiting due to bad response: %s",
		 Host.sysname, reply);
  
  line = str2save("authinfo pass ", pass);
  reply = converse(line, &resp);
  FREE(line);

  if (reply == NULL)
    sleep_fail(fname, "%s%s: sent authinfo user, remote closed connection",
	       Host.sysname);

  if (resp != OK_AUTH)
    if (resp == FAIL)
      sleep_fail(fname,
		 "%s%s: sent authinfo pass, exiting due to bad response",
		 Host.sysname);
    else
      sleep_fail(fname,
		 "%s%s: sent authinfo pass, exiting due to bad response: %s",
		 Host.sysname, reply);
  
  CLOSE(sys_fd);
  fb_close(sys_fbp);
  return;
}
