#!/usr/bin/perl
#
# $Id: links.pl,v 1.5 1994/02/03 23:26:19 alden Exp $
#
## Perl version of "links" script. Works only with INN.
##
## Written by Christophe Wolfhugel <wolf@grasp.insa-lyon.fr>.
## Copyright (C) 1993, Christophe Wolfhugel & Herve Schauer Consultants.
##
## Based on the original links script written by Dave Alden.
##
##  This is free software. Don't sell it. Don't pay to get it.
##  Don't distribute this package modified. Send me diffs for inclusion instead.##
##  As with all free software:
##
##  ABSOLUTELY NO WARRANTY WITH THIS PACKAGE.  USE IT AT YOUR OWN RISKS.
##
##------------ CONFIG SECTION STARTS HERE ------------------------------------
# Path. Include INN's binaries as well as the directory where the
# nntplink executable is (if different).
$ENV{'PATH'} = "/news/news.lib/bin:$ENV{'PATH'}";

# Where is the list which contains the sites that we should startup nntplink.
# NOTE: must be an absolute filename.
$sitelist = "/news/news.lib/links-list";

# Comment out this line if you don't want nntplink to automatically place
# itself in the background.
$autobackground = "-A";

# Where are the batchfiles?
# NOTE: BATCH is defined in the INN config script.
$batchdir = "/news/out.going";

# What is the name of the logfile written by INN.
# NOTE: must be an absolute name.
$logfile  = "/var/log/news/news";

# What is the name of the funnel file written by INN in the
# batch directory and what is the site name in the newsfeeds file?
# NOTE: This is only used with the "-i funnel" option with INN, so
#       if you aren't using the funnel mode, you can skip this.
$funnelfile = "nntplinks";
$funnelsite = "nntplinks";

# What goes on the end of "$batchdir/$site to get the link datafile?
# (ie: should we use "$batchdir/$site/togo.link" or should we use
# "$batchdir/$site.link"?).
$rest     = ".link";
#$rest = "/togo.link";

# Command to display all of the processes currently running.
#$ps_command = "ps -e";		## SYSV
$ps_command = "ps -axww";	## BSD

# Column in which the pid is in from the previous command.
#$pid_column = 1;		## SYSV
$pid_column = 1;		## BSD


#---------- STOP ---------- STOP ---------- STOP ---------- STOP ----------
#
#  You should not need to modify anything below this line.
#

if ($ARGV[0] eq "-s") {
   $sig = $ARGV[1];
} elsif ($ARGV[0] eq "-v") {
   $verbose = "true";
} elsif ($ARGV[0] eq "abort") {
   $sig = "KILL";
} elsif ($ARGV[0] eq "age") {
   $age = "true";
   $sig = "HUP";
} elsif ($ARGV[0] eq "agefunnel") {
   $funnel = "true";
   $age = "true";
   $sig = "HUP";
} elsif ($ARGV[0] eq "boot") {
   $boot = "true";
   $start = "true";
} elsif ($ARGV[0] eq "clean") {
   $clean = "true";
} elsif ($ARGV[0] eq "clear") {
   $clear = "true";
} elsif ($ARGV[0] eq "start") {
   $start = "true";
} elsif ($ARGV[0] eq "stop") {
   $sig = "TERM";
} elsif ($ARGV[0] eq "check") {
   $check = "true";
} else {
   print "Usage: links [abort|age|agefunnel|boot|check|clean|clear|start|stop] [-s <SIGNAL>] [-v]\n";
   exit(1);
}

## Load site list into memory
open(F1, "$sitelist") || die("Can't open $sitelist");
while (<F1>) {
   next if (/^\s*#/);
   next if (! /\s*\d+\s+\S+/);
   chop;
   push(@sl, $_);
}
close(F1);

if ($funnel) {
   chdir($batchdir) || die("Can't chdir to $batchdir");
   rename("$funnelfile", "$funnelfile.old");
   system("ctlinnd flush $funnelsite");
}


sub checkPS {
   local ($pid) = @_;

   foreach $_ (@ps) {
      split;
      return 1 if ($pid == @_[$pid_column - 1]);
   }
   return 0;
}

sub readPS {
   @ps = ();
   open(F1, "$ps_command |") || die("Can't $ps_command");
   while (<F1>) {
      next if (! /nntplink/);
      next if (/grep/);
      chop;
      s/^\s+//;
      s/\s+$//;
      push(@ps, $_);
   }
   close(F1);
}

&readPS();

foreach $_ (@sl) {
   next if (! /\s*(-?\d+)\s+(\S+)\s*(.*)$/);
   $pri = $1;
   $site = $2;
   $options = $3;

   $bfile = $site;
   $bdir = $batchdir;

   @options = split(/\s+/, $options);
   while ($_ = $options[0], /^-/) {
      shift @options;
      /^-b$/
         && ((@options > 0) || die "Missing argument to \"-b\" option.\n")
             && ($bfile = shift @options) && next;
      /^-B$/
         && ((@options > 0) || die "Missing argument to \"-B\" option.\n")
             && ($bdir = shift @options) && next;
      /^-i$/
         && ((@options > 0) || die "Missing argument to \"-i\" option.\n")
             && ($input = shift @options) && next;
   }
   
   next if ($age && ($input eq "batchfile" || $input eq "stdin"));
   next if (($check || $start || $sig) &&  $input eq "stdin");

   if ($clean) {
      ## Skip if not a stdin link
      next if ($input ne "stdin");

      ## Here I should setup the lockfile
      $lockfile = "/tmp/nntplink-$site";
      if (-r "$lockfile") {
         open(LOCK, "$lockfile") || die("Can't open $lockfile");
         $pid = <LOCK>;
         close(LOCK);
         if (kill(0, $pid) == 1) {
            unlink("$lockfile");
         } else {
            print "nntplink($pid) is already running to $site\n";
            next;
         }
      }
      open(LOCK, "> $lockfile") || die("Can't open $lockfile");
      print LOCK "$$\n";
      close(LOCK);

      chdir($bdir);

      ## $bfile.tmp should not exist. I do not test it yet !
      if (-f "$bfile.tmp") {
         system("cat $bfile.tmp >> $bfile.old");
         unlink("$bfile.tmp");
      }

      #if (-f "$bfile") {
         #rename("$bfile", "$bfile.tmp");
         #if (system("ctlinnd -s flush $site") == 0) {
            #system("cat $bfile.tmp >> $bfile.old");
            #unlink("$bfile.tmp");
         #}
      #}

      foreach $file (<$bfile*>) {
         if ($file =~ /\.(\d+)\.tmp$/) {
            system("ctlinnd -s flush $site");
            sleep(5);
            last;
         }
      }
      foreach $file (<$bfile*>) {
         if ($file =~ /\.\d+$/) {
            system("cat $file >> $bfile.old");
            unlink($file);
            next;
         } elsif ($file =~ /\.(\d+)\.tmp$/) {
            next if (kill(0, $1) == 1);
            if ($1 > 0) {
               system("cat $file >> $bfile.old");
               unlink($file);
            }
         } 
      }

      if (-f "$bfile.old") {
	 if (fork() == 0) {
	    open(LOCK, "> $lockfile") || die("Can't open $lockfile");
            print LOCK "$$\n";
            close(LOCK);
	    system("nice -$pri nntplink -i batchfile -o -B $bdir -b $bfile.old $site");
	    unlink("$lockfile");
	 }
	 sleep(5);
      } else {
         unlink("$lockfile");
      }
      next;
   }

   $tried_already = "false";
   $boot_status = $boot;
   $start_status = $start;

   while (1) {
      if (-f "$bdir/$bfile$rest") {

	 if ($clear || $boot_status) {

	    open(TMPFILE, ">$bdir/$bfile$rest.tmp") ||
	       die("Can't write $bdir/$bfile$rest.tmp");

	    print TMPFILE "-999\n";

	    open(ORIGFILE, "$bdir/$bfile$rest") ||
	       die("Can't read $bdir/$bfile$rest");

	    $ignore = <ORIGFILE>;

	    while (<ORIGFILE>) {
	       print TMPFILE $_;
	    }

	    close(TMPFILE);
	    close(ORIGFILE);

	    rename("$bdir/$bfile$rest.tmp", "$bdir/$bfile$rest");

	    last if ($clear || ($pri == "-999"));

	 } else {

	    last if ($pri == "-999");

	    open(F1, "$bdir/$bfile$rest") ||
	       die("Can't read $bdir/$bfile$rest");
	    $pid = <F1>;
	    close(F1);
	    chop($pid);
 
	    if ($pid != -999) {
	       if (&checkPS($pid)) {
		  kill $sig, $pid if ($sig);
		  last;
	       } else {
		  if ($sig) {
		     print "links: $bfile has a bad pid in its datafile\n";
		     print "links: human intervention is necessary\n";
		  }
	       }
	    }
	 }
         last if ($sig);
      }

      last if ($sig || $clear || ($pri eq "-999"));

      if ($start_status) {
	 system("nice -$pri nntplink $autobackground $options $site");
	 undef $boot_status;
	 undef $start_status;
	 sleep(5);
         &readPS();
      } else {

	 if ($tried_already ne "true") {
	    print "link: site $site isn't running - trying to restart it\n";
	    system("nntplink $autobackground $options $site");
	    $tried_already = "true";
	    sleep(5);
         } else {
	    print "links: site $site still not running - skipping\n";
	    last;
         }
      }
   }
}

exit(0);


