/**
 ** $Id: postconf.h,v 1.18 1994/05/02 16:21:47 root Exp $
 **
 ** This file also contains a lot of assumptions about what features
 ** are available on the local system - if something is not working
 ** to your liking, look them over carefully.
 **
 **
 ** $Log: postconf.h,v $
 ** Revision 1.18  1994/05/02  16:21:47  root
 ** Moved "NULL" define so as not to conflict with system def
 **
 ** Revision 1.17  1994/02/19  16:39:59  alden
 ** NetBSD mmap() requires MAP_FILE
 **
 ** Revision 1.16  1994/02/09  00:10:38  alden
 ** Don't include <syslog.h> if FAKESYSLOG is defined!
 **
 ** Revision 1.15  1994/02/03  23:37:55  alden
 ** Added def for MMAP_ARGS
 **
 ** Revision 1.14  1993/12/21  23:33:59  alden
 ** Redefine NULL to "0" (some machines define it to be a pointer)
 **
 ** Revision 1.13  1993/11/24  23:14:06  root
 ** Undefine _POSIX_VERSION if "sequent" is defined!
 **
 ** Revision 1.12  1993/11/22  13:54:33  alden
 ** Undefine HAVE_MMAP if on certain machines
 **
 ** Revision 1.11  1993/11/19  17:22:29  alden
 ** Rearranged some of the #include's and added an include for <time.h>
 **
 ** Revision 1.10  1993/11/10  01:54:42  alden
 ** Changed all occurrences of log() to logmsg().
 **
 ** Revision 1.9  1993/10/25  18:22:10  root
 ** Added include for varargs
 **
 ** Revision 1.8  1993/10/13  20:49:45  alden
 ** Took out Batchfile_entry, Logfile_entry and Stdin_entry -- use FLG_* instead
 **
 ** Revision 1.7  1993/10/11  21:34:38  alden
 ** Define the Batchfile seperator to be '\t' if BNEWS and ' ' if C News
 **
 ** Revision 1.6  1993/09/22  23:17:56  root
 ** If "sequent" is defined, then assume it isn't _POSIX_VERSION compliant  :-)
 **
 ** Revision 1.5  1993/09/22  23:16:23  root
 ** Replaced "#elif" with "#else,#if,#endif"
 **
 ** Revision 1.4  1993/05/17  15:07:14  root
 ** Added values for entry_type (in parse_entry() )
 **
 ** Revision 1.3  1993/05/12  14:40:42  alden
 ** If we don't have <values.h>, then try to fake it
 **
 ** Revision 1.2  1993/05/12  12:52:55  alden
 ** Added missing end-of-comment string
 **
 ** Revision 1.1  1993/05/05  00:05:13  alden
 ** Initial revision
 **
 **
 **/

#ifdef HAVE_VARARGS_H
#include <varargs.h>
#endif

#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>

#ifdef BNEWS
#define BATCH_SEP	'\t'
#else
#define BATCH_SEP	' '
#endif

#define Boolean	char

#ifndef HAVE_STRCHR
#define strchr		index
#define strrchr		rindex
#endif

#ifndef HAVE_MEMCPY
#define memcpy(a,b,c)    bcopy(b,a,c)
#endif

#define	MAXDIGS		11

#define USE_KEEPALIVES

#define fb_error(a)	fb_err(a)

#define READ_TIMEOUT	300	/** seconds to read timeout in read_reply() **/

#ifndef TRUE
#define TRUE		1
#define FALSE		0
#endif

#define CREATE_BATCH	TRUE
#define DONT_CREATE_BATCH	FALSE

#define DO_LOG_ERROR	TRUE
#define DONT_LOG_ERROR	FALSE

#define SEND_QUIT_MSG	TRUE
#define DONT_SEND_QUIT_MSG	FALSE

#define WANT_FILENAME	FALSE

#define FAIL		(-1)
#define MATCH		0

#define NOHOST		(FAIL-1)
#define NOSERVICE	(FAIL-2)

#define NEVER		(-1)

#define FCLOSE(fp)	{ (void) fclose(fp); (fp) = NULL; }
#define CLOSE(fd)	{ (void) close(fd); (fd) = FAIL; }

#define FREE(mp)	{ (void) free(mp); (mp) = NULL; }

#ifdef DBZ		/** If you use DBZ, then you need DBM as well. **/
#ifndef DBM
#define DBM
#endif /** DBM **/
#endif /** DBZ **/

/**
 ** <dbm.h> stupidly defines NULL, which is why the following
 ** brain death is necessary.
 **/

#ifdef DBM
# ifdef DBZ
#  include <dbz.h>
# else /** DBZ **/
#  undef NULL
#  include <dbm.h>
#  undef NULL
#  define NULL	0
# endif /** DBZ **/
#else
# ifdef NDBM
#  include <ndbm.h>
# endif /** NDBM **/
#endif /** DBM **/


#define dlogmsg	if (!Debug) ; else logmsg

#ifdef HAVE_SYS_TWG_CONFIG_H
#include <sys/twg_config.h>
#endif

extern char *errmsg();

#if defined(HAVE_TIME_H)
#include <time.h>
#endif

#if defined(HAVE_SYS_TIME_H)
#include <sys/time.h>
#else
#if defined(HAVE_SYS_TIMES_H)
#include <sys/times.h>
#endif
#endif

#if defined(STDC_HEADERS) || defined(HAVE_STDLIB_H)
#include <stdlib.h>
#include <string.h>
#else
extern char **malloc();
extern int errno;
extern int exit();
#include <strings.h>
#endif

#ifdef HAVE_ERRNO_H
#include <errno.h>
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#if defined(HAVE_SYSLOG_H) && !defined(FAKESYSLOG)
#include <syslog.h>
#else
#include "fsyslog.h"
#endif

#ifdef HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif


#if defined(HAVE_MMAP)

/**
 ** Ultrix mmap() only works on character devices
 ** NeXT mmap() is totally undocumented and doesn't work the way we want it to
 ** BSDI mmap() & NetBSD mmap() require MAP_FILE
**/

#if defined(ultrix) || defined(NeXT)
#undef HAVE_MMAP
#else
#if defined(__bsdi__) || defined(__NetBSD__)
#define MMAP_ARGS	(MAP_FILE|MAP_PRIVATE)
#else
#define MMAP_ARGS	(MAP_PRIVATE)
#endif /* __bsdi__ */
#endif /* define(ultrix) || defined(NeXT) */
#endif /* HAVE_MMAP */


/**
 ** Sequent isn't POSIX compliant even though it claims to be!
 **/
#if defined(_POSIX_VERSION) && defined(sequent)
#undef _POSIX_VERSION
#endif


/**
 ** Some machines define NULL as a pointer !?!?!?!
 **/
#ifdef NULL
#undef NULL
#endif
#define NULL		0


/**
 ** 4.2 BSD compatibility
 **/
#ifndef FD_SETSIZE
#define FD_SET(n, p)    ((p)->fds_bits[0] |=  (1<<(n)))
#define FD_CLR(n, p)    ((p)->fds_bits[0] &= ~(1<<(n)))
#define FD_ISSET(n, p)  ((p)->fds_bits[0] &   (1<<(n)))
#define FD_ZERO(p)      ((p)->fds_bits[0]  =  0)
#endif

#if defined(DIRENT) || (defined(_POSIX_VERSION) && !defined(sequent))
#include <dirent.h>
#define NLENGTH(dirent) (strlen((dirent)->d_name))
#else /* not (DIRENT or _POSIX_VERSION) */
#define dirent direct
#define NLENGTH(dirent) ((dirent)->d_namlen)
#ifdef SYSNDIR
#include <sys/ndir.h>
#endif /* SYSNDIR */
#ifdef SYSDIR
#include <sys/dir.h>
#endif /* SYSDIR */
#ifdef NDIR
#include <ndir.h>
#endif /* NDIR */
#endif /* not (DIRENT or _POSIX_VERSION) */


#define basename(s1) \
  (strrchr(s1, '/') + 1)

