.\" $Id: nntplink.man,v 1.19 1994/06/22 14:55:01 alden Exp $
.\" Copyright (c) 1991,1992,1993 David J Alden
.\" Copyright (c) 1991,1992,1993 The Ohio State University.
.\" All rights reserved.
.\"
.\" THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
.\" IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
.\" WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
.\"
.TH NNTPLINK 8 "2 May 1994"
.SH NAME
.I nntplink
\- transmit netnews articles to a remote NNTP server
.SH SYNOPSIS
.B nntplink
[
.B \-AdfkLoOqrUvVx
] [
.BI \-a " close-after"
] [
.BI \-b " batchfile"
] [
.BI \-B " batch-directory"
] [
.BI \-C " close-timeout"
] [
.BI \-D " debug-outfile"
] [
.BI \-e " exit-timeout"
] [
.BI \-E " entry-sleep"
] [
.BI \-F " datafile"
] [
.BI \-H " history-file"
] [
.BI \-i " batchfile | funnel | logfile | stdin"
] [
.BI \-l " log-after"
] [
.BI \-m " fail-minutes"
] [
.BI \-M " move-batchfile"
] [
.BI \-n " batchfile-naptime"
] [
.BI \-N " datafile-naptime"
] [
.BI \-p " decnet | tcp | dkhost"
] [
.BI \-P " port"
] [
.BI \-R " rewrite-batchfile"
] [
.BI \-s " sysname"
] [
.BI \-S " spool-directory"
] [
.BI \-T " repeat-minutes"
] [
.BI \-y " delay"
]
.I host
.SH DESCRIPTION
.B Nntplink
offers netnews articles [RFC1036] to the specified
.I host
which must be running the NNTP (Network News Transfer
Protocol, [RFC977]) server, transmitting those articles that the remote
server indicates that it does not already have.
.LP
.B Nntplink
only closes the connection when a specified number of articles have been
offered to the remote end since the last such closure (this allows the
other end to log transfer statistics)
.I or
one can request closure to take place when
.B nntplink 
has been idle for a specified amount of time.
.B Nntplink
can also be set to exit (as opposed to simply closing the connection)
when it has been idle for a specified time.
.SH OPTIONS
.TP
.B \-A
Autobackground.
Automatically runs in the background.
.TP
.B \-d
Debug.
Prints debug messages to help trace down any problems.
.TP
.B \-f
Retry fails.
If the remote site returns "436" then 
.B nntplink 
will keep on trying to offer the current offer.  (As opposed to either
saving it or junking it according to the definition in conf.h).
.TP
.B \-k
Kill old nntplink processes.
If the pid field of the datafile isn't zero (i.e., there is another nntplink
process already running to this site) -- go ahead and kill it.
.TP
.B \-L
Log closings.
Log statistics each time the connection is closed.
.TP
.B \-o
One shot.
Goes through the specified input file once.  It doesn't update the link
datafile, however it does remove the input file when it is finished.
.TP
.B \-O
Open article first.
Open the article before trying to send it.
.TP
.B \-q
Queue backlogs.  If using stdin to retrieve articles and the remote site goes
down, begin saving all incoming articles to a batchfile.  When the remote site
comes up, close the batchfile and begin sending articles from stdin again.
Note that nntplink will NOT do anything with the batchfile - you must process
it via some other method.
.TP
.B \-r
Don't report statistics.
Turns off the statistics reporting.
.TP
.B \-U
Use ".nntp" instead of ".<pid>" for the batchfile name extension.
.TP
.B \-v
Print version.
Displays the version on standard error and exits.
.TP
.B \-V
Print version and config.
Displays the version and configuration information on standard error and
exits.
.TP
.B \-x
XREPLIC.
XREPLIC is a protocol extension used by INN to permit master/slave netnews
replication.
.TP
.B \-a " close-after"
Specify the number of articles that will be offered before
.B nntplink
will close the connection to allow the remote end to log statistics.
[Default: @@CLOSE_AFTER@@]
.TP
.B \-b " batchfile"
Specify the batchfile that
.B nntplink
will use.
.TP
.B \-B " batch-directory"
Specify the directory in which the batchfile is located.
[Default: @@BATCHDIR@@]
.TP
.B \-C " close-timeout"
Specify the amount of idle time (in seconds) before
.B nntplink
closes the connection.
[Default: @@CLOSE_TIMEOUT@@]
.TP
.B \-D " debug-outfile"
Specify a debug file in which
.B nntplink
will record the debug output.  Note that nntplink will actually send debug
output to the file <debug-outfile><pid> -- adding the pid of the nntplink
process to the filename.
.TP
.B \-e " exit-timeout"
Specify the amount of idle time (in seconds) before
.B nntplink
closes the connection and exits.
[Default: @@EXIT_TIMEOUT@@]
.TP
.B \-E " entry-sleep"
Specify the amount of time (in seconds) that
.B nntplink
sleeps between checking for new input from the input file.
[Default: @@ENTRY_SLEEP@@]
.TP
.B \-F " datafile"
Specify the datafile (either the logfile or funnel file) that
.B nntplink
will use.
[Default: @@DATAFILE@@]
.TP
.B \-H " history-file"
Specify the history file that
.B nntplink
will use.  (Only used if
.B nntplink
must look up the article pathname.)
[Default: @@HISTORYFILE@@]
.TP
.B \-i " batchfile | funnel | logfile | stdin"
Specify the method which
.B nntplink
will use to get its articles.
[Default: @@DEF_INPUT_FROM@@]
.TP
.B \-l " log-after"
Specify the number of articles that will be offered before
.B nntplink
will log the statistics.
[Default: @@LOG_AFTER@@]
.TP
.B \-m " fail-minutes"
Specify the amount of time (in minutes) that must pass between
successful article transmissions before 
.B nntplink
logs an error message.
[Default: @@FAIL_MINUTES@@]
.TP
.B \-M " move-batchfile"
Specify the number of articles that will be offered before
.B nntplink
will move batchfile to batchfile.pid (or batchfile.nntp if
.B -U
was specified)
[Default: @@BATCHFILE_MOVE@@]
.TP
.B \-n " batchfile-naptime"
Specify the amount of time (in seconds) which
.B nntplink
will sleep between checks for the new batchfile.
[Default: @@BATCHFILE_NAPTIME@@]
.TP
.B \-N " datafile-naptime"
Specify the amount of time (in seconds) which
.B nntplink
will sleep between checks for the new datafile (either logfile or
funnel file).
[Default: @@DATAFILE_NAPTIME@@]
.TP
.B \-p " decnet | tcp | dkhost"
Specify the protocol which
.B nntplink
will use to connect the remote NNTP host.
[Default: @@HOST_TRANSPORT@@]
.TP
.B \-P " port"
Specify the port which nntplink should use when connecting to the
remote NNTP host.
.TP
.B \-R " rewrite-batchfile"
Specify the number of articles that will be offered before
.B nntplink
will attempt to rewrite the batchfile
[Default: @@BATCHFILE_REWRITE@@]
.TP
.B \-s " sysname"
Specify the sysname of the remote NNTP host.  This is only used for
matching the sysname in the datafile when using either the logfile
or funnel mode to get the articles.
.TP
.B \-S " spool-directory"
Specify the directory in which the news articles are spooled.
[Default: @@SPOOLDIR@@]
.TP
.B \-T " repeat-minutes"
Specify the amount of time (in minutes) which must pass after
.B nntplink
has logged a failure message before it will log another one.
[Default: @@REPEAT_MINUTES@@]
.TP
.B \-y " delay"
Specify the amount of time to delay before sending the article.  If a
timestamp is not added to each entry, it will retrieve the information
from the history file.  When using stdin mode you must ensure that the
feeding software can hold a large enough buffer, particularly if the
delay is important.  [NOTE:  If you're going to use this option regularly
in any of your newsfeeds, you most definitely want to have your news
server add the timestamp to the entry.  The overhead of looking up each
timestamp is quite large.]
.SH SIGNALS
.TP
.B TERM
The TERM signal causes
.B nntplink
to exit.  If
.B nntplink
is using the funnel file, logfile, or stdin input mode it will append to
a batchfile the rest of the unsent articles before exiting.  If it was
already processing a batchfile (i.e., there is a backlog), it will save
the current offset of the batchfile into the link datafile (so it won't
start over at the beginning of the batchfile the next time it runs).
Note that if you're using the one-shot mode, it won't save the current
offset since it doesn't have a link datafile -- you should use the
.B INT
signal to kill
.B nntplink
if you're using one-shot mode.
.TP
.B INT
The 
.B INT
signal is the same as the
.B TERM
signal with one exception.  If nntplink is processing a batchfile (either
because there is a backlog from funnel, logfile or stdin input mode, or
because it is using the one-shot mode) then it will rewrite the batchfile
to remove the already sent articles.
.TP
.B HUP
If you're using the funnel file or logfile mode, and not the one-shot 
option, then
.B nntplink
will create a batchfile containing the rest of the unsent articles and
close and reopen the datafile (either the logfile or funnel file).
This signal should be sent to 
.B nntplink
after the datafile gets recreated.
.TP
.B " "
Otherwise, it acts just like the TERM signal.
.TP
.B USR1
The USR1 signal is used to reset the fake syslog file when you are using
the FAKESYSLOG support.
.TP
.B USR2
The USR2 signal is used to start/stop debugging.  If debugging is started,
then nntplink will open a file /tmp/nntplink.<pid> and begin sending the
debugging output to it.  If it is already in debug mode, it will stop
debugging.
.SH FILES
.PD 0
.TP
.B @@BATCHDIR@@
Directory where nntplink finds the batchfile and related files.
.TP
.B <batchfile>
File in which
.B nntplink
retrieves the queued article information from.
.TP
.B <batchfile.nntp>
Temporary file which
.B nntplink
uses to store (and retrieve) the queued article information from.
.TP
.B <batchfile.fail>
File in which
.B nntplink
stores failed article information in (only if the
.B \-f
option was not specified).
.TP
.B <batchfile.link>
File in which
.B nntplink
stores its status information - used so that
.B nntplink
can keep track of its status between invocations.
.TP
.B @@HISTORYFILE@@
File which
.B nntplink
retrieves the article pathname from (if it needs to).
.TP
.B @@FUNNEL@@
File which
.B nntplink
retrieves the article information from (if using the funnel file input mode).
.TP
.B @@LOGFILE@@
File which
.B nntplink
retrieves the article information from (if using the logfile input mode).
.TP
.B @@SPOOLDIR@@
Directory where
.B nntplink
finds the articles which it sends to the remote NNTP host.
.PD
.SH "SEE ALSO"
.BR innxmit (1),
.BR nntpd (8),
.BR nntpxmit (1).
.LP
.I "RFC977 \- Network News Transfer Protocol"
.LP
.I "RFC1036 \- Standard for Interchange of USENET Messages"
.SH AUTHOR
David Alden <alden@math.ohio-state.edu>, Department of Mathematics, The Ohio
State University, Columbus, OH, USA
