/**
 ** Routine that deals with parsing the entry line.
 **
 ** $Id: entry.c,v 1.11 1994/06/22 14:46:21 alden Exp $
 **
 ** $Log: entry.c,v $
 ** Revision 1.11  1994/06/22  14:46:21  alden
 ** Fixed bug in parse_entry() in which the message_id wasn't read
 **     correctly if there was a timestamp in the entry
 **
 ** Revision 1.10  1994/01/09  18:44:50  alden
 ** Removed trailing '\n' from logmsg() calls -- syslog() will add them for us
 **
 ** Revision 1.9  1993/11/12  01:15:42  alden
 ** Fixed bug introduced in last patch which caused nntplink to ignore the first
 **     sitename listed in the entry
 **
 ** Revision 1.8  1993/11/10  18:12:33  alden
 ** Improved the efficiency of the logfile delay time parsing
 **
 ** Revision 1.7  1993/11/10  01:46:47  alden
 ** Changed all occurrences of log() to logmsg().
 **
 ** Revision 1.6  1993/10/25  18:29:49  root
 ** Rewrite Delay handling code
 **
 ** Revision 1.5  1993/10/13  20:26:40  root
 ** modified to deal with new '-y' option
 **
 ** Revision 1.4  1993/05/17  15:04:13  root
 ** Modified parse_entry() to include type of entry
 **
 ** Revision 1.3  1993/05/04  23:38:11  alden
 ** Cleaned up tabs
 **
 ** Revision 1.2  1993/04/28  19:42:23  alden
 ** Added INN "logfile" mode
 **
 ** Revision 1.1  1993/03/30  13:19:17  alden
 ** Initial revision
 **
 **
 **
 **/
#include "conf.h"
#include "readline.h"
#include "nntplink.h"

extern Boolean Debug;
extern long Delay;

extern int Xreplic;

#define SKIP(c, m) \
  for (; *entry != '\0' && *entry != c; entry++) ; \
  if (*entry == '\0') { \
    if (m != NULL) \
      dlogmsg(LOG_DEBUG, fname, \
	   "%spremature end of entry (%s): %s", m, orig_entry); \
    return FALSE; \
  }

static char month[3];
static char day[2];
static struct tm article_time;
static Boolean dumb_mortal = FALSE;
static time_t base_time;

Boolean
  parse_entry(entry, entry_type)
char *entry;
int entry_type;
{
  static char *fname = "parse_entry: ";
  char *orig_entry, *tentry, *tsysname;
  char *beg_mesgid, *end_mesgid;
  char *beg_filename, *end_filename;

#ifdef BNEWS
  char *sentto = "sent to";
#endif

  orig_entry = entry;

  /**
   ** Batchfile or STDIN format -- both are the same
   **/
  if ((entry_type == FLG_BATCHFILE) || (entry_type == FLG_STDIN)) {
    
    Article.filename = entry;

    for (; *entry != '\0' && *entry != BATCH_SEP; entry++) ;
    
    if (*entry != '\0') {
      
      *entry++ = '\0';
      Article.mesgid = entry;
      
      if (!Xreplic) {
	
	for (; *entry != '\0' && *entry != ' ' && *entry != '\t'; entry++) ;
	
	if (Article.mesgid[0] != '<' || *(entry-1) != '>')
	  return FALSE;
	
	if (*entry != '\0') {
	  *entry++ = '\0';
	  for (tentry = entry; *entry >='0' && *entry <='9'; entry++) ;
	  *entry++ = '\0';
	  Article.timeid = atol(tentry);
	}
      }
    }
    
    if (Article.filename[0] == '/' && Article.filename[1] == '\0')
      Article.filename = NULL;

  /**
   ** Funnel or Logfile format
   **
   ** Logfile format is "<date> [+|-] <message-id> site1 site2 ..." or
   **     "<date> [+|-] <message-id> filename site1 site2 ...", where
   **     <date> is something like "Oct 12 19:14:33.860"
   **
   ** INN funnel format is either "<message-id> filename site1 site2 ..."
   **     or "<timestamp> <message-id> filename site1 site2 ..."
   **/
  } else {

    if (entry_type == FLG_FUNNEL && (*entry != '<')) {

      /**
       ** check to see if it is a timestamp
       **/
      if (isdigit(*entry)) {

	for (tentry = entry; *entry >='0' && *entry <='9'; entry++)
	  ;
	*entry++ = '\0';
	Article.timeid = atol(tentry);
      }

      if (!dumb_mortal && (*entry != '<')){
	/**
	 ** Check to see if they read the README file which tells them they
	 ** needed to switch the funnel options from "Wnm" to "Wmn".  I will
	 ** grudgingly accept this mortals mistake and parse the entry, but
	 ** not without complaining at least once.  :-)
	 **/
	logmsg(LOG_WARNING, fname,
	     "%s%s: Funnel file reversed -- please read the nntplink README!");
	dumb_mortal = TRUE;
      }
    }

    if (!dumb_mortal) {
      SKIP('<', "no messageid");
      beg_mesgid = entry;
      
      SKIP('>', "bad messageid");
      end_mesgid = ++entry;
    }
    
    if (entry_type == FLG_LOGFILE) {

      for (; *entry != '\0' && *entry == ' '; entry++)
	;

      if (*entry == '(') {
      
	beg_filename = ++entry;
	
	SKIP(')', "bad pathname");
	end_filename = entry;
	
	if (*++entry == '\0')
	  return FALSE;
      } else {
	beg_filename = NULL;
	end_filename = NULL;
      }
    } else {			/* entry_type == FLG_FUNNEL */
      
      beg_filename = ++entry;	/* article file name */
      SKIP(' ', "no filename" );
      end_filename = entry;
      if (*++entry == '\0')
	return FALSE;
    }

    if (dumb_mortal) {
      SKIP('<', "no messageid");
      beg_mesgid = entry;
      
      SKIP('>', "bad messageid");
      end_mesgid = ++entry;

      if (*++entry == '\0')
	return FALSE;
    }
    
#ifdef BNEWS
    if (entry_type == FLG_LOGFILE) {

      for (; *sentto != '\0' && *sentto == *entry; entry++, sentto++) ;
      
      if (*sentto != '\0')
	return FALSE;

      if (*++entry == '\0')
	return FALSE;
    }
#endif /* BNEWS */
    
    while (*entry != '\0') {
      
      for (tentry = entry, tsysname = Host.sysname;
	   *tsysname != '\0' && *tentry == *tsysname;
	   tentry++, tsysname++) ;

      if ((*tsysname == '\0') && ((*tentry == '\0') ||
#ifdef BNEWS
				  (*tentry == ',')
#else
				  (*tentry == ' ')
#endif
				  )) {

	Article.filename = beg_filename;
	if (end_filename != NULL)
	  *end_filename = '\0';

	Article.mesgid = beg_mesgid;
	*end_mesgid = '\0';

	/**
	 ** We need to compute the article arrival time if and only if:
	 **    1) A delay was specified
	 **    2) We didn't find a timestamp in the input (logfile or funnel)
	 **    3) The entry_type is the logfile (the date is stored in it)
	 **    4) We found the filename.
	 **
	 ** If the first 3 conditions are met, but not the 4th, then we will
	 ** just grab the timestamp from the history file when we look up the
	 ** filename from it (since it is already in there, why compute it
	 ** twice).
	 **/
/*	if (Delay && (Article.timeid == 0) && (Article.filename != NULL) &&
	    (entry_type & FLG_LOGFILE)) { */
	if (Delay && (Article.timeid == 0) && 
	    (entry_type & FLG_LOGFILE)) {

	  if ((month[0] != orig_entry[0]) || (month[1] != orig_entry[1]) ||
	      (month[2] != orig_entry[2]) || (day[0] != orig_entry[4]) ||
	      (day[1] != orig_entry[5])) {
	    
	    month[0] = orig_entry[0];
	    month[1] = orig_entry[1];
	    month[2] = orig_entry[2];
	    day[0]   = orig_entry[4];
	    day[1]   = orig_entry[5];
	    
	    base_time = time(NULL);
	    article_time = *localtime(&base_time);
	    
	    strptime(orig_entry, "%h %d", &article_time);
	    article_time.tm_sec = 0;
	    article_time.tm_min = 0;
	    article_time.tm_hour = 0;
#ifdef HAVE_MKTIME
	    base_time = mktime(&article_time);
#else
#ifdef HAVE_TIMELOCAL
	    base_time = timelocal(&article_time);
#endif
#endif
	  }

	  /**
	   ** The following probably isn't very portable, however, for
	   ** now I'm more worried about speed.  This may need to be
	   ** replaced by the atoi() function!
	   **/
	  Article.timeid = base_time + 
	                   (orig_entry[7] - '0') * 36000 +
	                   (orig_entry[8] - '0') * 3600 +
			   (orig_entry[10] - '0') * 600 +
	                   (orig_entry[11] - '0') * 60 +
	                   (orig_entry[13] - '0') * 10 +
			   (orig_entry[14] - '0');
	}
	return TRUE;
      }
      
      SKIP(' ', NULL);
      *entry++;
    }
      
    return FALSE;
  }

  return TRUE;
}
