/**
 ** Routines that replace syslog().
 **
 ** $Id: fsyslog.c,v 1.1 1993/03/30 13:19:18 alden Exp $
 **
 ** $Log: fsyslog.c,v $
 ** Revision 1.1  1993/03/30  13:19:18  alden
 ** Initial revision
 **
 **
 **
 **/

/*
 * Fake syslog routines for systems that don't have syslog.
 * Taken from an idea by Paul McKenny, <mckenny@sri-unix.arpa>.
 * (Unfortunately, Paul, I can't distribute the real syslog code
 * as you suggested ... sigh.)
 *
 * Warning: this file contains joe code that may offend you.
 */

#include "conf.h"
#include "strfuns.h"

#ifdef FAKESYSLOG

#undef strsave
#undef str3save
extern char *strsave(), *str3save();
extern void sighandler();

#include "fsyslog.h"
#include <sys/signal.h>
#include <fcntl.h>

#ifdef HAVE_FDOPEN
#include <sys/file.h>
#endif

static FILE	*logfp;
static int	failed = 0;
static char	*ident = "syslog";
static int 	opt = 0;
#ifdef LOG_NFACILITIES
static int	fac = 0;
#endif

extern char	*strcpy(), *strcat(), *ctime(), *itoa();
extern time_t	time();

Boolean Reset_log;

void
resetlog()
{
    closelog();
    failed = 0;
    if (logfp == NULL) {
#ifdef LOG_NFACILITIES
	openlog(ident, opt, fac);
#else
	openlog(ident, opt);
#endif
	if (logfp == NULL) {
	    failed = 1;
	    return;
	}
    }
    Reset_log = FALSE;
}

#ifndef LOG_NFACILITIES
openlog(newident,logopt)
     char *newident;
     int logopt;
#else
     openlog(newident,logopt,facility)
     char *newident;
     int logopt, facility;
#endif
{
#ifdef HAVE_FDOPEN
    /*
     * why can't stdio give us the capability of O_APPEND?
     */
    int fd;

    if ((fd = open(FAKESYSLOG, O_WRONLY|O_APPEND|O_CREAT, 0664)) == FAIL)
      logfp = NULL;
    else
      logfp = fdopen(fd, "a+");
#else
    logfp = fopen(FAKESYSLOG, "a+");
#endif

    (void)signal(SIGUSR1, sighandler);

    if (newident && *newident)
      ident = newident;
    opt = logopt;
#ifdef LOG_NFACILITIES
    fac = facility;
#endif
}

closelog()
{
    if (logfp) {
	(void)fclose(logfp);
	failed = 0;
	logfp = NULL;
    }
}

/*ARGSUSED*/
setlogmask(maskpri)
	int maskpri;
{
}

/*ARGSUSED*/
/*VARARGS2*/
syslog(pri, msg, x1, x2, x3, x4, x5, x6, x7, x8)
     int	pri;
     char	*msg, *x1, *x2, *x3, *x4, *x5, *x6, *x7, *x8;
{
    time_t	clock;
    char	*entry, *tentry, *tpid;

    if (Reset_log)
      resetlog();

    if (failed)
      return;

    if (logfp == NULL) {
#ifdef LOG_NFACILITIES
	openlog(ident, opt, fac);
#else
	openlog(ident, opt);
#endif
	if (logfp == NULL) {
	    failed = 1;
	    return;
	}
    }

    (void) time(&clock);
    entry = strsave(ctime(&clock)+4);
    entry[strlen(entry) - 5] = '\0';

    if (ident)
      tentry = str3save(entry, "localhost ", ident);
    else
      tentry = str2save(entry, "localhost ");
    FREE(entry);

    if (opt&LOG_PID) {
	/* don't cache getpid() - who knows when we'll fork() */
	tpid = str3save("[", itoa(getpid()), "]");
	entry = str2save(tentry, tpid);
	FREE(tentry);
	FREE(tpid);
	tentry = entry;
    }

    if (ident) {
	entry = str2save(tentry, ": ");
	FREE(tentry);
    } else {
	entry = str2save(tentry, " ");
	FREE(tentry);
    }

    tentry = str2save(entry, msg);
    FREE(entry);

    if (tentry[strlen(tentry)-1] != '\n') {
	entry = str2save(tentry, "\n");
	FREE(tentry);
	tentry = entry;
    }

    fprintf(logfp, tentry, x1, x2, x3, x4, x5, x6, x7, x8);
    (void) fflush(logfp);
    FREE(tentry);
}

#endif /* !HAVE_SYSLOG_H */
