/**
 ** Routines that deal with the news history file.
 **
 ** $Id: history.c,v 1.6 1994/02/11 14:24:35 root Exp $
 **
 ** $Log: history.c,v $
 ** Revision 1.6  1994/02/11  14:24:35  root
 ** Modified fail() call to include sleep_time (if necessary)
 **
 ** Revision 1.5  1994/01/09  18:45:06  alden
 ** Removed trailing '\n' from logmsg() calls -- syslog() will add them for us
 **
 ** Revision 1.4  1993/12/20  14:40:58  alden
 ** Replaced "Host.name" with "Host.sysname" in fail() and logmsg() calls
 **
 ** Revision 1.3  1993/11/10  01:47:06  alden
 ** Changed all occurrences of log() to logmsg().
 **
 ** Revision 1.2  1993/10/13  20:26:42  root
 ** modified to deal with new '-y' option
 **
 ** Revision 1.1  1993/03/30  13:19:19  alden
 ** Initial revision
 **
 **
 **
 **/
#include "conf.h"

#include "strfuns.h"
#include <fcntl.h>
#include <ctype.h>
#include <sys/param.h>
#include "readline.h"
#include "nntplink.h"
/*
 - get_history_entry -- return the path name of an article from history file
 *
 *	Parameters:	"msg_id" is the message ID of the
 *			article, enclosed in <>'s.
 *			"lookup", only check if article exists
 *
 *	Returns:	A char pointer to a static data area
 *			containing the full pathname of the
 *			article, or NULL if the message-id is not
 *			in the history file.
 *
 *	Side effects:	opens dbm database
 *			(only once, keeps it open after that).
 *			If running Bnews, converts "msg_id" to lower case.
 *			If running Cnews, converts "msg_id" per rfc822.
 *
 */

extern char *History_file;

extern char *E_open;
extern char *E_fseek;

extern void logmsg();
extern void fail();

#ifdef DBM
static Boolean	dbopen = FALSE;
#endif

#ifdef NDBM
static DBM	*db = NULL;	/* History file, dbm version */
#endif

static int	hfd = FAIL;	/* history file, text version */
static FileBuf *hfbp = NULL;

char *
  get_history_entry(msg_id, lookup, arrival_date)
char		*msg_id;
int		lookup;
time_t		*arrival_date;
{
    char		*fname = "get_history_entry: ";
    char		*tmp;
    register char	*cp;
    long		ltmp;
#ifdef DBM
    datum		fetch();
#endif /* DBM */
    datum		 key, content;

#ifndef BNEWS
    cp = strrchr(msg_id,'@');	/* look for @ in message id */
    if( cp != NULL) {
	for(;*cp != '\0';++cp)
#else
    {
	for (cp = msg_id; *cp != '\0'; ++cp)
#endif
	  if (isupper(*cp))
	    *cp = tolower(*cp);
/* Make ctags happy */
#ifndef BNEWS
    }
#else
    }
#endif
#ifdef DBM
    if (!dbopen) {
	if (dbminit(History_file) < 0) {
	    logmsg(LOG_ERR, fname, "%s%s: dbminit %s: %s", Host.sysname,
		   History_file, errmsg(errno));
	    return NULL;
	} else
	  dbopen = TRUE;
    }
#else /* ndbm */
    if (db == NULL) {
	db = dbm_open(History_file, O_RDONLY, 0);
	if (db == NULL) {
	    logmsg(LOG_ERR, fname, "%s%s: dbm_open %s: %s", Host.sysname,
		   History_file, errmsg(errno));
	    return NULL;
	}
    }
#endif /* DBM */

    key.dptr = msg_id;
    key.dsize = strlen(msg_id) + 1;

#ifdef DBM
    content = fetch(key);
#else /* ndbm */
    content = dbm_fetch(db, key);
#endif /* DBM */
    if (content.dptr == NULL)
      return NULL;

    /*
     * If we are just checking to see if it exists return a non-NULL
     * result
     */
    if (lookup)
      return (char *)1;

    if (hfd == FAIL) {
	if ((hfd = open(History_file, O_RDONLY)) == FAIL) {
	    logmsg(LOG_ERR, fname, E_open, Host.sysname, History_file, "r",
		   errmsg(errno));
	    return NULL;
	}
	hfbp = fb_fdopen(hfd);
    }

    memcpy((char *)&ltmp, content.dptr, sizeof (long));
    if (fb_seek(hfbp, ltmp, 0) < 0) {
	logmsg(LOG_ERR, fname, E_fseek, Host.sysname, History_file,
	       errmsg(errno));
	return NULL;
    }

    tmp = fb_readline(hfbp, NULL);

    if (fb_error(hfbp))
      fail(fname, 0, "%s%s: error while reading history file: %s",
	   Host.sysname, errmsg(errno));

    if ((cp = strchr(tmp, '\n')) != NULL)
      *cp = '\0';

    cp = strchr(tmp, '\t');

    if (cp != NULL) {
      if (arrival_date != NULL)
	*arrival_date = (time_t)atol(cp);
      cp = strchr(cp+1, '\t');
    } else
      logmsg(LOG_ERR, fname,
	     "%s%s: malformed line in history file at %ld bytes, id %s",
	     Host.sysname, ltmp, msg_id);

    if (cp == NULL)
      return NULL; /* this article has expired */

    tmp = cp+1;

    if ((cp = strchr(tmp, ' ')) != NULL)
      *cp = '\0';

    while ((cp = strchr(tmp, '.')) != NULL)
      *cp = '/';

    return tmp;
}

void
  close_history()
{
#ifdef DBM
    if (dbopen) {
	dbmclose();
	dbopen = FALSE;
    }
#else /* ndbm */
    if (db != NULL)
      dbm_close();
#endif

    if (hfd != FAIL) {
	CLOSE(hfd);
	fb_close(hfbp);
    }

    return;
}
