/**
 ** Routine that sends "IHAVE <mesgid>" to remote host.
 **
 ** $Id: ihave.c,v 1.6 1994/01/09 18:45:13 alden Exp $
 **
 ** $Log: ihave.c,v $
 ** Revision 1.6  1994/01/09  18:45:13  alden
 ** Removed trailing '\n' from logmsg() calls -- syslog() will add them for us
 **
 ** Revision 1.5  1993/12/20  14:41:03  alden
 ** Replaced "Host.name" with "Host.sysname" in fail() and logmsg() calls
 **
 ** Revision 1.4  1993/11/10  01:48:04  alden
 ** Changed all occurrences of log() to logmsg().
 **
 ** Revision 1.3  1993/10/25  18:29:09  root
 ** Modified accepted/rejected logging logic (hopefully it is correct  :-)
 **
 ** Revision 1.2  1993/05/04  23:38:16  alden
 ** Cleaned up tabs
 **
 ** Revision 1.1  1993/03/30  13:19:20  alden
 ** Initial revision
 **
 **
 **
 **/
#include "conf.h"
#include "readline.h"
#include "nntplink.h"
#include "nntp.h"
#include "strfuns.h"

extern void close_article();
extern char *converse();
extern void logmsg();
extern Boolean open_article();
extern Boolean send_command();
extern void xmitauth();

extern Boolean Debug;
extern int Xreplic;

static char *tmesgid = NULL;

char *
  send_ihave_msg(resp)
int *resp;
{
  static char *fname = "send_ihave_msg: ";
  
  Boolean done = FALSE;
  char *reply;
  char *line, *id, *end_id, *msgid = "message-id:";
  
  if (Article.mesgid == NULL) {
    
    if (!open_article()) {
      *resp = ERR_NOFILE_CONT;
      return NULL;
    }
    
    while(!done && ((line = fb_readline(Article.fbp, NULL)) != NULL))
      switch(*line) {
      case '\n':		/* EOH, we failed */
	done = TRUE;
	break;
      case 'M':
      case 'm':
	if ((strchr(line, ':') == NULL) ||
	    (strncasecmp(line, msgid, 11) != 0) ||
	    ((id = strchr(line, '<')) == NULL) ||
	    ((end_id = strchr(line, '>')) == NULL))
	  continue;		/* not the message-id: header */
	
	*++end_id = '\0';
	if (tmesgid != NULL)
	  FREE(tmesgid);
	tmesgid = strsave(id);
	Article.mesgid = tmesgid;
	done = TRUE;
	break;
      }
    
    if (fb_error(Article.fbp))
      logmsg(LOG_INFO, fname, "%s%s: error reading %s: %s", Host.sysname,
	     Article.filename, errmsg(errno));
    
    (void)fb_seek(Article.fbp, 0L, 0);
    
    if (Article.mesgid == NULL) {
      logmsg(LOG_INFO, fname, "%s%s: Message-id missing from %s!",
	     Host.sysname, Article.filename);
      close_article();
      *resp = ERR_NOMSGID;
      return NULL;
    }
  }
  
  Stats.offered++;
  Stats.since_close++;
  
  do {
    done = TRUE;
    
    line = str2save(Xreplic? "XREPLIC ": "IHAVE ", Article.mesgid);
    
    reply = converse(line, resp);
    FREE(line);
    
    if (*resp == FAIL)
      return NULL;
    
    switch(*resp) {
      
    case CONT_XFER:
      if (!open_article()) {
	if (send_command(".", DO_LOG_ERROR))
	  *resp = ERR_NOFILE;
	else
	  *resp = ERR_UNKNOWN;

	Stats.failed++;
      }
      break;
      
    case ERR_GOTIT:
      Stats.rejected++;
      break;
      
    case ERR_NOAUTH:
      xmitauth(Host.name);
      done = FALSE;
      break;
      
    default:
      break;
    }
  } while (!done);
  
  return reply;
}
