/**
 ** Main routine.
 **
 ** $Id: nntplink.c,v 1.19 1994/06/22 15:02:52 root Exp $
 **
 ** $Log: nntplink.c,v $
 ** Revision 1.19  1994/06/22  15:02:52  root
 ** If send_news() returned an error, and we're in one-shot mode, then we
 **     want to make sure to rewrite the batchfile before we exit so we
 **     don't resend any of the already sent articles (this is done by
 **     faking Int_signaled)
 **
 ** Revision 1.18  1994/06/16  13:33:58  alden
 ** The default for Datafile.name is now set in parseargs.c
 **
 ** Revision 1.17  1994/05/02  13:32:20  root
 ** Changed Abort_signaled to Term_signaled
 **
 ** Revision 1.16  1994/02/19  16:38:44  alden
 ** NetBSD doesn't seem to have sysconf() even though it defines _POSIX_VERSION
 **
 ** Revision 1.15  1994/01/09  18:46:13  alden
 ** Removed trailing '\n' from logmsg() calls -- syslog() will add them for us
 **
 ** Revision 1.14  1993/12/20  14:41:06  alden
 ** Replaced "Host.name" with "Host.sysname" in fail() and logmsg() calls
 **
 ** Revision 1.13  1993/11/22  14:20:48  alden
 ** postconf.h undef's _POSIX_VERSION now if sequent is defined
 **
 ** Revision 1.12  1993/11/10  01:48:46  alden
 ** Changed all occurrences of log() to logmsg().
 **
 ** Revision 1.11  1993/10/13  20:26:45  root
 ** modified to deal with new '-y' option
 **
 ** Revision 1.10  1993/10/10  20:32:48  alden
 ** If __386BSD__ is defined, assume it doesn't have sysconf()
 **
 ** Revision 1.9  1993/09/22  23:22:25  root
 ** If "sequent" is defined, then assume it isn't _POSIX_VERSION compliant  :-)
 **
 ** Revision 1.8  1993/06/29  19:02:20  alden
 ** Replaced "#elif" with "#else,#if,#endif"
 **
 ** Revision 1.7  1993/05/12  13:07:23  alden
 ** abort_nntplink() if send_news() errors and One_shot
 **
 ** Revision 1.6  1993/05/05  14:17:13  root
 ** Changed check_sleep() call to always set the create_batchfile variable
 **
 ** Revision 1.5  1993/05/04  23:38:30  alden
 ** Cleaned up tabs
 **
 ** Revision 1.4  1993/05/04  20:51:39  alden
 ** Added Queue_backlog definition
 **
 ** Revision 1.3  1993/04/20  00:33:07  alden
 ** Added E_closedir error message
 **
 ** Revision 1.2  1993/04/17  22:27:52  root
 ** Added Batch Directory to Batchfile struct
 **
 ** Revision 1.1  1993/03/30  13:19:23  alden
 ** Initial revision
 **
 **
 **
 **/
#include "conf.h"
#include "readline.h"
#include "nntplink.h"

Bfile_struct Batchfile = {
  NULL,
  NULL,
  NULL,
  NULL,
  0L,
  0,
  NULL,
  BATCHFILE_NAPTIME,
  TRUE,
  FALSE,
};

Dfile_struct Datafile = {
  NULL,
  0L,
  0,
  NULL,
  DATAFILE_NAPTIME,
};

Host_struct Host = {
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  HOST_TRANSPORT,
  FALSE,
};

Art_struct Article = {
  NULL,
  NULL,
  NULL,
  0,
  NULL,
};

Stats_struct Stats = {
  0L,
  0L,
  0L,
  0L,
  0L,
  0L,
};

Time_struct Time = {
  0L,
  0.,
  0.,
  0L,
  0L,
  0.,
  0.,
};

FileBuf *Stdin = NULL;		/* fbp used by readline */

char *Prog_name;
pid_t Prog_pid;

int Close_after = CLOSE_AFTER;
int Log_after = LOG_AFTER;
long Dtablesize;

Boolean Log_close = FALSE;

Boolean Open_art_first = FALSE;

Boolean Queue_backlog = FALSE;
FILE *Queue_fp = NULL;

long Success_time, Report_time = 0L;
long Delay = 0L;

long Failure_naptime = NAPTIME;
     
long Fail_minutes = FAIL_MINUTES;
long Repeat_minutes = REPEAT_MINUTES;

long Close_timeout = CLOSE_TIMEOUT;
long Exit_timeout = EXIT_TIMEOUT;
long Entry_sleep = ENTRY_SLEEP;

long Idle_time = 0L;

char *E_chdir = "%s%s: chdir(%s): %s";
char *E_closedir = "%s%s: closedir(%s): %s";
char *E_fcntl = "%s%s: fcntl(%s, %s): %s";
char *E_fdopen = "%s%s: fdopen(%d, \"%s\"): %s";
char *E_fopen = "%s%s: fopen(%s, \"%s\"): %s";
char *E_fstat = "%s%s: fstat(%s): %s";
char *E_fseek = "%s%s: fseek(%s): %s";
char *E_open = "%s%s: open(%s, \"%s\"): %s";
char *E_read = "%s%s: error reading: %s";
char *E_rename = "%s%s: rename(%s, %s): %s";
char *E_unlink = "%s%s: unlink(%s): %s";
char *E_write = "%s%s: error writing: %s";

extern Boolean Debug;
extern int Input_from;
extern Boolean Int_signaled;
extern Boolean One_shot;
extern Boolean Term_signaled;
     
extern void abort_nntplink();
extern void check_batchfile();
extern void check_sleep();
extern void logmsg();
extern void parse_args();
extern Boolean send_news();
extern void setup_proc();
extern void update_batchfile();

main(argc, argv)
     int argc;
     char *argv[];
{
  int fd;
  static char *fname = "main: ";
  long current_time;
  long fail, repeat;
  
#ifdef DEBUG_MAL
  mal_debug(3);
#endif
  
#if defined(_POSIX_VERSION) && !defined(__386BSD__) && !defined(__NetBSD__)
  Dtablesize = sysconf(_SC_OPEN_MAX);
#else
#if HAVE_GETDTABLESIZE
  Dtablesize = (long)getdtablesize();
#else
  Dtablesize = 64;
#endif
#endif
  
  for (fd = Dtablesize - 1; fd > 2; fd--)
    (void) close(fd);
  
  parse_args(argc, argv);
  
  setup_proc();
  
  for (;;) {
    
    if (Batchfile.use && (Batchfile.fbp == NULL))
      check_batchfile();
    
    if (!send_news()) {
      
      current_time = time(NULL);
      
      fail = (current_time - Success_time) / 60;
      repeat = (current_time - Report_time) / 60;
      
      if ((fail >= Fail_minutes) &&
	  (repeat >= Repeat_minutes)) {
	
	logmsg(LOG_WARNING, fname, "%s%s: Link down for %ld hours",
	       Host.sysname, (long)(fail / 60));
	Report_time = time(NULL);
      }
      
      if ((fail >= SPOOL_MINUTES) &&
	  ((Input_from & FLG_FUNNEL) || (Input_from & FLG_LOGFILE)))
	update_batchfile();
      
      if (One_shot) {
	dlogmsg(LOG_DEBUG, fname, "%ssend_news() returned error - exiting");
	Int_signaled = TRUE;
	Term_signaled = TRUE;
	abort_nntplink();
      } else
	dlogmsg(LOG_DEBUG, fname,
	     "%ssend_news() returned error - sleeping for %d seconds",
	     Failure_naptime);

      check_sleep(Failure_naptime, TRUE);
      
      if ((Failure_naptime *= 2)> MAX_NAPTIME)
	Failure_naptime = MAX_NAPTIME;
    }
  }
}
