/**
 ** Routine that parses the arguments.
 **
 ** $Id: parseargs.c,v 1.30 1994/06/16 13:33:01 alden Exp $
 **
 ** $Log: parseargs.c,v $
 ** Revision 1.30  1994/06/16  13:33:01  alden
 ** The default for Datafile.name is now dependent on the type of input file
 **
 ** Revision 1.29  1994/06/08  13:57:12  alden
 ** Added code to prevent user from specifying "-o" and either "-R" or "-M"
 **
 ** Revision 1.28  1994/02/20  18:41:59  alden
 ** Removed '-c', added '-M' and '-R'
 **
 ** Revision 1.27  1994/02/11  14:27:25  root
 ** Modified fail() call to include sleep_time (if necessary)
 **
 ** Revision 1.26  1994/02/04  00:11:13  alden
 ** Complain about arguments after the sitename
 **
 ** Revision 1.25  1994/01/09  18:46:19  alden
 ** Removed trailing '\n' from logmsg() calls -- syslog() will add them for us
 **
 ** Revision 1.24  1993/12/22  00:56:19  root
 ** Redefined "-f" option (check man page for new definition)
 **
 ** Revision 1.23  1993/12/20  14:41:07  alden
 ** Replaced "Host.name" with "Host.sysname" in fail() and logmsg() calls
 **
 ** Revision 1.22  1993/11/27  22:08:31  alden
 ** Removed "-I" option
 **
 ** Revision 1.21  1993/11/19  20:44:24  alden
 ** Cleaned up some of the debugging messages (spacing)
 ** Added code to use begin_debugging()
 **
 ** Revision 1.20  1993/11/12  01:21:06  alden
 ** Moved "Prog_pid = getpid()" back to setup_proc() where it belongs!
 **
 ** Revision 1.19  1993/11/10  01:48:59  alden
 ** Changed all occurrences of log() to logmsg().
 **
 ** Revision 1.18  1993/11/09  17:33:22  root
 ** Changed "-D" so it tacks on <pid> to output file name.
 **
 ** Revision 1.17  1993/11/04  20:12:04  root
 ** Added "-I" (ignore pid in datafile) option
 **
 ** Revision 1.16  1993/10/21  17:35:35  root
 ** Removed the LOOKUP_ARTICLE dependencies
 ** Added warning about using Delay with Logfile will cause history lookup
 **
 ** Revision 1.15  1993/10/13  20:26:46  root
 ** modified to deal with new '-y' option
 **
 ** Revision 1.14  1993/09/30  21:47:09  alden
 ** Added a missing "break" in the "case 'y'" statement
 **
 ** Revision 1.13  1993/06/29  19:02:34  alden
 ** Replaced "#elif" with "#else,#if,#endif"
 **
 ** Revision 1.12  1993/05/28  12:53:21  alden
 ** Fixed #ifdef
 **
 ** Revision 1.11  1993/05/17  15:04:49  root
 ** Added debug message specifying "News Type" (either BNEWS, CNEWS, or INN)
 **
 ** Revision 1.10  1993/05/11  00:06:50  alden
 ** Added '-k' option
 **
 ** Revision 1.9  1993/05/05  18:41:05  root
 ** Fixed logic error when checking for both "-A" and "-d" options
 **
 ** Revision 1.8  1993/05/05  14:18:14  root
 ** Set Batchfile.use to FALSE if Queue_backlog is TRUE
 **
 ** Revision 1.7  1993/05/04  23:38:33  alden
 ** Cleaned up tabs
 **
 ** Revision 1.6  1993/05/04  20:54:27  alden
 ** Added "-q" option
 **
 ** Revision 1.5  1993/05/04  19:44:20  alden
 ** Moved Batchfile.tmp from parse_args() to setup_proc()
 **
 ** Revision 1.4  1993/04/28  22:29:49  alden
 ** Modified so you can specify "-A" and "-D <file>"
 **
 ** Revision 1.3  1993/04/17  22:28:57  root
 ** Changed logmsg() messages to include filename
 **
 ** Revision 1.2  1993/04/16  21:24:58  alden
 ** Move Batchfile.nname from parse_args() to setup_proc()
 **
 ** Revision 1.1  1993/03/30  13:19:24  alden
 ** Initial revision
 **
 **
 **
 **/
#include "conf.h"
#include "readline.h"
#include "nntplink.h"
#include "patchlevel.h"
#include "strfuns.h"

#include <sys/stat.h>

extern int Batchfile_move;
extern int Batchfile_rewrite;
extern int Close_after;
extern long Close_timeout;
extern long Delay;
extern long Entry_sleep;
extern long Exit_timeout;
extern long Fail_minutes;
extern int Log_after;
extern Boolean Log_close;
extern Boolean Open_art_first;
extern Boolean Queue_backlog;
extern char *Prog_name;
extern long Repeat_minutes;
extern Boolean Report_stats;

extern char *E_chdir;
extern char *E_fopen;

extern char *optarg;
extern int optind, opterr;

extern void begin_debugging();
extern void fail();
extern void logmsg();

Boolean Autobackground = FALSE;
Boolean Debug = FALSE;
FILE *Debugfp = stderr;
char *History_file = HISTORYFILE;
int Input_from = DEF_INPUT_FROM;
Boolean Kill_oldlink = FALSE;
int Nntp_port = 0;
Boolean One_shot = FALSE;
Boolean Retry_fails = FALSE;
Boolean Use_nntp_ext = FALSE;
int Xreplic = FALSE;


void
  parse_args(argc, argv)
int argc;
char *argv[];
{
  static char *fname = "parse_args: ";
  int c, errflg=0, t;
  char *batchname = NULL,
       *tfile = NULL,
       *tfile2 = NULL,
       *batchdir = BATCHDIR,
       *spooldir = SPOOLDIR;
  Boolean set_M_opt = FALSE, set_R_opt = FALSE;
  Boolean c_news_batch = FALSE;
  Boolean print_version = FALSE;
  struct stat qst;
  pid_t cur_pid;
  
  if ((Prog_name = strrchr(argv[0], '/')) != NULL)
    Prog_name++;
  else
    Prog_name = argv[0];
  
  cur_pid = getpid();
  
  opterr = 0;
  while ((c = getopt(argc, argv,
	        "a:Ab:B:C:dD:e:E:fF:H:i:kl:Lm:M:n:N:oOp:P:qrR:s:S:T:UvVxy:"))
	 != EOF)
    switch (c) {
    case 'a':
      Close_after = atoi(optarg);
      break;
    case 'A':
      Autobackground = TRUE;
      break;
    case 'b':
      batchname = optarg;
      break;
    case 'B':
      batchdir = optarg;
      break;
    case 'C':
      Close_timeout = atol(optarg);
      break;
    case 'd':
      Debug = TRUE;
      break;
    case 'D':
      Debug = TRUE;
      begin_debugging(optarg, cur_pid);
      break;
    case 'e':
      Exit_timeout = atol(optarg);
      break;
    case 'E':
      Entry_sleep = atol(optarg);
      break;
    case 'f':
      Retry_fails = TRUE;
      break;
    case 'F':
      Datafile.name = optarg;
      break;
    case 'H':
      History_file = optarg;
      break;
    case 'i':
      if (strcmp(optarg, "batchfile") == MATCH)
	Input_from = FLG_BATCHFILE;
      else if (strcmp(optarg, "funnel") == MATCH)
	Input_from = FLG_FUNNEL;
      else if (strcmp(optarg, "logfile") == MATCH)
	Input_from = FLG_LOGFILE;
      else if (strcmp(optarg, "stdin") == MATCH)
	Input_from = FLG_STDIN;
      else
	errflg++;
      break;
    case 'k':
      Kill_oldlink = TRUE;
      break;
    case 'l':
      Log_after = atoi(optarg);
      break;
    case 'L':
      Log_close = TRUE;
      break;
    case 'm':
      Fail_minutes = atol(optarg);
      break;
    case 'M':
      set_M_opt = TRUE;
      Batchfile_move = atoi(optarg);
      break;
    case 'n':
      Batchfile.nap_time = atol(optarg);
      break;
    case 'N':
      Datafile.nap_time = atol(optarg);
      break;
    case 'o':
      One_shot = TRUE;
      break;
    case 'O':
      Open_art_first = TRUE;
      break;
    case 'p':
      if (strcmp(optarg, "decnet") == 0)
	Host.transport = T_DECNET;
      else if (strcmp(optarg, "tcp") == 0)
	Host.transport = T_IP_TCP;
      else if (strcmp(optarg, "dkhost") == 0)
	Host.transport = T_DKHOST;
      else
	errflg++;
      break;
    case 'P':
      Nntp_port = atoi(optarg);
      break;
    case 'q':
      Queue_backlog = TRUE;
      Batchfile.use = FALSE;
      break;
    case 'r':
      Report_stats = FALSE;
      break;
    case 'R':
      set_R_opt = TRUE;
      Batchfile_rewrite = atoi(optarg);
      break;
    case 's':
      Host.sysname = optarg;
      break;
    case 'S':
      spooldir = optarg;
      break;
    case 'T':
      Repeat_minutes = atol(optarg);
      break;
    case 'U':
      Use_nntp_ext = TRUE;
      break;
    case 'v':
      fprintf (stderr, "%s %sPL%s %s\n", Prog_name, RELEASE,
	       PATCHLEVEL, DATE);
      exit(0);
      /*NOTREACHED*/
    case 'V':
      print_version = TRUE;
      Debug = TRUE;
      break;
    case 'x':
      Xreplic = TRUE;
      break;
    case 'y':
      Delay = atoi(optarg);
      if (Delay == 0)
	Delay = 120;
      break;
    default:
      errflg++;
    }
  
  if (optind < argc) {
    Host.name = argv[optind++];
    /**
     ** Check for extra arguments
     **/
    if (optind < argc)
      errflg++;
  } else {
    if (print_version)
      Host.name = strsave("<none-given>");
    else
      errflg++;
  }

#if !defined(HAVE_MKTIME) && !defined(HAVE_TIMELOCAL)
  if (Input_from & FLG_LOGFILE)
    dlogmsg(LOG_INFO, fname,
	  "%sNo routine to convert time, will use history file to get time");
#endif

  
  if (Xreplic && ((Input_from & FLG_FUNNEL) || (Input_from & FLG_LOGFILE))) {
    fprintf(stderr,
	    "%s: Xreplic cannot be used with the LOGFILE or FUNNEL mode\n",
	    Prog_name);
    errflg++;
  }
  
  if (Queue_backlog && !(Input_from & FLG_STDIN)) {
    fprintf(stderr, "%s: -q can only be used with -i stdin\n", Prog_name);
    errflg++;
  }
  
  if (errflg) {
    fprintf(stderr, "usage: %s [options] hostname\n", Prog_name);
    if (!print_version)
      exit(FAIL);
  }
  
  if (Datafile.name == NULL) {
    if (Input_from & FLG_FUNNEL)
      Datafile.name = FUNNEL;
    else
      Datafile.name = LOGFILE;
  }
  
  if (Autobackground && (One_shot || (Debug && (Debugfp == stderr)))) {
    fprintf(stderr, "%s: Cannot use -A and %s\n", Prog_name,
	    Debug ? "-d" : "-o");
    exit(FAIL);
  }
  
  /*
   * If our umask is 0, set it to 2, otherwise set it back to what it was.
   */
  
  if ((t = umask(2)) != 0)
    umask(t);

  if (!One_shot) {

    if ((t = Batchfile_move / Log_after) < 1)
      t = 1;
  
    if (Batchfile_move != (t * Log_after)) {
      fprintf(stderr, "%s: -M isn't a multiple of -l\n", Prog_name);
      fprintf(stderr, "     using %d for -M instead\n", (t * Log_after));
    }

    Batchfile_move = t * Log_after;
  
    if ((t = Batchfile_rewrite / Log_after) < 1)
      t = 1;
  
    if (Batchfile_rewrite != (t * Log_after)) {
      fprintf(stderr, "%s: -R isn't a multiple of -l\n", Prog_name);
      fprintf(stderr, "     using %d for -R instead\n", (t * Log_after));
    }

    Batchfile_rewrite = t * Log_after;

  } else if (set_M_opt || set_R_opt) 
    fprintf(stderr, "%s: Cannot specify -%c option with -o\n", Prog_name,
	    set_M_opt ? 'M' : 'R');
  
  if (chdir(spooldir) == FAIL)
    logmsg(LOG_WARNING, fname, E_chdir, Host.sysname, spooldir, errmsg(errno));
  
  if (Host.sysname == NULL)
    Host.sysname = Host.name;
  
  if (batchname == NULL)
    tfile = str3save(batchdir, "/", Host.name);
  else if (*batchname == '/')
    tfile = strsave(batchname);
  else
    tfile = str3save(batchdir, "/", batchname);
  
  if (stat(tfile, &qst) == FAIL) {
    
    if (errno == ENOENT) {
      if (!print_version)
	dlogmsg(LOG_INFO, fname,
		"%s%s doesn't exist, assuming it's the name of a batchfile",
		tfile);
    } else
      fail(fname, 0, "%s%s: stat(%s) failed: %s", Host.sysname, tfile,
	   errmsg(errno));
  } else if ((qst.st_mode & S_IFMT) == S_IFREG) {
    dlogmsg(LOG_DEBUG, fname, "%s%s is a batchfile", tfile);
  } else if ((qst.st_mode & S_IFMT) == S_IFDIR) {
    dlogmsg(LOG_DEBUG, fname, "%s%s is a batch directory", tfile);
    c_news_batch = TRUE;
  } else {
    fail(fname, 0,
	 "%s%s: %s is not a directory or a regular file, st_mode = %o",
	 Host.sysname, tfile, qst.st_mode);
  }
  
  if (c_news_batch) {
    Batchfile.name = str2save(tfile, "/togo");
    Host.failfile = str2save(tfile, "/togo.fail");
    Host.datafile = str2save(tfile, "/togo.link");
    Batchfile.dir = strsave(tfile);
  } else {
    Batchfile.name = strsave(tfile);
    Host.failfile = str2save(tfile, ".fail");
    Host.datafile = str2save(tfile, ".link");
    tfile2 = strrchr(tfile, '/');
    *tfile2 = NULL;
    Batchfile.dir = strsave(tfile);
  }
  
  FREE(tfile);
  
  if (Debug) {
    logmsg(LOG_DEBUG, "",
	"%sConfiguration information:");
    logmsg(LOG_DEBUG, "",
	"%s Version:                         %sPL%s %s", RELEASE,
	PATCHLEVEL, DATE);
    logmsg(LOG_DEBUG, "",
	"%s News Type:                       %s",
#if defined(BNEWS)
	"BNEWS"
#else
#if defined(CNEWS)
	"CNEWS"
#else
	"INN"
#endif
#endif
	);
    logmsg(LOG_DEBUG, "",
	"%s Host:                            %s", Host.name);
    logmsg(LOG_DEBUG, "",
	"%s Spool directory:                 %s", spooldir);
    logmsg(LOG_DEBUG, "",
	"%s Batch directory:                 %s", Batchfile.dir);
    logmsg(LOG_DEBUG, "",
	"%s Batch file:                      %s",
	basename(Batchfile.name));
    logmsg(LOG_DEBUG, "",
	"%s Fail file:                       %s",
	strrchr(Host.failfile, '/') + 1);
    if (!One_shot) {
      logmsg(LOG_DEBUG, "",
	  "%s Link Data file:                  %s",
	  strrchr(Host.datafile, '/') + 1);
      if ((Input_from & FLG_FUNNEL) || (Input_from & FLG_LOGFILE)) {
	logmsg(LOG_DEBUG, "",
	    "%s %s                     %s",
	    ((Input_from & FLG_FUNNEL) ? "Funnel file:" : "Logfile:    "),
	    Datafile.name);
	logmsg(LOG_DEBUG, "",
	    "%s Sysname:                         %s", Host.sysname);
      }
      logmsg(LOG_DEBUG, "",
	  "%s History file:                    %s", History_file);
    } else
      logmsg(LOG_DEBUG, "", "%s One shot?:                       TRUE");
    if (Host.transport == T_IP_TCP)
      logmsg(LOG_DEBUG, "",
	  "%s Connection Type:                 TCP/IP");
    else if (Host.transport == T_DECNET)
      logmsg(LOG_DEBUG, "",
	  "%s Connection Type:                 DECNET");
    else
      logmsg(LOG_DEBUG, "",
	  "%s Connection Type:                 DKHOST");
    if (Input_from & FLG_BATCHFILE)
      logmsg(LOG_DEBUG, "",
	  "%s Input file type:                 Batchfile");
    else if (Input_from & FLG_FUNNEL)
      logmsg(LOG_DEBUG, "",
	  "%s Input file type:                 Funnel");
    else if (Input_from & FLG_LOGFILE)
      logmsg(LOG_DEBUG, "",
	  "%s Input file type:                 Logfile");
    else {
      logmsg(LOG_DEBUG, "",
	  "%s Input file type:                 <stdin>");
      logmsg(LOG_DEBUG, "",
	  "%s Queue backlog?:                  %s",
	  (Queue_backlog ? "TRUE" : "FALSE"));
    }
    logmsg(LOG_DEBUG, "",
	"%s Retry fails:                     %s",
	(Retry_fails ? "TRUE" : "FALSE"));
    logmsg(LOG_DEBUG, "",
	"%s Fail_minutes:                    %ld", Fail_minutes);
    logmsg(LOG_DEBUG, "",
	"%s Repeat_minutes:                  %ld", Repeat_minutes);
    if (Input_from & FLG_FUNNEL)
      logmsg(LOG_DEBUG, "",
	"%s Sleep between funnel checks:     %d second(s)",
	Datafile.nap_time);
    else if (Input_from & FLG_LOGFILE)
      logmsg(LOG_DEBUG, "",
	"%s Sleep between logfile checks:    %d second(s)",
	Datafile.nap_time);
    else if (!Queue_backlog)
      logmsg(LOG_DEBUG, "",
	"%s Sleep between batchfile checks:  %d second(s)",
	Batchfile.nap_time);
    logmsg(LOG_DEBUG, "",
	"%s Sleep between entry checks:      %d second(s)",
	Entry_sleep);
    if (Input_from & FLG_BATCHFILE && !One_shot)
      logmsg(LOG_DEBUG, "",
	"%s Batchfile is moved after:        %d article(s)",
	Batchfile_move);
    if (!One_shot && ! Queue_backlog)
      logmsg(LOG_DEBUG, "",
	"%s Batchfile is rewritten after:    %d article(s)",
	Batchfile_rewrite);
    logmsg(LOG_DEBUG, "",
	"%s Statistics Reported:             %s",
	(Report_stats ? "TRUE" : "FALSE"));
    if (Report_stats) {
#ifdef HAVE_SYSLOG_H
      logmsg(LOG_DEBUG, "",
	"%s                 Via:             4.3BSD syslog");
#else
      logmsg(LOG_DEBUG, "",
	"%s                 Via:             %s", FAKESYSLOG);
#endif
      logmsg(LOG_DEBUG, "",
	"%s               After:             %d article(s)",
	Log_after);
      if (Log_close)
	logmsg(LOG_DEBUG, "",
	"%s               and each time the connection is closed.");
    }
    logmsg(LOG_DEBUG, "",
	"%s Connection closed after:         %d article(s)",
	Close_after);
    if (Close_timeout >= 0)
      logmsg(LOG_DEBUG, "",
	  "%s Connection closed after:         %d idle second(s)",
	  Close_timeout);
    if (Exit_timeout >= 0)
      logmsg(LOG_DEBUG, "",
	  "%s Exit after:                      %d idle second(s)",
	  Exit_timeout);
    logmsg(LOG_DEBUG, "", "%s\n");
  }
  if (print_version)
    exit(0);
  return;
}
