/**
 ** Routine that checks for various timeouts and sleeps.
 **
 ** $Id: sleep.c,v 1.12 1994/05/02 13:33:31 root Exp $
 **
 ** $Log: sleep.c,v $
 ** Revision 1.12  1994/05/02  13:33:31  root
 ** Changed Abort_signaled to Term_signaled
 **
 ** Revision 1.11  1994/02/11  14:29:11  root
 ** Modified fail() call to include sleep_time (if necessary)
 **
 ** Revision 1.10  1994/02/04  23:35:23  alden
 ** Fixed bug whereby if Exit_timeout was reached, we didn't Term_signaled
 **
 ** Revision 1.9  1994/01/09  18:46:49  alden
 ** Removed trailing '\n' from logmsg() calls -- syslog() will add them for us
 **
 ** Revision 1.8  1993/12/20  14:41:13  alden
 ** Replaced "Host.name" with "Host.sysname" in fail() and logmsg() calls
 **
 ** Revision 1.7  1993/11/19  20:42:39  alden
 ** Added code to handle start/stop debugging
 **
 ** Revision 1.6  1993/11/10  02:20:36  alden
 ** Removed "#ifdef _AIX..." -- hoping _ALL_SOURCE takes care of it
 **
 ** Revision 1.5  1993/11/10  01:52:31  alden
 ** Changed all occurrences of log() to logmsg().
 **
 ** Revision 1.4  1993/10/13  20:26:56  root
 ** modified to deal with new '-y' option
 **
 ** Revision 1.3  1993/05/28  12:54:24  alden
 ** Fixed #ifdef HAVE_SELECT problem
 **
 ** Revision 1.2  1993/05/04  23:38:52  alden
 ** Cleaned up tabs
 **
 ** Revision 1.1  1993/03/30  13:19:41  alden
 ** Initial revision
 **
 **
 **
 **/
#include "conf.h"
#include "readline.h"
#include "nntplink.h"

extern long Close_timeout;
extern Boolean Debug;
extern Boolean Debug_signaled;
extern long Dtablesize;
extern long Exit_timeout;
extern long Idle_time;
extern int Input_from;
extern pid_t Prog_pid;
extern Boolean Reset_signaled;
extern Boolean Term_signaled;

extern void abort_nntplink();
extern void begin_debugging();
extern void close_connection();
extern void end_debugging();
extern void fail();
extern void logmsg();
extern void update_batchfile();

#ifdef HAVE_WORKING_SELECT
struct timeval timeout = {0, 0};
#endif

void
  check_sleep(sleep_time, create_batch)
long sleep_time;
Boolean create_batch;
{
  static char *fname = "check_sleep: ";
#ifdef HAVE_WORKING_SELECT
  fd_set readfds;
  long start_time;
  int cnt;
#endif
  
  Idle_time += sleep_time;
  
  if ((Idle_time > Close_timeout) && (Host.connected) && 
      (Close_timeout != NEVER)) {
    
    dlogmsg(LOG_DEBUG, fname, "%sreached close timeout");
    close_connection(SEND_QUIT_MSG);
  }
  
  if (Term_signaled ||
      ((Exit_timeout != NEVER) && (Idle_time > Exit_timeout))) {
    
    if (Debug && !Term_signaled)
      dlogmsg(LOG_DEBUG, fname, "%sreached exit timeout");

    /**
     ** If we reached the Exit_timeout, then we need to fake an Term_signaled
     **/
    Term_signaled = TRUE;
    
    abort_nntplink();
  }
  
  if (Reset_signaled)
    update_batchfile();

  if (Debug_signaled)
    if (Debug)
      end_debugging();
    else
      begin_debugging(NULL, Prog_pid);
  
#ifdef HAVE_WORKING_SELECT
  timeout.tv_sec = sleep_time;
  
  while (timeout.tv_sec > 0 && !Term_signaled) {
    start_time = time(NULL);
    FD_ZERO(&readfds);
    if (Input_from & FLG_STDIN)
      FD_SET(fb_fileno(Stdin), &readfds);
    
    if ((cnt = select((int)Dtablesize,&readfds,0,0,&timeout)) == 0)
      break;
    
    if ((cnt == FAIL) && (errno != EINTR))
      fail(fname, 0,
	   "%s%s: select() failed (try undefining HAVE_WORKING_SELECT): %s",
	   Host.sysname, errmsg(errno));
    
    if (cnt > 0) {
      if (create_batch)
	update_batchfile();
      else if (fb_eof(Stdin)) {
	logmsg(LOG_INFO, fname, "%s%s: EOF on stdin, exiting", Host.sysname);
	Term_signaled = TRUE;
      } else
	break;
    }
    timeout.tv_sec -= (time(NULL) - start_time);
  }
  
#else
  (void) sleep((unsigned)sleep_time);
#endif
  
  dlogmsg(LOG_DEBUG, "", "%s.");
  
  return;
}
