#include <fcntl.h>
#include <stdio.h>
#include "conf.h"
#ifdef FAKESYSLOG
#include "fsyslog.h"
#else
#include <syslog.h>
#endif
#include <sys/types.h>
#include <sys/time.h>
#include "readline.h"
#include "nntplink.h"

extern char *E_open;
extern char *E_fseek;
extern char *E_fopen;

extern Boolean Debug;
extern int Prog_pid;

extern long Success_time;
extern long Report_time;

extern void log();

/*
 * Format of the datafile for nntplink:
 *
 *  Line  Description
 *  --------------------------------------------------------------------------
 *   1    Pid of current nntplink (or -999 if none)
 *   2    Version of the datafile (3.0 currently)
 *   3    Inode of the current batchfile
 *   4    Offset into the current batchfile
 *   5    Inode of the current logfile
 *   6    Offset into the current logfile
 *   7    Last time we had a successful transmission of an article
 *   8    Last time we reported a failure
 */


void
  write_link_datafile()
{
    static char *fname = "write_link_datafile: ";
    FILE *link_fp;

    dlog(LOG_DEBUG, fname, "%swriting current info to Datafile\n");

    if ((link_fp = fopen(Host.datafile, "w")) == NULL) {
      dlog(LOG_WARNING, fname, E_fopen, Host.name, Host.datafile, "w",
	   errmsg(errno));
    } else {
	fprintf(link_fp, "%d\n", Prog_pid);
	fprintf(link_fp, "%.1f\n", DATAFILE_VERSION);
	fprintf(link_fp, "%lu\n", (unsigned long)Batchfile.inode);
	if (Batchfile.fbp == NULL)
	  fprintf(link_fp, "0\n");
	else
	  fprintf(link_fp, "%ld\n", (long)fb_tell(Batchfile.fbp));
	fprintf(link_fp, "%lu\n", (unsigned long)Logfile.inode);
	if (Logfile.fbp == NULL)
	  fprintf(link_fp, "0\n");
	else
	  fprintf(link_fp, "%ld\n", (long)fb_tell(Logfile.fbp));
	fprintf(link_fp, "%ld\n", Success_time);
	fprintf(link_fp, "%ld\n", Report_time);
	FCLOSE(link_fp);
    }
}


void
  read_link_datafile()
{
    static char *fname = "read_link_datafile: ";
    int link_fd;
    FileBuf *link_fbp;
    char *line;
    float version;
    double atof();
    int errflg = 0;

    dlog(LOG_DEBUG, fname, "%sreading current info from Datafile\n");

    if ((link_fd = open(Host.datafile, O_RDONLY)) == FAIL) {
	log(LOG_WARNING, fname, E_open, Host.name, Host.datafile, "r",
	    errmsg(errno));
	Success_time = Report_time = time(NULL);
    } else {
	link_fbp = fb_fdopen(link_fd);

	if ((line = fb_readline(link_fbp, NULL)) == NULL) {
	    log(LOG_WARNING, fname,
		"%s%s: error reading pid from datafile: %s\n",
		Host.name, errmsg(errno));
	    errflg++;
	}

	if (!errflg)
	  if ((line = fb_readline(link_fbp, NULL)) == NULL) {
	      log(LOG_WARNING, fname,
		  "%s%s: error reading version from datafile: %s\n",
		  Host.name, errmsg(errno));
	      errflg++;
	  } else {
	      version = (float)(((int)(atof(line) * 10)) / 10.0);
	      if (version!= DATAFILE_VERSION) {
		  log(LOG_WARNING, fname,
		      "%s%s: datafile version(%.1f) not same as current version(%.1f)\n",
		      Host.name, version, DATAFILE_VERSION);
		  errflg++;
	      }
	  }

	if (!errflg)
	  if ((line = fb_readline(link_fbp, NULL)) == NULL) {
	      log(LOG_WARNING, fname,
		  "%s%s: error reading batchfile inode from datafile: %s\n",
		  Host.name, errmsg(errno));
	      errflg++;
	  } else
	    Batchfile.inode = (ino_t)atol(line);

	if (!errflg)
	  if (((line = fb_readline(link_fbp, NULL)) == NULL) ||
	      ((Batchfile.offset = (off_t)atol(line)) < 0)) {
	      log(LOG_WARNING, fname,
		  "%s%s: error reading batchfile offset from datafile: %s\n",
		  Host.name, errmsg(errno));
	      errflg++;
	  }

	if (!errflg)
	  if ((line = fb_readline(link_fbp, NULL)) == NULL) {
	      log(LOG_WARNING, fname,
		  "%s%s: error reading logfile inode from datafile: %s\n",
		  Host.name, errmsg(errno));
	      errflg++;
	  } else
	    Logfile.inode = (ino_t)atol(line);

	if (!errflg)
	  if (((line = fb_readline(link_fbp, NULL)) == NULL) ||
	      ((Logfile.offset = (off_t)atol(line)) < 0)) {
	      log(LOG_WARNING, fname,
		  "%s%s: error reading logfile offset from datafile: %s\n",
		  Host.name, errmsg(errno));
	      errflg++;
	  }

	if (!errflg)
	  if (((line = fb_readline(link_fbp, NULL)) == NULL) ||
	      ((Success_time = atol(line)) < 0)) {
	      log(LOG_WARNING, fname,
		  "%s%s: error reading success time from datafile: %s\n",
		  Host.name, errmsg(errno));
	      errflg++;
	  }

	if (!errflg)
	  if (((line = fb_readline(link_fbp, NULL)) == NULL) ||
	      ((Report_time = atol(line)) < 0)) {
	      log(LOG_WARNING, fname,
		  "%s%s: error reading report time from datafile: %s\n",
		  Host.name, errmsg(errno));
	      errflg++;
	  }

	close(link_fd);
	fb_close(link_fbp);
    }
    return;
}
