typedef struct {
    char *name;			/* batchfile name for this host */
    char *nname;		/* batchfile.nntp for this host */
    ino_t inode;		/* inode of the current batchfile */
    off_t offset;		/* offset into current batchfile */
    FileBuf *fbp;		/* storage for readline() */
    long nap_time;		/* time to sleep between batchfile checks */
    Boolean use;		/* should we use batchfile? */
    Boolean nntp_in_use;	/* are we using batchfile.nntp? */
} Bfile_struct;

extern Bfile_struct Batchfile;

typedef struct {
    char *name;			/* current logfile */
    ino_t inode;		/* inode of the current logfile */
    off_t offset;		/* offset into current logfile */
    FileBuf *fbp;		/* storage for readline() */
    long nap_time;		/* time to sleep between logfile checks */
} Lfile_struct;

extern Lfile_struct Logfile;

typedef struct {
    FileBuf *fbp;		/* fbp used by readline() */
    int fd_flags_block;		/* fd flags w/ blocking */
    int fd_flags_nblock;	/* fd flags w/o blocking */
} Stdin_struct;

extern Stdin_struct Stdin;

typedef struct {
    char *name;			/* FQDN of remote host */
    char *sysname;		/* sysname of remote host */
    char *datafile;		/* datafile for remote host */
    char *failfile;		/* file which we store failed articles in */
    char *filename;		/* current file (batchfile or logfile) */
    int transport;		/* transport method for remote host */
    Boolean connected;		/* true iff connection open to remote host */
} Host_struct;

extern Host_struct Host;

typedef struct {
    char *filename;		/* filename for this article */
    char *mesgid;		/* mesgid for this argicle */
    FileBuf *fbp;		/* storage for readline() */
    int count;			/* # of times current article has failed */
    char *err;			/* last err we got after attempting to send */
} Art_struct;

extern Art_struct Article;

typedef struct {
    unsigned long offered;
    unsigned long accepted;
    unsigned long rejected;
    unsigned long failed;
    unsigned long since_close;
} Stats_struct;

extern Stats_struct Stats;

typedef struct {
    long end_real;
    double end_user;
    double end_sys;
    long begin_real;
    double begin_user;
    double begin_sys;
} Time_struct;

extern Time_struct Time;
