#include <fcntl.h>
#include <stdio.h>
#include "conf.h"
#ifdef FAKESYSLOG
#include "fsyslog.h"
#else
#include <syslog.h>
#endif
#ifdef HAVE_STRINGS
#include <strings.h>
#else
#include <string.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include "readline.h"
#include "nntplink.h"
#include "strfuns.h"

extern char *E_fopen;
extern char *E_fseek;
extern char *E_fstat;
extern char *E_open;
extern char *E_rename;
extern char *E_unlink;

extern Boolean Abort_signaled;
extern Boolean Debug;
extern long Idle_time;
extern int Input_from;
extern Boolean One_shot;
extern Boolean Reset_signaled;

extern void close_article();
extern void check_sleep();
extern Boolean parse_entry();
extern void fail();
extern void log();


void
  check_batchfile()
{
    static char *fname = "check_batchfile: ";
    struct stat statb;
    int fd;

    Batchfile.use = FALSE;

    if (!One_shot) {

	if (stat(Batchfile.nname, &statb) != FAIL) {

	    dlog(LOG_DEBUG, fname, "%sFound batchfile.nntp\n");

	    if (statb.st_size == 0) {

		dlog(LOG_DEBUG, fname, "%sbatchfile.nntp is empty\n");

		if (unlink(Batchfile.nname) < 0)
		  fail(fname, E_unlink, Host.name, Batchfile.nname,
		       errmsg(errno));
	    } else {

		if ((fd = open(Batchfile.nname, O_RDONLY)) == FAIL)
		  fail(fname, E_open, Host.name, Batchfile.nname, "r",
		       errmsg(errno));

		Batchfile.use = TRUE;
		Batchfile.nntp_in_use = TRUE;
		Batchfile.fbp = fb_fdopen(fd);
		if ((statb.st_ino == Batchfile.inode) &&
		    (Batchfile.offset != 0) &&
		    (fb_seek(Batchfile.fbp, Batchfile.offset, 0) == FAIL))
		  log(LOG_WARNING, fname, E_fseek, Host.name, Batchfile.nname,
		      errmsg(errno));
		else
		  Batchfile.inode = statb.st_ino;
		return;
	    }
	}

	if (Input_from & FLG_BATCHFILE) {

	    dlog(LOG_DEBUG, fname, "%swaiting for batchfile: ");

	    while (stat(Batchfile.name, &statb) == FAIL)
	      check_sleep(Batchfile.nap_time);

	    dlog(LOG_DEBUG, "", "%sgot it\n");
	}
    }

    if ((stat(Batchfile.name, &statb) != FAIL) &&
	((Input_from & FLG_BATCHFILE) || !One_shot)) {

	dlog(LOG_DEBUG, fname, "%sFound batchfile\n");

	if (Input_from & FLG_BATCHFILE) {

	    if ((fd = open(Batchfile.name, O_RDONLY)) == FAIL)
	      fail(fname, E_open, Host.name, Batchfile.name, "r",
		   errmsg(errno));

	    Batchfile.fbp = fb_fdopen(fd);
	    Batchfile.use = TRUE;
	    if ((statb.st_ino == Batchfile.inode) &&
		(Batchfile.offset != 0) &&
		(fb_seek(Batchfile.fbp, Batchfile.offset, 0) == FAIL))
	      log(LOG_WARNING, fname, E_fseek, Host.name, Batchfile.name,
		  errmsg(errno));
	    else
	      Batchfile.inode = statb.st_ino;
	    return;

	} else {
	    if (statb.st_size == 0) {

		dlog(LOG_DEBUG, fname, "%sbatchfile is empty - removing\n");

		if (unlink(Batchfile.name) < 0)
		  dlog(LOG_WARNING, fname, E_unlink, Host.name, Batchfile.name,
		       errmsg(errno));

	    } else {

		dlog(LOG_DEBUG, fname,
		     "%srenaming batchfile to batchfile.nntp\n");

		if (rename(Batchfile.name, Batchfile.nname) == FAIL)
		  fail(fname, E_rename, Host.name, Batchfile.name,
		       Batchfile.nname, errmsg(errno));

		check_batchfile();
		return;
	    }
	}
    }
    if (One_shot && (Input_from && FLG_BATCHFILE))
      fail(fname, "%s%s: %s not found on a One-shot\n", Host.name,
	   Batchfile.name);

    return;
}


void
  update_batchfile()
{
    static char *fname = "update_batchfile: ";
    char *entry;
    struct stat batch_stat, log_stat;
    FILE *tfp;
    int fd;

    if (Reset_signaled && (Input_from & FLG_LOGFILE))
      log(LOG_INFO, fname, "%s%s: Resetting to use new logfile\n", Host.name);

    Reset_signaled = Batchfile.use = Batchfile.nntp_in_use = FALSE;

    if (Debug)
      if (Input_from & FLG_LOGFILE)
	log(LOG_DEBUG, fname, "%sUpdating Batchfile from Logfile\n");
      else
	log(LOG_DEBUG, fname, "%sUpdating Batchfile from <stdin>\n");

    if ((tfp = fopen(Batchfile.nname, "a")) == NULL)
      fail(fname, E_fopen, Host.name, Batchfile.nname, "a", errmsg(errno));

    if (Article.filename != NULL) {
#ifdef CNEWS
	fprintf(tfp, "%s %s %d\n", Article.filename, Article.mesgid,
		Article.count);
#else
	fprintf(tfp, "%s\t%s\t%d\n", Article.filename, Article.mesgid,
		Article.count);
#endif
	close_article();
    }

    if (Input_from & FLG_LOGFILE) {

	if (Logfile.fbp != NULL) {
#ifdef LOOKUP_ARTICLE
	    Article.filename = strsave("/");
#endif
	    while ((entry = fb_readline(Logfile.fbp)) != NULL)
	      if (parse_entry(entry))
#ifdef CNEWS
		fprintf(tfp, "%s %s\n", Article.filename,
			Article.mesgid);
#else
	        fprintf(tfp, "%s\t%s\n", Article.filename,
			Article.mesgid);
#endif

	    if (fb_error(Logfile.fbp))
	      log(LOG_INFO, fname,
		  "%s%s: error reading %s: %s\n", Host.name,
		  Logfile.name, errmsg(errno));

#ifdef LOOKUP_ARTICLE
	    free(Article.filename);
#endif

	    Article.filename = Article.mesgid = NULL;

	    Logfile.offset = fb_tell(Logfile.fbp);
	    close(fb_fileno(Logfile.fbp));
	    fb_close(Logfile.fbp);
	    Logfile.fbp = NULL;
	}
    } else {					/* Input_from & FLG_STDIN */
	while((entry = fb_readline(Stdin.fbp)) != NULL)
	  if (parse_entry(entry))
#ifdef CNEWS
	    fprintf(tfp, "%s %s\n", Article.filename, Article.mesgid);
#else
	    fprintf(tfp, "%s\t%s\n", Article.filename, Article.mesgid);
#endif

	if (fb_error(Stdin.fbp))
	  log(LOG_INFO, fname, "%s%s: error reading stdin: %s\n",
	      Host.name, errmsg(errno));
    }

    (void) fflush(tfp);

    if (ferror(tfp)) {
	fail(fname, "%s%s: copy to batchfile.nntp failed: %s\n", Host.name,
	     errmsg(errno));
	FCLOSE(tfp);
    }

    FCLOSE(tfp);

    if (Input_from & FLG_LOGFILE) {

	while ((fd = open(Logfile.name, O_RDONLY)) == FAIL)
	  check_sleep(Logfile.nap_time);

	Logfile.fbp = fb_fdopen(fd);

	if (fstat(fd, &log_stat) == FAIL)
	  fail(fname, E_fstat, Host.name, Logfile.name, errmsg(errno));
	else
	  if (Logfile.inode == log_stat.st_ino) {
	      if (fb_seek(Logfile.fbp, Logfile.offset, 0) == FAIL)
		log(LOG_WARNING, fname, E_fseek, Host.name, Logfile.name,
		    errmsg(errno));
	  } else
	    Logfile.inode = log_stat.st_ino;
    }

    if (stat(Batchfile.nname, &batch_stat) == FAIL)
      log(LOG_WARNING, fname,
	  "%s%s: %s non-existent after creation?!?!?\n", Batchfile.nname,
	  Host.name);
    else if (batch_stat.st_size == 0) {
	if (unlink(Batchfile.nname) == FAIL)
	  log(LOG_WARNING, fname, E_unlink, Host.name, Batchfile.nname,
	      errmsg(errno));
    } else {
	if (Batchfile.fbp == NULL) {
	    if((fd = open(Batchfile.nname, O_RDONLY)) == FAIL)
	      fail(fname, E_fopen, Host.name, Batchfile.nname, "r",
		   errmsg(errno));

	    if (Debug && !Abort_signaled)
	      log(LOG_DEBUG, fname, "%s%s: Using Batchfile.nntp again\n",
		  Host.name);

	    Batchfile.fbp = fb_fdopen(fd);
	}
	Batchfile.use = Batchfile.nntp_in_use = TRUE;
    }
    return;
}
