#include <stdio.h>
#include "conf.h"
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#ifdef HAVE_STRINGS
#include <strings.h>
#else
#include <string.h>
#endif
#ifdef FAKESYSLOG
#include "fsyslog.h"
#else
#include <syslog.h>
#endif
#include "readline.h"
#include "nntplink.h"
#include "strfuns.h"

extern int Clear_batchfile;
extern int Close_after;
extern long Close_timeout;
extern long Entry_sleep;
extern long Exit_timeout;
extern long Fail_minutes;
extern int Log_after;
extern char *Prog_name;
extern long Repeat_minutes;
extern Boolean Report_stats;

extern char *E_chdir;
extern char *E_fopen;

extern char *optarg;
extern int optind, opterr;

extern void exit();
extern void fail();
extern void log();

Boolean Autobackground = FALSE;
Boolean Debug = FALSE;
FILE *Debugfp = stderr;
char *History_file = HISTORYFILE;
int Input_from = DEF_INPUT_FROM;
Boolean One_shot = FALSE;
Boolean Save_fails = TRUE;

void
  parse_args(argc, argv)
int argc;
char *argv[];
{
    static char *fname = "parse_args: ";
    int c, errflg=0, tclear;
    char *batchname = NULL,
    	 *tfile = NULL,
         *batchdir = BATCHDIR,
         *spooldir = SPOOLDIR;
    Boolean set_C_opt = FALSE;
    Boolean c_news_batch = FALSE;
    Boolean print_version = FALSE;
    struct stat qst;

    Prog_name = argv[0];

    opterr = 0;
    while ((c = getopt(argc, argv,
		       "a:Ab:B:c:C:dD:e:E:fF:H:i:l:L:n:N:op:rR:s:S:v")) != EOF)
        switch (c) {
	    case 'a':
	        Close_after = atoi(optarg);
		break;
	    case 'A':
		Autobackground = TRUE;
		break;
	    case 'b':
		batchname = optarg;
		break;
	    case 'B':
		batchdir = optarg;
		break;
	    case 'c':
		Clear_batchfile = atoi(optarg);
		set_C_opt = TRUE;
		break;
	    case 'C':
		Close_timeout = atol(optarg);
		break;
	    case 'd':
		Debug = TRUE;
		break;
	    case 'D':
		Debug = TRUE;
		if ((Debugfp = fopen(optarg, "a")) == NULL) {
		    fprintf(stderr, E_fopen, optarg, "a", errmsg(errno));
		    errflg++;
		}
		break;
	    case 'e':
		Exit_timeout = atol(optarg);
		break;
	    case 'E':
		Entry_sleep = atol(optarg);
		break;
	    case 'f':
		Save_fails = FALSE;
		break;
	    case 'F':
		Fail_minutes = atol(optarg);
		break;
	    case 'H':
		History_file = optarg;
		break;
	    case 'i':
		if (strcmp(optarg, "batchfile") == MATCH)
		  Input_from = FLG_BATCHFILE;
		else if (strcmp(optarg, "logfile") == MATCH)
		  Input_from = FLG_LOGFILE;
		else if (strcmp(optarg, "stdin") == MATCH)
		  Input_from = FLG_STDIN;
		else
		  errflg++;
		break;
	    case 'l':
		Log_after = atoi(optarg);
		break;
	    case 'L':
		Input_from = FLG_LOGFILE;
		Logfile.name = optarg;
		break;
	    case 'n':
		Batchfile.nap_time = atol(optarg);
		break;
	    case 'N':
		Logfile.nap_time = atol(optarg);
		break;
	    case 'o':
		One_shot = TRUE;
		break;
	    case 'p':
		if (strcmp(optarg, "decnet") == 0)
		  Host.transport = T_DECNET;
		else if (strcmp(optarg, "tcp") == 0)
		  Host.transport = T_IP_TCP;
		else if (strcmp(optarg, "dkhost") == 0)
		  Host.transport = T_DKHOST;
		else
		  errflg++;
		break;
	    case 'r':
		Report_stats = FALSE;
		break;
	    case 'R':
		Repeat_minutes = atol(optarg);
		break;
	    case 's':
		Input_from = FLG_LOGFILE;
		Host.sysname = optarg;
		break;
	    case 'S':
		spooldir = optarg;
		break;
	    case 'v':
		print_version = TRUE;
		Debug = TRUE;
		break;
	    default:
		errflg++;
	    }

    if (optind < argc) {
	Host.name = argv[optind++];
    } else {
	if (print_version)
	  Host.name = strsave("<none-given>");
	errflg++;
    }

    if (errflg) {
	fprintf(stderr,	"usage: %s [options] hostname\n", Prog_name);
	if (!print_version)
	  exit(FAIL);
    }

    if (Autobackground && (Debug || One_shot)) {
	fprintf(stderr, "%s: Cannot use -A and %s\n", Debug ? "-d" : "-o");
	exit(FAIL);
    }

    if ((tclear = Clear_batchfile / Log_after) < 1)
      tclear = 1;

    if ((Clear_batchfile != (tclear * Log_after)) && (set_C_opt)) {
	fprintf(stderr,
	      "%s: -c (Clear_batchfile) isn't a multiple of -l (Log_after)\n",
	      Prog_name);
	fprintf(stderr,
	      "     using %d for -c instead\n", (tclear * Log_after));
    }
    Clear_batchfile = tclear;

    if (chdir(spooldir) == FAIL)
      log(LOG_WARNING, fname, E_chdir, Host.name, spooldir, errmsg(errno));

    if (Host.sysname == NULL)
	Host.sysname = Host.name;

    if (batchname == NULL)
      tfile = str3save(batchdir, "/", Host.name);
    else if (*batchname == '/')
      tfile = strsave(batchname);
    else
      tfile = str3save(batchdir, "/", batchname);

    if (stat(tfile, &qst) == FAIL) {

	if (errno == ENOENT)
	  dlog(LOG_INFO, fname,
	       "%s%s doesn't exist, assuming it's the name of a batchfile\n",
	       tfile);
	else
	  fail(fname, "%s%s: stat(%s) failed: %s\n", Host.name, tfile,
	       errmsg(errno));
    } else if ((qst.st_mode & S_IFMT) == S_IFREG) {
	dlog(LOG_DEBUG, fname, "%s%s is a batchfile\n", tfile);
    } else if ((qst.st_mode & S_IFMT) == S_IFDIR) {
	dlog(LOG_DEBUG, fname, "%s%s is a batch directory\n", tfile);
	c_news_batch = TRUE;
    } else {
	fail(fname,
	     "%s%s: %s is not a directory or a regular file, st_mode = %o",
	     Host.name, tfile, qst.st_mode);
    }

    if (c_news_batch) {
	Batchfile.name = str2save(tfile, "/togo");
	Host.failfile = str2save(tfile, "/togo.fail");
	Host.datafile = str2save(tfile, "/togo.link");
    } else {
        Batchfile.name = strsave(tfile);
	Host.failfile = str2save(tfile, ".fail");
	Host.datafile = str2save(tfile, ".link");
    }

    FREE(tfile);

    Batchfile.nname = str2save(Batchfile.name, ".nntp");

    if (Debug) {
	log(LOG_DEBUG, "",
	    "%sConfiguration information:\n");
	log(LOG_DEBUG, "",
	    "%s Version:                         %s\n", VERSION);
	log(LOG_DEBUG, "",
	    "%s Host:                            %s\n", Host.name);
	log(LOG_DEBUG, "",
	    "%s Spool directory:                 %s\n", spooldir);
	log(LOG_DEBUG, "",
	    "%s Batch file:                      %s\n", Batchfile.name);
	log(LOG_DEBUG, "",
	    "%s Fail file:                       %s\n", Host.failfile);
	if (!One_shot) {
	    log(LOG_DEBUG, "",
		"%s Link Data file:                  %s\n", Host.datafile);
	    if (Input_from & FLG_LOGFILE) {
		log(LOG_DEBUG, "",
		    "%s Logfile:                         %s\n", Logfile.name);
		log(LOG_DEBUG, "",
		    "%s Sysname:                         %s\n", Host.sysname);
	    }
#ifdef LOOKUP_ARTICLE
	    log(LOG_DEBUG, "",
		"%s History file:                    %s\n", History_file);
#endif
	} else
	  log(LOG_DEBUG, "", "%s One shot?:                       TRUE\n");
	if (Host.transport == T_IP_TCP)
	  log(LOG_DEBUG, "",
	      "%s Connection Type:                 TCP/IP\n");
	else if (Host.transport == T_DECNET)
	  log(LOG_DEBUG, "",
	      "%s Connection Type:                 DECNET\n");
	else if (Host.transport == T_DKHOST)
	  log(LOG_DEBUG, "",
	      "%s Connection Type:                 DKHOST\n");
	else
	  log(LOG_DEBUG, "",
	      "%s Connection Type:                 <fd>\n");
	if (Input_from & FLG_BATCHFILE)
	  log(LOG_DEBUG, "",
	      "%s Input file type:                 Batchfile\n");
	else if (Input_from & FLG_LOGFILE)
	  log(LOG_DEBUG, "",
	      "%s Input file type:                 Logfile\n");
	else
	  log(LOG_DEBUG, "",
	      "%s Input file type:                 <stdin>\n");
	log(LOG_DEBUG, "",
	    "%s Save fails:                      %s\n",
	    (Save_fails ? "TRUE" : "FALSE"));
	log(LOG_DEBUG, "",
	    "%s Fail_minutes:                    %ld\n", Fail_minutes);
	log(LOG_DEBUG, "",
	    "%s Repeat_minutes:                  %ld\n", Repeat_minutes);
	if (Input_from & FLG_LOGFILE)
	  log(LOG_DEBUG, "",
	      "%s Sleep between logfile checks:    %d second(s)\n",
	      Logfile.nap_time);
	else
	  log(LOG_DEBUG, "",
	      "%s Sleep between batchfile checks:  %d second(s)\n",
	      Batchfile.nap_time);
	log(LOG_DEBUG, "",
	    "%s Sleep between entry checks:      %d second(s)\n",
	    Entry_sleep);
	if (Input_from & FLG_BATCHFILE)
	  log(LOG_DEBUG, "",
	      "%s Batchfile is cleared after:      %d article(s)\n",
	      (Clear_batchfile * Log_after));
	log(LOG_DEBUG, "",
	    "%s Statistics Reported:             %s\n",
	    (Report_stats ? "TRUE" : "FALSE"));
	if (Report_stats) {
#ifdef FAKESYSLOG
	    log(LOG_DEBUG, "",
		"%s                 Via:             %s\n", FAKESYSLOG);
#else
	    log(LOG_DEBUG, "",
		"%s                 Via:             4.3BSD syslog\n");
#endif
	    log(LOG_DEBUG, "",
		"%s               After:             %d article(s)\n",
		Log_after);
	}
	log(LOG_DEBUG, "",
	    "%s Connection closed after:         %d article(s)\n",
	    Close_after);
	if (Close_timeout >= 0)
	  log(LOG_DEBUG, "",
	      "%s Connection closed after:         %d idle second(s)\n",
	      Close_timeout);
	if (Exit_timeout >= 0)
	  log(LOG_DEBUG, "",
	      "%s Exit after:                      %d idle second(s)\n",
	      Exit_timeout);
	log(LOG_DEBUG, "", "\n\n");
    }
    if (print_version)
      exit(0);
    return;
}
