#include <errno.h>
#include <stdio.h>
#include "conf.h"
#ifdef HAVE_STRINGS
#include <strings.h>
#else
#include <string.h>
#endif
#ifdef FAKESYSLOG
#include "fsyslog.h"
#else
#include <syslog.h>
#endif
#include <sys/types.h>
#include <sys/time.h>
#include "readline.h"
#include "nntplink.h"
#include "nntp.h"
#include "strfuns.h"

extern Boolean Abort_signaled;
extern int Close_after;
extern long Failure_naptime;
extern int Log_after;
extern Boolean One_shot;
extern Boolean Reset_signaled;
extern long Success_time;

extern void abort_nntplink();
extern void close_article();
extern Boolean get_next_art();
extern void close_connection();
extern void log();
extern void log_stats();
extern Boolean open_article();
extern Boolean open_connection();
extern char *read_reply();
extern Boolean send_connection();
extern char *send_ihave_msg();

Boolean
  send_news()
{
    static char *fname = "send_news: ";
    Boolean failure = FALSE;
    int code;
    char *reply;

    while(!Abort_signaled &&
	  !Reset_signaled &&
	  !failure &&
	  get_next_art()) {

#ifdef OPEN_ARTICLE_FIRST
	if (!open_article())
	  close_article();
	else {
#endif
	    if (!Host.connected)
	      if (!open_connection(Host.name, Host.transport))
		return FALSE;

	    reply = send_ihave_msg(&code);
	    switch(code) {
	      case CONT_XFER:
		if (!send_connection(Article.fbp)) {
		    log(LOG_NOTICE, fname, "%s%s: xfer %s: %s\n", Host.name,
			Article.filename, errmsg(errno));
		    failure = TRUE;
		} else {
		    if ((reply = read_reply(&code)) != NULL) {
			if (Article.err != NULL)
			  free(Article.err);
			Article.err = strsave(reply);

		    }
		    if (code == FAIL)
		      close_connection(DONT_WAIT);
		    else if ((code != OK_XFERED) && (code != ERR_XFERRJCT)) {
			Article.count++;
			failure = TRUE;
			if (code == ERR_XFERFAIL)
			  Failure_naptime = NAPTIME;
		    }
		}
		break;

	      case ERR_NOFILE:
		(void) read_reply(&code);
		if (code == FAIL)
		  close_connection(DONT_WAIT);
		else if ((code != OK_XFERED) && (code != ERR_XFERFAIL))
		  log(LOG_NOTICE, fname, "%s%s: bad reply: %s\n",
		      Host.name, errmsg(errno));
		break;

	      case ERR_UNKNOWN:
	      case ERR_NOFILE_CONT:
	      case ERR_NOMSGID:
	      case ERR_GOTIT:
		break;

	      case ERR_GOODBYE:
		close_connection(DONT_WAIT);
		failure = TRUE;
		break;

	      case FAIL:
		failure = TRUE;
		break;

	      default:
		log(LOG_NOTICE, fname,
		    "%s%s: sent IHAVE %s, received: %s\n",
		    Host.name, Article.mesgid, reply);
		failure = TRUE;
	    }

	    if (failure) {
		Stats.failed++;
		close_connection(DONT_WAIT);
		break;
	    } else {
		close_article();
		Failure_naptime = NAPTIME;
		Success_time = time(NULL);
	    }
#ifdef OPEN_ARTICLE_FIRST
	}
#endif
	if (Stats.offered >= Log_after)
	  log_stats();

	if ((Stats.since_close >= Close_after) && Host.connected)
	  close_connection(WAIT);
    }

    if (Abort_signaled)
      abort_nntplink();

    if (Reset_signaled && !One_shot)
      update_batchfile();

    return !failure;
}
