/******************************************************************\
*								   *
*  ANSI <math.h>                last modified: 1990/11/5.          *
*								   *
*  Matthew Self's version of 1989/3/6, modified for OS-9/68000     *
*  by Julian Blake, CERN, on 1990/11/5.   Amendments:              *
*    Correct type of second argument of modf.                      *
*    Change name of MC 68881/2 include file.                       *
*    Declare atof() and hypot().                                   *
*								   *
*  Copyright (C) 1989 by Matthew Self.				   *
*  You may freely distribute verbatim copies of this software	   *
*  provided that this copyright notice is retained in all copies.  *
*  You may distribute modifications to this software under the     *
*  conditions above if you also clearly note such modifications    *
*  with their author and date.			   	     	   *
*								   *
*  Note:  the macro HUGE_VAL is defined in the machine-specific	   *
*  header files.  If none of these is included, you must define	   *
*  this to the appropriate value for your math library.		   *
*								   *
*  Send bugs to Julian Blake (blake@cernvax.cern.ch).              *
*  Original author: Matthew Self (self@bayes.arc.nasa.gov).        *
*								   *
\******************************************************************/

#ifndef _MATH_H
#define _MATH_H

#ifdef __STDC__			/* Use prototypes */

#ifdef __GNUC__			/* Use const function attribute */

#ifndef __STRICT_ANSI__		/* Use inline and asm keywords*/

#ifdef __HAVE_68881__		/* MC68881/2 Floating-Point Coprocessor */

#include <math881.h>

/* Please add inline asm code for other machines here! */

#else                           /* :-( No asm code for this machine */

extern const double
  atof (char *nptr), hypot (double x, double y),
  sin (double x), cos (double x), tan (double x),
  asin (double x), acos (double x), atan (double x),
  atan2 (double y, double x),
  sinh (double x), cosh (double x), tanh (double x),
  exp (double x), log (double x), log10 (double x),
  sqrt (double x), pow (double x, double y),
  fabs (double x),
  ceil (double x), floor (double x),
  fmod (double x , double y),
  ldexp (double x, int n);

extern double
  frexp (double x, int *exp), modf (double x, double *ip);

#endif				/* Different machine types */

#else /* __STRICT_ANSI__ */	/* Don't use inline and asm keywords*/

extern const double
  atof (char *nptr), hypot (double x, double y),
  sin (double x), cos (double x), tan (double x),
  asin (double x), acos (double x), atan (double x),
  atan2 (double y, double x),
  sinh (double x), cosh (double x), tanh (double x),
  exp (double x), log (double x), log10 (double x),
  sqrt (double x), pow (double x, double y),
  fabs (double x),
  ceil (double x), floor (double x),
  fmod (double x , double y),
  ldexp (double x, int n);

extern double
  frexp (double x, int *exp), modf (double x, double *ip);

#endif /* __STRICT_ANSI */

#else /* __GNUC__ */		/* Don't use const function attribute */

extern double
  atof (char *nptr), hypot (double x, double y),
  sin (double x), cos (double x), tan (double x),
  asin (double x), acos (double x), atan (double x),
  atan2 (double y, double x),
  sinh (double x), cosh (double x), tanh (double x),
  exp (double x), log (double x), log10 (double x),
  sqrt (double x), pow (double x, double y),
  fabs (double x),
  ceil (double x), floor (double x),
  fmod (double x , double y),
  ldexp (double x, int n),
  frexp (double x, int *exp), modf (double x, double *ip);

#endif /* __GNUC__ */

#else /* __STDC__ */		/* Don't use prototypes */

extern double
  atof (), hypot (),
  sin (), cos (), tan (),
  asin (), acos (), atan (),
  atan2 (),
  sinh (), cosh (), tanh (),
  exp (), log (), log10 (),
  sqrt (), pow (),
  fabs (),
  ceil (), floor (),
  fmod (),
  ldexp (),
  frexp (), modf ();

#endif /* __STDC__ */

#endif /* _MATH_H */

