/* Definitions of target machine for GNU compiler.  OS-9/68000 version.
   Copyright (C) 1987 Free Software Foundation, Inc.

This file is part of GNU CC.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the GNU CC General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
GNU CC, but only under the conditions described in the
GNU CC General Public License.   A copy of this license is
supposed to have been given to you along with GNU CC so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies.  */

/* Adapted to OSK.  by T.Shinohara and A.Seyama */

#define MOTOROLA
#define HAVE_SEPARATE_DATA_AREA
#define OSK_TARGET

#include "tm_m68k.h"

/* 0420 means 68000, regparm and stack-check (see below). */

#define TARGET_DEFAULT 0420

/* Override parts of tm-m68k.h to fit Microware's assembler syntax.  */

#undef TARGET_VERSION
#define TARGET_VERSION fprintf (stderr, " (OS-9/68000)")

/* NO FPA */
#undef TARGET_FPA

/* OSK use regparm feature in default.
   noremote/remote feature is only for OSK (default -mnoremote) */

#undef TARGET_SWITCHES
#define TARGET_SWITCHES  \
  { { "68020", 5},				\
    { "c68020", 5},				\
    { "68881", 2},				\
    { "bitfield", 4},				\
    { "68000", -5},				\
    { "c68000", -5},				\
    { "soft-float", -2},			\
    { "nobitfield", -4},			\
    { "rtd", 8},				\
    { "nortd", -8},				\
    { "short", 040},				\
    { "noshort", -040},				\
    { "regparm", 020},				\
    { "noregparm", -020},			\
    { "remote", 0200},				\
    { "noremote", -0200},			\
    { "stack-check", 0400},			\
    { "nostack-check", -0400},			\
    { "gss", 01000},				\
    { "nogss", -01000},				\
    { "", TARGET_DEFAULT}}

#define TARGET_REMOTE (target_flags & 0200)
#define TARGET_STACK_CHECK (target_flags & 0400)
#define TARGET_GSS (target_flags & 01000)

/* For OSK, only text is always shared */
#undef OVERRIDE_OPTIONS
#define OVERRIDE_OPTIONS		\
  { flag_shared_data = 1; }

/* Allow $ in identifiers */

#define DOLLARS_IN_IDENTIFIERS 1

/* Generate calls to memcpy, memcmp and memset.  */

#define TARGET_MEM_FUNCTIONS

/* Register Usage of OSK */

#undef FIRST_PSEUDO_REGISTER
#define FIRST_PSEUDO_REGISTER 24

/* registers for fixed use. a6 data area base pointer, a7 stack pointer. */

#undef FIXED_REGISTERS
#define FIXED_REGISTERS  \
 {0, 0, 0, 0, 0, 0, 0, 0, \
  0, 0, 0, 0, 0, 0, 1, 1, \
  0, 0, 0, 0, 0, 0, 0, 0}

/* registers used in function call.
   d0, d1 for parameter passing
   a1     for passing structure/union (by pointer) */

#undef CALL_USED_REGISTERS  
#define CALL_USED_REGISTERS \
 {1, 1, 0, 0, 0, 0, 0, 0, \
  1, 1, 0, 0, 0, 0, 1, 1, \
  0, 0, 0, 0, 0, 0, 0, 0}

/* if -mremote is specified, then we use d2, d3 as junk registers to load
   32bit offset of data address */
#undef CONDITIONAL_REGISTER_USAGE
#define CONDITIONAL_REGISTER_USAGE	\
{						\
  if (TARGET_REMOTE && !TARGET_68020)           \
    {						\
      fixed_regs[2] = call_used_regs[2] = 1;	\
      fixed_regs[3] = call_used_regs[3] = 1;	\
    }						\
}

#undef HARD_REGNO_MODE_OK
#define HARD_REGNO_MODE_OK(REGNO, MODE) \
  ((REGNO) < 16 || (TARGET_68881 && ((MODE) == SFmode || (MODE) == DFmode)))

#undef FRAME_POINTER_REGNUM
#define FRAME_POINTER_REGNUM 13

#undef ARG_POINTER_REGNUM
#define ARG_POINTER_REGNUM 13

#undef REG_CLASS_NAMES
#define REG_CLASS_NAMES \
 {"NO_REGS", "DATA_REGS", "ADDR_REGS", "GENERAL_REGS",  \
  "FP_REGS", "FP_OR_DATA_REGS", "ALL_REGS" }

#undef REG_CLASS_CONTENTS
#define REG_CLASS_CONTENTS {0, 0xff, 0xff00, 0xffff, 0xff0000, 0xff00ff, 0xffffff}

#undef REGNO_REG_CLASS
#define REGNO_REG_CLASS(REGNO) \
 ((REGNO) >= 16 ? FP_REGS : (REGNO) < 8 ? DATA_REGS : ADDR_REGS)

#undef REG_CLASS_FROM_LETTER
#define REG_CLASS_FROM_LETTER(C) \
  ((C) == 'a' ? ADDR_REGS : ((C) == 'd' ? DATA_REGS : ((C) == 'f' ? FP_REGS : NO_REGS)))

#undef CONST_DOUBLE_OK_FOR_LETTER_P
#define CONST_DOUBLE_OK_FOR_LETTER_P(VALUE, C)  \
  ((C) == 'G' ? ! (TARGET_68881 && standard_68881_constant_p (VALUE)) : 1)

#undef PREFERRED_RELOAD_CLASS
#define PREFERRED_RELOAD_CLASS(X,CLASS)  \
  ((GET_CODE (X) == CONST_INT			\
    && (unsigned) (INTVAL (X) + 0x80) < 0x100	\
    && (CLASS) != ADDR_REGS)			\
   ? DATA_REGS					\
   : GET_MODE (X) == QImode			\
   ? DATA_REGS					\
   : ((GET_MODE (X) == Pmode)			\
       && (osk_data_ref_p (X)			\
           || osk_symbol_ref_p (X)))		\
   ? ADDR_REGS					\
   : (CLASS))

#undef CLASS_MAX_NREGS
#define CLASS_MAX_NREGS(CLASS, MODE)	\
 ((CLASS) == FP_REGS ? 1			\
  : ((GET_MODE_SIZE (MODE) + UNITS_PER_WORD - 1) / UNITS_PER_WORD))
/* ( Ist in tm_m68k.h richtig(er) definiert. Es wird kein FP0 zurueckgegeben! )
#undef FUNCTION_VALUE
#define FUNCTION_VALUE(VALTYPE,FUNC) LIBCALL_VALUE (TYPE_MODE (VALTYPE))

#undef LIBCALL_VALUE
#define LIBCALL_VALUE(MODE) \
 gen_rtx (REG, (MODE), ((TARGET_68881 && ((MODE) == SFmode || (MODE) == DFmode)) ? 16 : 0))
*/

/* 1 if N is a possible register number for function argument passing.
   On the OSK, registers D0 and D1 are used in this way.  */
#undef FUNCTION_ARG_REGNO_P
#define FUNCTION_ARG_REGNO_P(N) (TARGET_REGPARM && ((N) == 0 || (N) == 1))

/* Define where to put the arguments to a function.
   Value is zero to push the argument on the stack,
   or a hard register in which to store the argument.

   MODE is the argument's machine mode.
   TYPE is the data type of the argument (as a tree).
    This is null for libcalls where that information may
    not be available.
   CUM is a variable of type CUMULATIVE_ARGS which gives info about
    the preceding args and about the function being called.
   NAMED is nonzero if this argument is a named parameter
    (otherwise it is an extra parameter matching an ellipsis).  */

/* For OSK, the first two words of arguments are passed in d0, d1. */

#undef FUNCTION_ARG
#define FUNCTION_ARG(CUM, MODE, TYPE, NAMED)	\
((TARGET_REGPARM && (NAMED))			\
 ? (8 < (CUM) + ((((MODE) == BLKmode ? int_size_in_bytes (TYPE) : GET_MODE_SIZE (MODE)) + 3) & ~3)	\
   ? 0						\
   : ((CUM) == 0				\
      ? gen_rtx (REG, (MODE), 0)		\
      : gen_rtx (REG, (MODE), 1)))		\
 : 0)

/* For an arg passed partly in registers and partly in memory,
   this is the number of registers used.
   For args passed entirely in registers or entirely in memory, zero.  */

#undef FUNCTION_ARG_PARTIAL_NREGS
#define FUNCTION_ARG_PARTIAL_NREGS(CUM, MODE, TYPE, NAMED) 0

#undef REGNO_OK_FOR_FPA_P
#undef FPA_REG_P

/* This macro generates the assembly code for function entry.
   FILE is a stdio stream to output the code to.
   SIZE is an int: how many units of temporary storage to allocate.
   Refer to the array `regs_ever_live' to determine which registers
   to save; `regs_ever_live[I]' is nonzero if register number I
   is ever used in the function.  This macro is responsible for
   knowing which registers should not be saved even if used.  */

/* Note that Microware's assemblers r68 and r68020 change the order of
   register mask bits in predecrement mode movem/fmovem instructions. */

#undef FUNCTION_PROLOGUE
#define FUNCTION_PROLOGUE(FILE, SIZE)     \
{ register int regno;                                           \
  register int mask = 0;                                        \
  extern char call_used_regs[];                                 \
  int fsize = ((SIZE) + 3) & -4;                                \
  if (TARGET_STACK_CHECK)                                       \
    { fprintf (FILE, "\tmove.l d0,-(sp)\n");                    \
      fprintf (FILE, "\tmove.l #76+%d,d0\n", fsize);            \
      fprintf (FILE, "\tbsr __stack_check\n");                  \
      fprintf (FILE, "\tmove.l (sp)+,d0\n"); }                  \
  if (frame_pointer_needed)					\
    { if (TARGET_68020 || fsize <= 0x8000)                      \
        fprintf (FILE, "\tlink a5,#%d\n", -fsize);		\
      else							\
	fprintf (FILE, "\tlink a5,#0\n\tsub.l #%d,sp\n", fsize); }  \
  for (regno = 16; regno < FIRST_PSEUDO_REGISTER; regno++)	\
    if (regs_ever_live[regno] && ! call_used_regs[regno])	\
       mask |= 1 << (23 - regno);                               \
  if (mask != 0)						\
    fprintf (FILE, "\tfmovem.x #0x%x,-(sp)\n", mask & 0xff);    \
  mask = 0;							\
  for (regno = 0; regno < 16; regno++)				\
    if (regs_ever_live[regno] && ! call_used_regs[regno])	\
       mask |= 1 << regno;					\
  if (frame_pointer_needed)					\
    mask &= ~ (1 << FRAME_POINTER_REGNUM);			\
  if (exact_log2 (mask) >= 0)					\
    fprintf (FILE, "\tmove.l %s,-(sp)\n", reg_names[exact_log2 (mask)]);\
  else if (mask) fprintf (FILE, "\tmovem.l #0x%x,-(sp)\n", mask); }

/* For OSK, do nothing.  89/12/12 A.S. */

#undef FUNCTION_PROFILER
#define FUNCTION_PROFILER(FILE, LABEL_NO)

/* Output assembler code to FILE to initialize this source file's
   basic block profiling info, if that has not already been done.  */

/* For OSK, do nothing.  89/12/12 A.S. */

#undef FUNCTION_BLOCK_PROFILER
#define FUNCTION_BLOCK_PROFILER(FILE, LABELNO)

/* Output assembler code to FILE to increment the entry-count for
   the BLOCKNO'th basic block in this source file.  */

#undef BLOCK_PROFILER
#define BLOCK_PROFILER(FILE, BLOCKNO)	\
do {								\
  if (! TARGET_REMOTE)                                          \
    fprintf (FILE, "\taddq.l #1,LPBX2.+%d(a6)\n", 4 * BLOCKNO);	\
  else if (TARGET_68020)                                        \
    fprintf (FILE, "\taddq.l #1,(LPBX2.+%d,a6)\n", 4 * BLOCKNO);\
  else								\
    fprintf (FILE, "\tmove.l d0,-(sp)\n\tmove.l #LPBX2.+%d,d0\n\taddq.l #1,(a6,d0.l)\n\tmove.l (sp)+,d0\n", 4 * BLOCKNO); \
  CC_STATUS_INIT;  /* the code clobbers condition code. */	\
} while (0)

/* This macro generates the assembly code for function exit,
   on machines that need it.  If FUNCTION_EPILOGUE is not defined
   then individual return instructions are generated for each
   return statement.  Args are same as for FUNCTION_PROLOGUE.

   The function epilogue should not depend on the current stack pointer!
   It should use the frame pointer only.  This is mandatory because
   of alloca; we also take advantage of it to omit stack adjustments
   before returning.  */

#undef FUNCTION_EPILOGUE
#define FUNCTION_EPILOGUE(FILE, SIZE) \
{ register int regno;						\
  register int mask, fmask;					\
  register int nregs;						\
  int offset, foffset;						\
  extern char call_used_regs[];					\
  extern int current_function_pops_args;			\
  extern int current_function_args_size;			\
  extern int may_call_alloca;					\
  int fsize = ((SIZE) + 3) & -4;				\
  int big = 0;							\
  FUNCTION_EXTRA_EPILOGUE (FILE, SIZE);				\
  nregs = 0;  fmask = 0;					\
  for (regno = 16; regno < FIRST_PSEUDO_REGISTER; regno++)	\
    if (regs_ever_live[regno] && ! call_used_regs[regno])	\
      { nregs++; fmask |= 1 << (23 - regno); }			\
  foffset = nregs * 12;						\
  nregs = 0;  mask = 0;						\
  if (frame_pointer_needed) regs_ever_live[FRAME_POINTER_REGNUM] = 0; \
  for (regno = 0; regno < 16; regno++)				\
    if (regs_ever_live[regno] && ! call_used_regs[regno])	\
      { nregs++; mask |= 1 << regno; }				\
  offset = foffset + nregs * 4;					\
  if (offset + fsize >= 0x8000 && frame_pointer_needed)		\
    { fprintf (FILE, "\tmove.l #%d,a0\n", -fsize);		\
      fsize = 0, big = 1; }					\
  if (exact_log2 (mask) >= 0) {					\
    if (big)							\
      fprintf (FILE, "\tmove.l -%d(a5,a0.l),%s\n",		\
	       offset + fsize, reg_names[exact_log2 (mask)]);	\
    else if (! frame_pointer_needed)				\
      fprintf (FILE, "\tmove.l (sp)+,%s\n",			\
	       reg_names[exact_log2 (mask)]);			\
    else							\
      fprintf (FILE, "\tmove.l -%d(a5),%s\n",			\
	       offset + fsize, reg_names[exact_log2 (mask)]); }	\
  else if (mask) {						\
    if (big)							\
      fprintf (FILE, "\tmovem.l -%d(a5,a0.l),#0x%x\n",		\
	       offset + fsize, mask);				\
    else if (! frame_pointer_needed)				\
      fprintf (FILE, "\tmovem.l (sp)+,#0x%x\n", mask);		\
    else							\
      fprintf (FILE, "\tmovem.l -%d(a5),#0x%x\n",		\
	       offset + fsize, mask); }				\
  if (fmask) {							\
    if (big)							\
      fprintf (FILE, "\tfmovem.x -%d(a5,a0.l),#0x%x\n",		\
	       foffset + fsize, fmask);				\
    else if (! frame_pointer_needed)				\
      fprintf (FILE, "\tfmovem.x (sp)+,#0x%x\n", fmask);	\
    else							\
      fprintf (FILE, "\tfmovem.x -%d(a5),#0x%x\n",		\
	       foffset + fsize, fmask); }			\
  if (may_call_alloca)						\
    fprintf (FILE, "\tbsr _free_allocaed\n");			\
  if (frame_pointer_needed)					\
    fprintf (FILE, "\tunlk a5\n");				\
  if (current_function_pops_args && current_function_args_size)	\
    fprintf (FILE, "\trtd #%d\n", current_function_args_size);	\
  else fprintf (FILE, "\trts\n"); }

/* Control the assembler format that we output.  */

#undef ASM_FILE_START
#define ASM_FILE_START(FILE)	\
  do { char pn[64]; register char *p, *q;			\
       extern char *main_input_filename;			\
    /* make psect name */					\
    if (q = (char *)rindex (main_input_filename, '/'))		\
      ++q;							\
    else							\
      q = main_input_filename;					\
    p = (char *)rindex (strcpy (pn, q), '.');			\
    if (!p)							\
      p = pn + strlen (q);					\
    strcpy (p, "_gcc");						\
    if (TARGET_REGPARM)						\
      *(p + 3) = '\0';						\
    fprintf (FILE, "\tpsect\t%s,0,0,0,0,0\n", pn);		\
  } while (0)

#undef ASM_OUTPUT_SOURCE_FILENAME

#undef ASM_OUTPUT_SOURCE_LINE

#undef ASM_FILE_END
#define ASM_FILE_END(FILE)	\
{ text_section (); fprintf (FILE, "\tends\n"); }

/* #undef ASM_IDENTIFY_GCC  no definition in tm_m68k.h.
   do nothing if OSK */
#define ASM_IDENTIFY_GCC(FILE)

#undef ASM_APP_ON
#define ASM_APP_ON "*APP\n"

#undef ASM_APP_OFF
#define ASM_APP_OFF "*NO_APP\n"

#undef TEXT_SECTION_ASM_OP
#define TEXT_SECTION_ASM_OP "\tends"

#undef DATA_SECTION_ASM_OP
#define DATA_SECTION_ASM_OP \
  (TARGET_REMOTE ? "\tvsect\tremote" : "\tvsect")

#undef ASM_OUTPUT_LABEL
#define ASM_OUTPUT_LABEL(FILE,NAME)			\
  do {							\
    assemble_name (FILE, NAME);				\
    if (label_is_global)				\
      {							\
	putc (':', FILE);				\
	label_is_global = 0;				\
      }							\
    fputs ("\n", FILE);					\
  } while (0)

#undef ASM_DECLARE_FUNCTION_NAME
#define ASM_DECLARE_FUNCTION_NAME(FILE, NAME, DECL)			\
  do {									\
    ASM_OUTPUT_LABEL (FILE, NAME);					\
    if (TARGET_GSS && ! TREE_PUBLIC (DECL))				\
      {									\
	extern char *main_input_filename;				\
	extern char *rindex ();						\
	char *gss_name, *p;						\
	if (p = rindex (main_input_filename, '/'))			\
	  ++p;								\
	else								\
	  p = main_input_filename;					\
	gss_name = (char *) alloca (2 + strlen (p) + strlen (NAME));	\
	strcpy (gss_name, NAME);					\
	strcat (gss_name, "@");						\
	strcat (gss_name, p);						\
	if (rindex (p, '.'))						\
	  *rindex (gss_name, '.') = '\0';				\
	fprintf (FILE, "%s:\n", gss_name);				\
      }									\
  } while (0)

#undef ASM_GLOBALIZE_LABEL
#define ASM_GLOBALIZE_LABEL(FILE,NAME)	(label_is_global = 1)

#undef ASM_OUTPUT_LABELREF
#define ASM_OUTPUT_LABELREF(FILE,NAME) \
  fprintf (FILE, "%s", NAME)

#undef ASM_OUTPUT_INTERNAL_LABEL
#define ASM_OUTPUT_INTERNAL_LABEL(FILE,PREFIX,NUM)	\
  fprintf (FILE, "%s%d.\n", PREFIX, NUM)

/* This is how to store into the string LABEL
   the symbol_ref name of an internal numbered label where
   PREFIX is the class of label and NUM is the number within the class.
   This is suitable for output with `assemble_name'.  */

#undef ASM_GENERATE_INTERNAL_LABEL
#define ASM_GENERATE_INTERNAL_LABEL(LABEL,PREFIX,NUM)	\
  sprintf (LABEL, "%s%d.", PREFIX, NUM)

#undef ASM_OUTPUT_DOUBLE
#define ASM_OUTPUT_DOUBLE(FILE,VALUE)                   \
  do { unsigned long int tem1, tem2;                    \
    conv_ieee64(VALUE, &tem1, &tem2);                   \
    fprintf (FILE, "\tdc.l 0x%x,0x%x\n", tem1, tem2);   \
  } while (0)

#undef ASM_OUTPUT_FLOAT
#define ASM_OUTPUT_FLOAT(FILE,VALUE)            \
  do { unsigned long int tem;                   \
    conv_ieee32(VALUE, &tem);                   \
    fprintf (FILE, "\tdc.l $%x\n", tem);        \
  } while (0)

/* This is how to output an assembler line defining an `int' constant.  */

#undef ASM_OUTPUT_INT
#define ASM_OUTPUT_INT(FILE,VALUE)  \
( fprintf (FILE, "\tdc.l "),			\
  output_addr_const (FILE, (VALUE)),		\
  fprintf (FILE, "\n"))

/* Likewise for `char' and `short' constants.  */

#undef ASM_OUTPUT_SHORT
#define ASM_OUTPUT_SHORT(FILE,VALUE)  \
( fprintf (FILE, "\tdc.w "),			\
  output_addr_const (FILE, (VALUE)),		\
  fprintf (FILE, "\n"))

#undef ASM_OUTPUT_CHAR
#define ASM_OUTPUT_CHAR(FILE,VALUE)  \
( fprintf (FILE, "\tdc.b "),			\
  output_addr_const (FILE, (VALUE)),		\
  fprintf (FILE, "\n"))

/* This is how to output an assembler line for a numeric constant byte.  */

#undef ASM_OUTPUT_BYTE
#define ASM_OUTPUT_BYTE(FILE,VALUE)  \
  fprintf (FILE, "\tdc.b $%x\n", (VALUE))

/* This is how to output an insn to push a register on the stack.
   It need not be very fast code.  */

#undef ASM_OUTPUT_REG_PUSH
#define ASM_OUTPUT_REG_PUSH(FILE,REGNO)  \
  fprintf (FILE, "\tmove.l %s,-(sp)\n", reg_names[REGNO])

/* This is how to output an insn to pop a register from the stack.
   It need not be very fast code.  */

#undef ASM_OUTPUT_REG_POP
#define ASM_OUTPUT_REG_POP(FILE,REGNO)  \
  fprintf (FILE, "\tmove.l (sp)+,%s\n", reg_names[REGNO])

/* This is how to output an element of a case-vector that is absolute.
   (The 68000 does not use such vectors,
   but we must define this macro anyway.)  */

#undef ASM_OUTPUT_ADDR_VEC_ELT
#define ASM_OUTPUT_ADDR_VEC_ELT(FILE, VALUE)  \
  fprintf (FILE, "\tdc.l L%d.\n", VALUE)

/* This is how to output an element of a case-vector that is relative.  */

#undef ASM_OUTPUT_ADDR_DIFF_ELT
#define ASM_OUTPUT_ADDR_DIFF_ELT(FILE, VALUE, REL)  \
  fprintf (FILE, "\tdc.w L%d.-L%d.\n", VALUE, REL)

#undef ASM_OUTPUT_ALIGN
#define ASM_OUTPUT_ALIGN(FILE,LOG)	\
    fprintf (FILE, "\talign\n");

#undef ASM_OUTPUT_SKIP
#define ASM_OUTPUT_SKIP(FILE,SIZE)  \
  fprintf (FILE, "\tdz.b\t%d\n", (SIZE))

/* This says how to output an assembler line
   to define a global common symbol.  */

/* bug of l68 (ed. 53) prevent me to use com.b.  (A.S.) */
#undef ASM_OUTPUT_COMMON
#define ASM_OUTPUT_COMMON(FILE, NAME, SIZE, ROUNDED)  \
( fprintf ((FILE), "\talign\n"),                \
  assemble_name ((FILE), (NAME)),		\
  fprintf ((FILE), ":\tds.b\t%d\n", (ROUNDED)))

/* This says how to output an assembler line
   to define a local common symbol.  */

#undef ASM_OUTPUT_LOCAL
#define ASM_OUTPUT_LOCAL(FILE, NAME, SIZE, ROUNDED)  \
( fprintf ((FILE), "\talign\n"),			\
  fprintf ((FILE), *(NAME) == '*' ? (NAME)+1 : (NAME)),	\
  fprintf ((FILE), "\tds.b\t%d\n", (ROUNDED)))

#undef ASM_OUTPUT_FLOAT_OPERAND
#define ASM_OUTPUT_FLOAT_OPERAND(FILE,VALUE)    \
  do { unsigned long int tem;                   \
    conv_ieee32(VALUE, &tem);                   \
    fprintf (FILE, "#0x%x", tem);               \
  } while (0)

#undef ASM_OUTPUT_DOUBLE_OPERAND
#define ASM_OUTPUT_DOUBLE_OPERAND(FILE,VALUE)   \
  do { unsigned long int tem1, tem2;            \
    conv_ieee64(VALUE, &tem1, &tem2);           \
    fprintf (FILE, "#0x%08x%08x", tem1, tem2);  \
  } while (0)

#undef PRINT_OPERAND
#define PRINT_OPERAND(FILE, X, CODE)  \
{ if (CODE == 'p') {							\
    if (TARGET_68020 && TARGET_REMOTE) {                                \
      putc ('(', FILE);							\
      output_address (X);						\
      fprintf (FILE, ",pc)"); }                                         \
    else {                                                              \
      output_address (X);                                               \
      fprintf (FILE, "(pc)"); }}                                        \
  else if (CODE == 'v') {						\
    if (TARGET_68020 && TARGET_REMOTE) {                                \
      putc ('(', FILE);							\
      output_address (X);						\
      fprintf (FILE, ",a6)"); }						\
    else {								\
      output_address (X);						\
      fprintf (FILE, "(a6)"); }}					\
  else if (CODE == '.') fprintf (FILE, ".");				\
  else if (CODE == '#')	fprintf (FILE, "#");				\
  else if (CODE == '-') fprintf (FILE, "-(sp)");			\
  else if (CODE == '+') fprintf (FILE, "(sp)+");			\
  else if (CODE == '@') fprintf (FILE, "(sp)");				\
  else if (CODE == '!') fprintf (FILE, "ccr");				\
  else if (GET_CODE (X) == REG)						\
    fprintf (FILE, "%s", reg_names [REGNO (X)]);			\
  else if (GET_CODE (X) == MEM) {					\
    if (CODE == 'i')							\
      fprintf (FILE, "#");						\
    output_address (XEXP (X, 0));					\
  } else if (GET_CODE (X) == CONST_DOUBLE && GET_MODE (X) == SFmode)	\
    { union { double d; int i[2]; } u;					\
      u.i[0] = CONST_DOUBLE_LOW (X); u.i[1] = CONST_DOUBLE_HIGH (X);	\
      ASM_OUTPUT_FLOAT_OPERAND (FILE, u.d); }                           \
  else if (GET_CODE (X) == CONST_DOUBLE && GET_MODE (X) != DImode)	\
    { union { double d; int i[2]; } u;					\
      u.i[0] = CONST_DOUBLE_LOW (X); u.i[1] = CONST_DOUBLE_HIGH (X);	\
      ASM_OUTPUT_DOUBLE_OPERAND (FILE, u.d); }                          \
  else if (CODE == 'b') output_addr_const (FILE, X);			\
  else if (CODE == 'i')							\
    {									\
      fprintf (FILE, "#");						\
      output_addr_const (FILE, X);					\
    }									\
  else									\
    { if (GET_CODE (X) == CONST_INT)					\
	putc ('#', FILE);						\
      output_addr_const (FILE, X); }}

#undef PRINT_OPERAND_ADDRESS
#define PRINT_OPERAND_ADDRESS(FILE, ADDR)  \
{ register rtx reg1, reg2, breg, ireg;					\
  register rtx addr = ADDR;						\
  rtx offset;								\
  switch (GET_CODE (addr))						\
    {									\
    case REG:								\
      fprintf (FILE, "(%s)", reg_names [REGNO (addr)]);			\
      break;								\
    case PRE_DEC:							\
      fprintf (FILE, "-(%s)", reg_names [REGNO (XEXP (addr, 0))]);	\
      break;								\
    case POST_INC:							\
      fprintf (FILE, "(%s)+", reg_names [REGNO (XEXP (addr, 0))]);	\
      break;								\
    case PLUS:								\
      reg1 = 0;	reg2 = 0;						\
      ireg = 0;	breg = 0;						\
      offset = 0;							\
      if (CONSTANT_ADDRESS_P (XEXP (addr, 0)))				\
	{								\
	  offset = XEXP (addr, 0);					\
	  addr = XEXP (addr, 1);					\
	}								\
      else if (CONSTANT_ADDRESS_P (XEXP (addr, 1)))			\
	{								\
	  offset = XEXP (addr, 1);					\
	  addr = XEXP (addr, 0);					\
	}								\
      if (GET_CODE (addr) != PLUS) ;					\
      else if (GET_CODE (XEXP (addr, 0)) == SIGN_EXTEND)		\
	{								\
	  reg1 = XEXP (addr, 0);					\
	  addr = XEXP (addr, 1);					\
	}								\
      else if (GET_CODE (XEXP (addr, 1)) == SIGN_EXTEND)		\
	{								\
	  reg1 = XEXP (addr, 1);					\
	  addr = XEXP (addr, 0);					\
	}								\
      else if (GET_CODE (XEXP (addr, 0)) == MULT)			\
	{								\
	  reg1 = XEXP (addr, 0);					\
	  addr = XEXP (addr, 1);					\
	}								\
      else if (GET_CODE (XEXP (addr, 1)) == MULT)			\
	{								\
	  reg1 = XEXP (addr, 1);					\
	  addr = XEXP (addr, 0);					\
	}								\
      else if (GET_CODE (XEXP (addr, 0)) == REG)			\
	{								\
	  reg1 = XEXP (addr, 0);					\
	  addr = XEXP (addr, 1);					\
	}								\
      else if (GET_CODE (XEXP (addr, 1)) == REG)			\
	{								\
	  reg1 = XEXP (addr, 1);					\
	  addr = XEXP (addr, 0);					\
	}								\
      if (GET_CODE (addr) == REG || GET_CODE (addr) == MULT		\
	  || GET_CODE (addr) == SIGN_EXTEND)				\
	{ if (reg1 == 0) reg1 = addr; else reg2 = addr; addr = 0; }	\
      if (offset != 0) { if (addr != 0) abort (); addr = offset; }	\
      if ((reg1 && (GET_CODE (reg1) == SIGN_EXTEND			\
		    || GET_CODE (reg1) == MULT))			\
	  || (reg2 != 0 && REGNO_OK_FOR_BASE_P (REGNO (reg2))))		\
	{ breg = reg2; ireg = reg1; }					\
      else if (reg1 != 0 && REGNO_OK_FOR_BASE_P (REGNO (reg1)))		\
	{ breg = reg1; ireg = reg2; }					\
      if (ireg != 0 && breg == 0 && GET_CODE (addr) == LABEL_REF)	\
        { int scale = 1;						\
	  if (GET_CODE (ireg) == MULT)					\
	    { scale = INTVAL (XEXP (ireg, 1));				\
	      ireg = XEXP (ireg, 0); }					\
	  if (GET_CODE (ireg) == SIGN_EXTEND)				\
	    fprintf (FILE, "L%d.-LI%d.(pc,%s.w",			\
		     CODE_LABEL_NUMBER (XEXP (addr, 0)),		\
		     CODE_LABEL_NUMBER (XEXP (addr, 0)),		\
		     reg_names[REGNO (XEXP (ireg, 0))]); 		\
	  else								\
	    fprintf (FILE, "L%d.-LI%d.(pc,%s.l",			\
		     CODE_LABEL_NUMBER (XEXP (addr, 0)),		\
		     CODE_LABEL_NUMBER (XEXP (addr, 0)),		\
		     reg_names[REGNO (ireg)]);				\
	  if (scale != 1) fprintf (FILE, "*%d", scale);			\
	  putc (')', FILE);						\
	  break; }							\
      if (breg != 0 && ireg == 0 && GET_CODE (addr) == LABEL_REF)	\
        { fprintf (FILE, "L%d.-LI%d.(pc,%s.l)",				\
		   CODE_LABEL_NUMBER (XEXP (addr, 0)),			\
		   CODE_LABEL_NUMBER (XEXP (addr, 0)),			\
		   reg_names[REGNO (breg)]);				\
	  break; }							\
      if (ireg != 0 || breg != 0)					\
	{ int scale = 1;						\
	  if (breg == 0)						\
	    abort ();							\
	  if (addr != 0)						\
	    output_addr_const (FILE, addr);				\
	  putc ('(', FILE);						\
	  fprintf (FILE, "%s", reg_names[REGNO (breg)]);		\
	  if (ireg != 0)						\
	    putc (',', FILE);						\
	  if (ireg != 0 && GET_CODE (ireg) == MULT)			\
	    { scale = INTVAL (XEXP (ireg, 1));				\
	      ireg = XEXP (ireg, 0); }					\
	  if (ireg != 0 && GET_CODE (ireg) == SIGN_EXTEND)		\
	    fprintf (FILE, "%s.w", reg_names[REGNO (XEXP (ireg, 0))]);	\
	  else if (ireg != 0)						\
	    fprintf (FILE, "%s.l", reg_names[REGNO (ireg)]);		\
	  if (scale != 1) fprintf (FILE, "*%d", scale);			\
	  putc (')', FILE);						\
	  break;							\
	}								\
      else if (reg1 != 0 && GET_CODE (addr) == LABEL_REF)		\
	{ fprintf (FILE, "L%d.-LI%d.(pc,%s.l)",				\
		   CODE_LABEL_NUMBER (XEXP (addr, 0)),			\
		   CODE_LABEL_NUMBER (XEXP (addr, 0)),			\
		   reg_names[REGNO (reg1)]);				\
	  break; }							\
    default:								\
      if (GET_CODE (addr) == CONST_INT					\
	  && INTVAL (addr) < 0x8000					\
	  && INTVAL (addr) >= -0x8000)					\
	fprintf (FILE, "%d", INTVAL (addr));				\
      else								\
        output_addr_const (FILE, addr);					\
    }}

/* #undef ASM_OUTPUT_ASCII  no definition in tm_m68k.h */
#define ASM_OUTPUT_ASCII(FILE, STRING, SIZE)	\
  do {						\
    register int i, j;				\
    register unsigned char *_p = STRING;	\
						\
    fprintf (FILE, "\tdc.b\t\"");		\
    j = 7;					\
						\
    for (i = 0; i < SIZE; ++i)			\
      {	register int c = _p[i];			\
	if (j > 240)				\
	  { fprintf (FILE, "\"\n\tdc.b\t\"");	\
	    j = 7; }				\
	if (c == '\"')				\
	  { fputs ("\",$22,\"", FILE);		\
	    j += 7; }				\
	else if (c == '\\')			\
	  { fputs ("\",$5c,\"", FILE);		\
	    j += 7; }				\
	else if (c >= ' ' && c < 0x7f)		\
	  { putc (c, FILE);			\
	    ++j; }				\
	else					\
	  { fprintf (FILE, "\",$%02x,\"", c);	\
	    j += 7; }}				\
    if (in_section == in_text)			\
      fprintf (FILE, "\" :%d\n", ((SIZE) + 1) & ~1);\
    else					\
      fprintf (FILE, "\"\n");			\
  } while (0)

/* Compute the cost of computing a constant rtl expression RTX
   whose rtx-code is CODE.  The body of this macro is a portion
   of a switch statement.  If the code is computed here,
   return it with a return statement.  Otherwise, break from the switch.  */

#undef CONST_COSTS
#define CONST_COSTS(RTX,CODE) \
  case CONST_INT:						\
    /* Constant zero is super cheap due to clr instruction.  */	\
    if (RTX == const0_rtx) return 0;				\
    if ((INTVAL (RTX) >= -128) && (INTVAL (RTX) <= 127)) return 1; \
    return 3;							\
  case LABEL_REF:						\
  case SYMBOL_REF:						\
    return 2;							\
  case DATA_REF:						\
    if (TARGET_REMOTE) return 5;				\
    return 2;							\
  case CONST_DOUBLE:						\
    return 5;

#undef NOTICE_UPDATE_CC
#define NOTICE_UPDATE_CC(EXP,INSN) \
{ if (GET_CODE (EXP) == SET)					\
    { if (ADDRESS_REG_P (SET_DEST (EXP)))			\
	{ if (cc_status.value1					\
	      && reg_overlap_mentioned_p (SET_DEST (EXP), cc_status.value1)) \
	    cc_status.value1 = 0;				\
	  if (cc_status.value2					\
	      && reg_overlap_mentioned_p (SET_DEST (EXP), cc_status.value2)) \
	    cc_status.value2 = 0; }				\
      else if (!FP_REG_P (SET_DEST (EXP))			\
	       && SET_DEST (EXP) != cc0_rtx			\
	       && (FP_REG_P (SET_SRC (EXP))			\
		   || GET_CODE (SET_SRC (EXP)) == FIX		\
		   || GET_CODE (SET_SRC (EXP)) == FLOAT_TRUNCATE \
		   || GET_CODE (SET_SRC (EXP)) == FLOAT_EXTEND)) \
	{ CC_STATUS_INIT; }					\
      /* A pair of move insns doesn't produce a useful overall cc.  */ \
      else if (!FP_REG_P (SET_DEST (EXP))			\
	       && !FP_REG_P (SET_SRC (EXP))			\
	       && GET_MODE_SIZE (GET_MODE (SET_SRC (EXP))) > 4	\
	       && (GET_CODE (SET_SRC (EXP)) == REG		\
		   || GET_CODE (SET_SRC (EXP)) == MEM		\
		   || GET_CODE (SET_SRC (EXP)) == CONST_DOUBLE))\
	{ CC_STATUS_INIT; }					\
      else if (GET_CODE (SET_SRC (EXP)) == CALL)		\
	{ CC_STATUS_INIT; }					\
      else if (XEXP (EXP, 0) != pc_rtx)				\
	{ cc_status.flags = 0;					\
	  cc_status.value1 = XEXP (EXP, 0);			\
	  cc_status.value2 = XEXP (EXP, 1); } }			\
  else if (GET_CODE (EXP) == PARALLEL				\
	   && GET_CODE (XVECEXP (EXP, 0, 0)) == SET)		\
    { if (ADDRESS_REG_P (XEXP (XVECEXP (EXP, 0, 0), 0)))	\
	CC_STATUS_INIT;						\
      else if (XEXP (XVECEXP (EXP, 0, 0), 0) != pc_rtx)		\
	{ cc_status.flags = 0;					\
	  cc_status.value1 = XEXP (XVECEXP (EXP, 0, 0), 0);	\
	  cc_status.value2 = XEXP (XVECEXP (EXP, 0, 0), 1); } }	\
  else CC_STATUS_INIT;						\
  if (cc_status.value2 != 0					\
      && ADDRESS_REG_P (cc_status.value2)			\
      && GET_MODE (cc_status.value2) == QImode)			\
    CC_STATUS_INIT;						\
  if (cc_status.value2 != 0)					\
    switch (GET_CODE (cc_status.value2))			\
      { case PLUS: case MINUS: case MULT: case UMULT:		\
	case DIV: case UDIV: case MOD: case UMOD: case NEG:	\
	case ASHIFT: case LSHIFT: case ASHIFTRT: case LSHIFTRT:	\
	case ROTATE: case ROTATERT:				\
	  if (GET_MODE (cc_status.value2) != VOIDmode)		\
	    cc_status.flags |= CC_NO_OVERFLOW;			\
	  break;						\
	case ZERO_EXTEND:					\
	  /* (SET r1 (ZERO_EXTEND r2)) on this machine
	     ends with a move insn moving r2 in r2's mode.
	     Thus, the cc's are set for r2.
	     This can set N bit spuriously. */			\
	  cc_status.flags |= CC_NOT_NEGATIVE; }			\
  if (cc_status.value1 && GET_CODE (cc_status.value1) == REG	\
      && cc_status.value2					\
      && reg_overlap_mentioned_p (cc_status.value1, cc_status.value2))	\
    cc_status.value2 = 0;					\
  if ((cc_status.value1 && FP_REG_P (cc_status.value1))		\
      || (cc_status.value2 && FP_REG_P (cc_status.value2)))	\
    cc_status.flags = CC_IN_68881; }

#undef REGISTER_NAMES
#define REGISTER_NAMES \
{"d0", "d1", "d2", "d3", "d4", "d5", "d6", "d7",	\
 "a0", "a1", "a2", "a3", "a4", "a5", "a6", "sp",	\
 "fp0", "fp1", "fp2", "fp3", "fp4", "fp5", "fp6", "fp7"}

/* For OSK, no sdb and dbx debugging info */
#undef	SDB_DEBUGGING_INFO
#undef	DBX_DEBUGGING_INFO

/* Define results of standard character escape sequences.  */
#undef TARGET_NEWLINE
#define TARGET_NEWLINE 015
#define TARGET_LF      012

#define LINK_SPEC	\
 "%{!j:-a} %{g} %{p:%{!g:-g}} %{ghost:-S} %{s:-M %=%r} %{e:-e %=%r} %{n:-n %=%r} %{P:-p %=%r}"

#define STARTFILE_SPEC	"cstart.r%s"

#define LIB_SPEC	\
 "%{cio:-l %=cio.l%s} %{m68881:-l %=clib020h.l%s -l %=math881.l%s}\
 %{!m68881:-l %=clib%{mc68020:020}%{!mc68020:%{m68020:020}}n.l%s\
 -l %=math.l%s} -l %=sys.l%s"

/* Names to predefine in the preprocessor for this target machine.  */

#define CPP_PREDEFINES "-DOSK -Dmc68000"

#define CPP_SPEC "%{m68881:-D__HAVE_68881__}"
