/* Compiler driver program that can handle many languages.
   Copyright (C) 1987,1989 Free Software Foundation, Inc.

This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

This paragraph is here to try to keep Sun CC from dying.
The number of chars here seems crucial!!!!  */

void record_temp_file ();

/* This program is the user interface to the C compiler and possibly to
other compilers.  It is used because compilation is a complicated procedure
which involves running several programs and passing temporary files between
them, forwarding the users switches to those programs selectively,
and deleting the temporary files at the end.

CC recognizes how to compile each input file by suffixes in the file names.
Once it knows which kind of compilation to perform, the procedure for
compilation is specified by a string called a "spec".

Specs are strings containing lines, each of which (if not blank)
is made up of a program name, and arguments separated by spaces.
The program name must be exact and start from root, since no path
is searched and it is unreliable to depend on the current working directory.
Redirection of input or output is not supported; the subprograms must
accept filenames saying what files to read and write.

In addition, the specs can contain %-sequences to substitute variable text
or for conditional text.  Here is a table of all defined %-sequences.
Note that spaces are not generated automatically around the results of
expanding these sequences; therefore, you can concatenate them together
or with constant text in a single argument.

 %%	substitute one % into the program name or argument.
 %i     substitute the name of the input file being processed.
 %b     substitute the basename of the input file being processed.
	This is the substring up to (and not including) the last period.
 %g     substitute the temporary-file-name-base.  This is a string chosen
	once per compilation.  Different temporary file names are made by
	concatenation of constant strings on the end, as in `%g.s'.
	%g also has the same effect of %d.
 %d	marks the argument containing or following the %d as a
	temporary file name, so that that file will be deleted if CC exits
	successfully.  Unlike %g, this contributes no text to the argument.
 %w	marks the argument containing or following the %w as the
	"output file" of this compilation.  This puts the argument
	into the sequence of arguments that %o will substitute later.
 %o	substitutes the names of all the output files, with spaces
	automatically placed around them.  You should write spaces
	around the %o as well or the results are undefined.
	%o is for use in the specs for running the linker.
	Input files whose names have no recognized suffix are not compiled
	at all, but they are included among the output files, so they will
	be linked.
 %p	substitutes the standard macro predefinitions for the
	current target machine.  Use this when running cpp.
 %P	like %p, but puts `__' before and after the name of each macro.
	This is for ANSI C.
 %s     current argument is the name of a library or startup file of some sort.
        Search for that file in a standard list of directories
	and substitute the full pathname found.
 %eSTR  Print STR as an error message.  STR is terminated by a newline.
        Use this when inconsistent options are detected.
 %a     process ASM_SPEC as a spec.
        This allows config.h to specify part of the spec for running as.
 %l     process LINK_SPEC as a spec.
 %L     process LIB_SPEC as a spec.
 %S     process STARTFILE_SPEC as a spec.  A capital S is actually used here.
 %c	process SIGNED_CHAR_SPEC as a spec.
 %C     process CPP_SPEC as a spec.  A capital C is actually used here.
 %1	process CC1_SPEC as a spec.
 %{S}   substitutes the -S switch, if that switch was given to CC.
	If that switch was not specified, this substitutes nothing.
	Here S is a metasyntactic variable.
 %{S*}  substitutes all the switches specified to CC whose names start
	with -S.  This is used for -o, -D, -I, etc; switches that take
	arguments.  CC considers `-o foo' as being one switch whose
	name starts with `o'.  %{o*} would substitute this text,
	including the space; thus, two arguments would be generated.
 %{S:X} substitutes X, but only if the -S switch was given to CC.
 %{!S:X} substitutes X, but only if the -S switch was NOT given to CC.
 %{|S:X} like %{S:X}, but if no S switch, substitute `-'.
 %{|!S:X} like %{!S:X}, but if there is an S switch, substitute `-'.

The conditional text X in a %{S:X} or %{!S:X} construct may contain
other nested % constructs or spaces, or even newlines.
They are processed as usual, as described above.

The character | is used to indicate that a command should be piped to
the following command, but only if -pipe is specified.

Note that it is built into CC which switches take arguments and which
do not.  You might think it would be useful to generalize this to
allow each compiler's spec to say which switches take arguments.  But
this cannot be done in a consistent fashion.  CC cannot even decide
which input files have been specified without knowing which switches
take arguments, and it must know which input files to compile in order
to tell which compilers to run.

CC also knows implicitly that arguments starting in `-l' are to
be treated as compiler output files, and passed to the linker in their proper
position among the other output files.

*/

/* OS-9/68000 cross compiler version by Julian Blake, CERN, November 1990.

This version of the compiler driver is a merge of gcc.c and Atsushi Seyama's
gccosk.c.   It may be used in three ways:
  - Like gcc.c: native compiler for a Un*x system.
  - As a cross compiler for OS-9/68000, running on a Un*x system.
  - Like Seyama's gccosk.c: native compiler for an OS-9/68000 system.

Define OSK_TARGET for cross compilation.  Define OSK and OSK_TARGET for
OS-9 native compilation.

The user interface (compiler options, environment variables, file search
order) of the cross compiler version is almost identical to that of the OS-9
native version.   The later stages of cross compilation (o68, r68 or r68020,
l68), as well as standard header files and run time libraries, are provided
by Microware's Unibridge, which is installed at CERN in subdirectories of
/usr/local/os9.

The search for executable programs and for library files has been rewritten.
It now uses the same table driven technique as cccp.c.  Environment variables
controlling searches may now contain multiple prefixes, separated by colons.

I have added explicit declarations for external and forward referenced
functions, to reduce the number of warnings given when the program is
compiled by gcc with all warnings enabled.
*/

/* Specialization to OSK environment by A.Seyama. (Probably no generic point).

note. 89/02/24 (A.S.)
 new %-sequence %t is available.  %t substitutes the temporary-file-name-base
 as %g, but %t does not mark the file to be deleted later.

note. 89/02/18 (A.S.)
 new %-sequence %r is also valid in the conditional text.
 %r substitutes the argument of the conditional switch.
 It is usefull to convert Un*x like argument passing style to OSK like one,
 e.g. %{o*:-o %=%r} (see below).

note. 89/03/09 (A.S.)
 %i and %b in link stage represent null string.

note. 89/10/24 (A.S.)
 new %-sequence %= is avalable. %= indicates to cocatenate current argument
 with the previous argument via `='.  This is usefull to convert Un*x style
 of option specification with an argument to OSK style.

note. 89/10/24 (A.S.)
 new %-sequence %O substitues each option `-l libfile' in input into
 -l=DIRlibfile.  Effect is something like {l:-l %=%s%r} (although this spec
 does not work).

note. 89/10/24 (A.S.)
 %d means delete tempfile on success in next stage.
 %g means delete tempfile on failure and delete tempfile always in next stage.

note. 89/10/24 (A.S.)
 new %-sequence %D means to delete tempfile on failure.

note. 89/10/27 (A.S.)
 new %-sequence %/ makes current argument as file name relative to default
 working directory into the absolute path list.
*/

#ifndef OSK
#include <stdio.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/file.h>
#else /* OSK */
#include <stdio.h>
#include <ctype.h>
#include <types.h>
#include <signal.h>
#include <module.h>
#endif /* OSK */

#include "config.h"
#include "obstack.h"
#include "gvarargs.h"

#ifdef USG
#define R_OK 4
#define W_OK 2
#define X_OK 1
#define vfork fork
#endif /* USG */

#ifdef OSK
#define R_OK 1
#define W_OK 2
#define X_OK 4
#define IS_DIR 128
#define ISIZE 0x20
#endif /* OSK */

#define obstack_chunk_alloc xmalloc
#define obstack_chunk_free free

/* If a stage of compilation returns an exit status >= 1,
   compilation of that file ceases.  */

#define MIN_FATAL_STATUS 1

/* This is the obstack which we use to allocate many strings.  */

struct obstack obstack;

/* External declarations.  */

extern char *index (), *memcpy (), *memset (),
   *strcat (), *strcmp (), *strncmp (), *strcpy (), *strncpy ();
extern int fprintf (), strlen (), wait ();
extern void abort (), exit (), fflush (), free ();

/* Forward declarations.  */

char *xmalloc (), *xrealloc (), *savestring ();
void error (), fatal (), fancy_abort (), pfatal_with_name (),
  perror_with_name (), perror_exec ();

char *handle_braces ();
char *save_string ();
char *concat ();
int do_spec ();
int do_spec_1 ();
char *find_file ();
static char *find_exec_file ();
void give_switch ();
void validate_switches ();
void validate_all_switches ();

#ifdef OSK
void set_command_exec_param ();
void get_command_exec_param ();
#endif /* OSK */

#ifdef OSK_TARGET
void usage ();
char *absolute_path_of ();
#endif /* OSK_TARGET */

/* config.h can define ASM_SPEC to provide extra args to the assembler
   or extra switch-translations.  */
#ifndef ASM_SPEC
#define ASM_SPEC ""
#endif

/* config.h can define CPP_SPEC to provide extra args to the C preprocessor
   or extra switch-translations.  */
#ifndef CPP_SPEC
#define CPP_SPEC ""
#endif

/* config.h can define CC1_SPEC to provide extra args to cc1
   or extra switch-translations.  */
#ifndef CC1_SPEC
#define CC1_SPEC ""
#endif

/* config.h can define LINK_SPEC to provide extra args to the linker
   or extra switch-translations.  */
#ifndef LINK_SPEC
#define LINK_SPEC ""
#endif

/* config.h can define LIB_SPEC to override the default libraries.  */
#ifndef LIB_SPEC
#define LIB_SPEC "%{!p:%{!pg:-lc}}%{p:-lc_p}%{pg:-lc_p}"
#endif

/* config.h can define STARTFILE_SPEC to override the default crt0 files.  */
#ifndef STARTFILE_SPEC
#define STARTFILE_SPEC  \
  "%{pg:gcrt0.o%s}%{!pg:%{p:mcrt0.o%s}%{!p:crt0.o%s}}"
#endif

/* This spec is used for telling cpp whether char is signed or not.  */
#define SIGNED_CHAR_SPEC  \
  (DEFAULT_SIGNED_CHAR ? "%{funsigned-char:-D__CHAR_UNSIGNED__}"	\
   : "%{!fsigned-char:-D__CHAR_UNSIGNED__}")

/* This defines which switch letters take arguments.  */

#ifndef SWITCH_TAKES_ARG
#ifndef OSK_TARGET
#define SWITCH_TAKES_ARG(CHAR)      \
  ((CHAR) == 'D' || (CHAR) == 'U' || (CHAR) == 'o' \
   || (CHAR) == 'e' || (CHAR) == 'T' || (CHAR) == 'u' \
   || (CHAR) == 'I' || (CHAR) == 'Y' || (CHAR) == 'm' \
   || (CHAR) == 'L' || (CHAR) == 'i' || (CHAR) == 'A')
#else /* OSK_TARGET */
#define SWITCH_TAKES_ARG(CHAR)      \
  ((CHAR) == 'o' || (CHAR) == 'e' || (CHAR) == 's' \
   || (CHAR) == 'n' || (CHAR) == 'P' || (CHAR) == 'I' || (CHAR) == 'i')
#endif /* OSK_TARGET */
#endif

#ifndef OSK_TARGET
/* This defines which multi-letter switches take arguments.  */

#ifndef WORD_SWITCH_TAKES_ARG
#define WORD_SWITCH_TAKES_ARG(STR) (!strcmp (STR, "Tdata"))
#endif
#endif /* OSK_TARGET */

/* This structure says how to run one compiler, and when to do so.  */

struct compiler
{
  char *suffix;			/* Use this compiler for input files
				   whose names end in this suffix.  */
  char *spec;			/* To use this compiler, pass this spec
				   to do_spec.  */
};

/* Here are the specs for compiling files with various known suffixes.
   A file that does not end in any of these suffixes will be passed
   unchanged to the loader and nothing else will be done to it.  */

struct compiler compilers[] =
{
#ifndef OSK_TARGET
  {".c",
   "cpp %{nostdinc} %{C} %{v} %{D*} %{U*} %{I*} %{M*} %{i*} %{trigraphs} -undef \
        -D__GNUC__ %{ansi:-trigraphs -$ -D__STRICT_ANSI__} %{!ansi:%p} %P\
        %c %{O:-D__OPTIMIZE__} %{traditional} %{pedantic}\
	%{Wcomment*} %{Wtrigraphs} %{Wall} %C\
        %i %{!M*:%{!E:%{!pipe:%g.cpp}}}%{E:%{o*}}%{M*:%{o*}} |\n\
    %{!M*:%{!E:cc1 %{!pipe:%g.cpp} %1 \
		   %{!Q:-quiet} -dumpbase %i %{Y*} %{d*} %{m*} %{f*} %{a}\
		   %{g} %{O} %{W*} %{w} %{pedantic} %{ansi} %{traditional}\
		   %{v:-version} %{gg:-symout %g.sym} %{pg:-p} %{p}\
		   %{pg:%{fomit-frame-pointer:%e-pg and -fomit-frame-pointer are incompatible}}\
		   %{S:%{o*}%{!o*:-o %b.s}}%{!S:-o %{|!pipe:%g.s}} |\n\
              %{!S:as %{R} %{j} %{J} %{h} %{d2} %a %{gg:-G %g.sym}\
		      %{c:%{o*}%{!o*:-o %w%b.o}}%{!c:-o %d%w%b.o}\
                      %{!pipe:%g.s}\n }}}"},
  {".cc",
   "cpp -+ %{nostdinc} %{C} %{v} %{D*} %{U*} %{I*} %{M*} %{i*} \
        -undef -D__GNUC__ -D__GNUG__ %p %P\
        %c %{O:-D__OPTIMIZE__} %{traditional} %{pedantic}\
	%{Wcomment*} %{Wtrigraphs} %{Wall} %C\
        %i %{!M*:%{!E:%{!pipe:%g.cpp}}}%{E:%{o*}}%{M*:%{o*}} |\n\
    %{!M*:%{!E:cc1plus %{!pipe:%g.cpp} %1\
		   %{!Q:-quiet} -dumpbase %i %{Y*} %{d*} %{m*} %{f*} %{a}\
		   %{g} %{O} %{W*} %{w} %{pedantic} %{traditional}\
		   %{v:-version} %{gg:-symout %g.sym} %{pg:-p} %{p}\
		   %{pg:%{fomit-frame-pointer:%e-pg and -fomit-frame-pointer are incompatible}}\
		   %{S:%{o*}%{!o*:-o %b.s}}%{!S:-o %{|!pipe:%g.s}} |\n\
              %{!S:as %{R} %{j} %{J} %{h} %{d2} %a %{gg:-G %g.sym}\
		      %{c:%{o*}%{!o*:-o %w%b.o}}%{!c:-o %d%w%b.o}\
                      %{!pipe:%g.s}\n }}}"},
  {".i",
   "cc1 %i %1 %{!Q:-quiet} %{Y*} %{d*} %{m*} %{f*} %{a}\
	%{g} %{O} %{W*} %{w} %{pedantic} %{ansi} %{traditional}\
	%{v:-version} %{gg:-symout %g.sym} %{pg:-p} %{p}\
	%{S:%{o*}%{!o*:-o %b.s}}%{!S:-o %{|!pipe:%g.s}} |\n\
    %{!S:as %{R} %{j} %{J} %{h} %{d2} %a %{gg:-G %g.sym}\
            %{c:%{o*}%{!o*:-o %w%b.o}}%{!c:-o %d%w%b.o} %{!pipe:%g.s}\n }"},
  {".s",
   "%{!S:as %{R} %{j} %{J} %{h} %{d2} %a \
            %{c:%{o*}%{!o*:-o %w%b.o}}%{!c:-o %d%w%b.o} %i\n }"},
  {".S",
   "cpp %{nostdinc} %{C} %{v} %{D*} %{U*} %{I*} %{M*} %{trigraphs} \
        -undef -D__GNUC__ -$ %p %P\
        %c %{O:-D__OPTIMIZE__} %{traditional} %{pedantic}\
	%{Wcomment*} %{Wtrigraphs} %{Wall} %C\
        %i %{!M*:%{!E:%{!pipe:%g.s}}}%{E:%{o*}}%{M*:%{o*}} |\n\
    %{!M*:%{!E:%{!S:as %{R} %{j} %{J} %{h} %{d2} %a \
                    %{c:%{o*}%{!o*:-o %w%b.o}}%{!c:-o %d%w%b.o}\
		    %{!pipe:%g.s}\n }}}"},
#else /* OSK_TARGET */
#ifndef OSK
  {".c",
   "cpp %{nostdinc} %{C} %{v} %{D*} %{U*} %{I*} %{M*} %{i*} %{trigraphs} -undef \
	 -D__GNUC__ %{ansi:-trigraphs -$ -D__STRICT_ANSI__} %{!ansi:%p} %P\
	 %c %{O:-D__OPTIMIZE__} %{traditional} %{pedantic}\
	 %{Wcomment*} %{Wtrigraphs} %{Wall} %C\
	 %i %{!M*:%{!E:%{!pipe:%g.cpp}}}%{E:%{o}}%{M*:%{o}} |\n\
    %{!M*:%{!E:cc1 %{!pipe:%t.cpp} %1 \
		   %{!Q:-quiet} -dumpbase %i %{d*} %{m*} %{f*}\
		   %{O} %{W*} %{w} %{pedantic} %{ansi} %{traditional}\
		   %{v:-version} %{p} %{gg:-symout %b.sym} %{a}\
		   %{S:%{o}%{!o:-o %b.a}}%{!S:-o %g.a}\n\
	       %{!S:%{o68:o68 %t.a %t%d%D.o68\n}\
		    r68%{mc68020:020}%{!mc68020:%{m68020:020}} %a\
			%{v} %{!Q:-q} %t.%{o68:o68}%{!o68:a}\
			-o %=%{c:%{o:%r}%{!o:%w%b.r}}%{!c:%d%w%b.r}\n}}}"},
  {".cc",
   "cpp -+ %{nostdinc} %{C} %{v} %{D*} %{U*} %{I*} %{M*} %{i*} -undef \
	 -D__GNUC__ -D__GNUG__ %p %P\
	 %c %{O:-D__OPTIMIZE__} %{traditional} %{pedantic}\
	 %{Wcomment*} %{Wtrigraphs} %{Wall} %C\
	 %i %{!M*:%{!E:%{!pipe:%g.cpp}}}%{E:%{o}}%{M*:%{o}} |\n\
    %{!M*:%{!E:cc1plus %{!pipe:%t.cpp} %1 \
		   %{!Q:-quiet} -dumpbase %i %{d*} %{m*} %{f*}\
		   %{O} %{W*} %{w} %{pedantic} %{ansi} %{traditional}\
		   %{v:-version} %{p} %{gg:-symout %b.sym} %{a}\
		   %{S:%{o}%{!o:-o %b.a}}%{!S:-o %g.a}\n\
	       %{!S:%{o68:o68 %t.a %t%d%D.o68\n}\
		    r68%{mc68020:020}%{!mc68020:%{m68020:020}} %a\
			%{v} %{!Q:-q} %t.%{o68:o68}%{!o68:a}\
			-o %=%{c:%{o:%r}%{!o:%w%b.r}}%{!c:%d%w%b.r}\n}}}"},
#else /* OSK */
  {".c",
   "cccp %{nostdinc} %{C} %{v} %{D*} %{U*} %{I*} %{M*} %{i*} %{trigraphs} -undef \
	 -D__GNUC__ %{ansi:-trigraphs -$ -D__STRICT_ANSI__} %{!ansi:%p} %P\
	 %c %{O:-D__OPTIMIZE__} %{traditional} %{pedantic}\
	 %{Wcomment*} %{Wtrigraphs} %{Wall} %C\
	 %i %{!M*:%{!E:%{!pipe:%g.cpp}}}%{E:%{o}}%{M*:%{o}} |\n\
    %{!M*:%{!E:cc1 %{!pipe:%t.cpp} %1 \
		   %{!Q:-quiet} -dumpbase %i %{d*} %{m*} %{f*}\
		   %{O} %{W*} %{w} %{pedantic} %{ansi} %{traditional}\
		   %{v:-version} %{p} %{gg:-symout %b.sym} %{a}\
		   %{S:%{o}%{!o:-o %b.a}}%{!S:-o %g.a}\n\
	       %{!S:%{o68:o68 %t.a %t%d%D.o68\n}\
		    r68%{mc68020:020}%{!mc68020:%{m68020:020}} %a\
			%{v} %{!Q:-q} %t.%{o68:o68}%{!o68:a}\
			-o %=%{c:%{o:%r}%{!o:%w%b.r}}%{!c:%d%w%b.r}\n}}}"},
  {".cc",
   "cccp -+ %{nostdinc} %{C} %{v} %{D*} %{U*} %{I*} %{M*} %{i*} -undef \
	 -D__GNUC__ -D__GNUG__ %p %P\
	 %c %{O:-D__OPTIMIZE__} %{traditional} %{pedantic}\
	 %{Wcomment*} %{Wtrigraphs} %{Wall} %C\
	 %i %{!M*:%{!E:%{!pipe:%g.cpp}}}%{E:%{o}}%{M*:%{o}} |\n\
    %{!M*:%{!E:cc1plus %{!pipe:%t.cpp} %1 \
		   %{!Q:-quiet} -dumpbase %i %{d*} %{m*} %{f*}\
		   %{O} %{W*} %{w} %{pedantic} %{ansi} %{traditional}\
		   %{v:-version} %{p} %{gg:-symout %b.sym} %{a}\
		   %{S:%{o}%{!o:-o %b.a}}%{!S:-o %g.a}\n\
	       %{!S:%{o68:o68 %t.a %t%d%D.o68\n}\
		    r68%{mc68020:020}%{!mc68020:%{m68020:020}} %a\
			%{v} %{!Q:-q} %t.%{o68:o68}%{!o68:a}\
			-o %=%{c:%{o:%r}%{!o:%w%b.r}}%{!c:%d%w%b.r}\n}}}"},
#endif /* OSK */
  {".i",
   "cc1 %i %1 %{!Q:-quiet} %{d*} %{m*} %{f*}\
	%{O} %{W*} %{w} %{pedantic} %{ansi} %{traditional}\
	%{v:-version} %{p} %{gg:-symout %b.sym} %{a}\
	%{S:%{o}%{!o:-o %b.a}}%{!S:-o %g.a}\
    %{!S:%{o68:o68 %t.a %t%d%D.o68\n}\
	 r68%{mc68020:020}%{!mc68020:%{m68020:020}} %a\
	     %{v} %{!Q:-q} %t.%{o68:o68}%{!o68:a}\
	     -o %=%{c:%{o:%r}%{!o:%w%b.r}}%{!c:%d%w%b.r}\n}"},
  {".a",
   "%{!S:%{o68:o68 %i %t%d%D.o68\n}\
         r68%{mc68020:020}%{!mc68020:%{m68020:020}} %a\
	     %{v} %{!Q:-q} %{o68:%t.o68}%{!o68:%i}\
	     -o %=%{c:%{o:%r}%{!o:%w%b.r}}%{!c:%d%w%b.r}\n}"},
  {".o68",
   "%{!S:r68%{mc68020:020}%{!mc68020:%{m68020:020}} %a\
	     %{v} %{!Q:-q} %i -o %=%{c:%{o:%r}%{!o:%w%b.r}}%{!c:%d%w%b.r}\n}"},
#endif /* OSK_TARGET */
  /* Mark end of table */
  {0, 0}
};

/* Here is the spec for running the linker, after compiling all files.  */
#ifndef OSK_TARGET
char *link_spec = "%{!c:%{!M*:%{!E:%{!S:ld %{o*} %l\
 %{A} %{d} %{e*} %{N} %{n} %{r} %{s} %{S} %{T*} %{t} %{u*} %{X} %{x} %{z}\
 %{y*} %{!A:%{!nostdlib:%S}} \
 %{L*} %o %{!nostdlib:gnulib%s %{g:-lg} %L gnulib%s}\n }}}}";
#else /* OSK_TARGET */
#ifndef OSK
char *link_spec = 
"%{!c:%{!M*:%{!E:%{!S:l68 -o %=%{o:%r}%{!o:gccout}\
 %l %{!nostdlib:%S} %o %O %{!nostdlib:%{p:prof.l%s}%{!p:%{a:prof.l%s}} -l %=gnulib.l%s %L}\n}}}}";
#else /* OSK */
char *link_spec = 
"%{!c:%{!M*:%{!E:%{!S:l68 -o %=%{!x:%/}%{o:%r}%{!o:gccout}\
 %l %{!nostdlib:%S} %o %O %{!nostdlib:%{p:prof.l%s}%{!p:%{a:prof.l%s}} -l %=gnulib.l%s %L}\n}}}}";

/* structure to hold os9exec parameter for a command to execute (A.S.) */

struct command_exec_param {
  char *name;
  int  length;
  int  stack_size;
  int  priority;
};

struct command_exec_param exec_param_tab[] =
{
  { "cccp",    4, 0, 0},
  { "cc1",     3, 0, 0},
  { "o68",     3, 0, 0},
  { "r68020",  6, 0, 0},
  { "r68",     3, 0, 0},
  { "l68",     3, 0, 0}
};
#endif /* OSK */

/* Flag for debugging (A.S.) */

unsigned char debug_flag = 0;

/* if ignore_error is non zero, continue compilation.
   (currently no routine set this flag to 1)   (A.S.) */

unsigned char ignore_error = 0;
#endif /* OSK_TARGET */

/* Accumulate a command (program name and args), and run it.  */

/* Vector of pointers to arguments in the current line of specifications.  */

char **argbuf;

/* Number of elements allocated in argbuf.  */

int argbuf_length;

/* Number of elements in argbuf currently in use (containing args).  */

int argbuf_index;

/* Number of commands executed so far.  */

int execution_count;

/* Flag indicating whether we should print the command and arguments */

unsigned char vflag;

/* Name with which this program was invoked.  */

char *programname;

/* User-specified -B prefix to attach to command or library file names,
   or 0 if none specified.  */

char *user_exec_prefix = 0;

/* Suffix to attach to directories searched for commands or libraries.  */

char *machine_suffix = 0;

struct file_name_list
  {
    struct file_name_list *next;
    char *fname;
  };

/* List of prefixes to attach to command names.  */

struct file_name_list *exec_prefix_list = 0;
struct file_name_list *last_exec_prefix = 0;

/* Default prefixes to attach to command names.  */

#ifndef STANDARD_EXEC_PREFIX
#ifndef OSK
#define STANDARD_EXEC_PREFIX "/usr/local/lib/gcc-"
#else /* OSK */
#define STANDARD_EXEC_PREFIX "/DD/CMDS/"
#endif /* OSK */
#endif /* !defined STANDARD_EXEC_PREFIX */

struct file_name_list exec_defaults[] =
  {
#ifndef OSK_TARGET
    { &exec_defaults[1], STANDARD_EXEC_PREFIX },
    { 0, "/usr/lib/gcc-" }
#else /* OSK_TARGET */
#ifdef OSK
    { 0, STANDARD_EXEC_PREFIX }
#else /* OSK_TARGET and not OSK*/
    { &exec_defaults[1], STANDARD_EXEC_PREFIX },
    { &exec_defaults[2], "/usr/local/os9/bin_2.3/" },
    { 0, "/usr/local/os9/bin/" }
#endif
#endif /* OSK_TARGET */
  };

/* List of prefixes to attach to library file names.  */

struct file_name_list *startfile_prefix_list = 0;
struct file_name_list *last_startfile_prefix = 0;

/* Default prefixes to attach to library file names.  */

#ifndef STANDARD_STARTFILE_PREFIX
#ifndef OSK
#define STANDARD_STARTFILE_PREFIX "/usr/local/lib/"
#else /* OSK */
#define STANDARD_STARTFILE_PREFIX "/DD/GCCLIB/"
#endif /* OSK */
#endif /* !defined STANDARD_STARTFILE_PREFIX */

struct file_name_list startfile_defaults[] =
  {
#ifndef OSK_TARGET
    { &startfile_defaults[1], STANDARD_STARTFILE_PREFIX },
    { &startfile_defaults[2], "/lib/" },
    { &startfile_defaults[3], "/usr/lib/" },
    { 0, "./" }
#else /* OSK_TARGET */
#ifdef OSK
    { &startfile_defaults[1], STANDARD_STARTFILE_PREFIX },
    { &startfile_defaults[2], "/DD/LIB/" },
    { 0, "" }
#else /* OSK_TARGET and not OSK*/
    { &startfile_defaults[1], STANDARD_STARTFILE_PREFIX },
    { &startfile_defaults[2], "/usr/local/os9/lib_2.3/" },
    { &startfile_defaults[3], "/usr/local/os9/lib/" },
    { 0, "./" }
#endif
#endif /* OSK_TARGET */
  };

/* Clear out the vector of arguments (after a command is executed).  */

void
clear_args ()
{
  argbuf_index = 0;
}

#ifdef OSK_TARGET
/* Nonzero means to combine switch with its argument via = (A.S.) */
int combine_switch_with_arg;

#endif /* OSK_TARGET */
/* Add one argument to the vector at the end.
   This is done when a space is seen or at the end of the line.
   If DELETE_ALWAYS is nonzero, the arg is a filename
    and the file should be deleted eventually.
   If DELETE_FAILURE is nonzero, the arg is a filename
    and the file should be deleted if this compilation fails.  */

#ifdef OSK_TARGET
/* if combine_switch_with_arg, then concat arg with previous arg via `='
   (A.S.) */

#endif /* OSK_TARGET */
#ifndef OSK_TARGET
void
store_arg (arg, delete_always, delete_failure)
     char *arg;
     int delete_always, delete_failure;
#else /* OSK_TARGET */
/* Use enum delete_condition in second and third argument.  (A.S.) */

enum delete_condition {
  nomore_delete,
  delete_on_failure,
  delete_on_success_in_next_stage,
  delete_always_in_next_stage
};

void
store_arg (arg, cond, cond_next, this_is_output_file)
     char *arg;
     enum delete_condition cond, cond_next;
     int  this_is_output_file;
#endif /* OSK_TARGET */
{
#ifndef OSK_TARGET
  if (argbuf_index + 1 == argbuf_length)
    {
      argbuf = (char **) xrealloc (argbuf, (argbuf_length *= 2) * sizeof (char *));
    }

  argbuf[argbuf_index++] = arg;
#else /* OSK_TARGET */
  if (combine_switch_with_arg)
    argbuf[argbuf_index - 1] = concat (argbuf[argbuf_index - 1], "=", arg);
  else
    {
      if (argbuf_index + 1 == argbuf_length)
	argbuf = (char **) xrealloc (argbuf, (argbuf_length *= 2) * sizeof (char *));
      argbuf[argbuf_index++] = arg;
    }

#endif /* OSK_TARGET */
  argbuf[argbuf_index] = 0;

#ifndef OSK_TARGET
  if (delete_always || delete_failure)
    record_temp_file (arg, delete_always, delete_failure);
#else /* OSK_TARGET */
  if (cond != nomore_delete || cond_next != nomore_delete)
    record_temp_file (arg, cond, cond_next, this_is_output_file);
#endif /* OSK_TARGET */
}

/* Record the names of temporary files we tell compilers to write,
   and delete them at the end of the run.  */

/* This is the common prefix we use to make temp file names.
   It is chosen once for each run of this program.
   It is substituted into a spec by %g.
   Thus, all temp file names contain this prefix.
   In practice, all temp file names start with this prefix.

   This prefix comes from the envvar TMPDIR if it is defined;
   otherwise, from the P_tmpdir macro if that is defined;
   otherwise, in /usr/tmp or /tmp.  */

char *temp_filename;

/* Length of the prefix.  */

int temp_filename_length;

#ifdef OSK_TARGET
/* User-specified -T temp file directory name,
   or 0 if none specified.  (A.S.) */

char *user_temp_directory = 0;

#endif /* OSK_TARGET */
/* Define the list of temporary files to delete.  */

struct temp_file
{
  char *name;
  struct temp_file *next;
};

/* Queue of files to delete on success or failure of compilation.  */
#ifndef OSK_TARGET
struct temp_file *always_delete_queue;
#else /* OSK_TARGET */
/* always_delete_mark_queue contains file names to delete in next stage.
   always_delete_queue contains file names to delete in current stage.
   always_delete_after_link_queue contains file names to delete in link stage.
   (A.S.) */
struct temp_file *always_delete_mark_queue = 0;
struct temp_file *always_delete_queue = 0;
struct temp_file *always_delete_after_link_queue = 0;

#endif /* OSK_TARGET */
/* Queue of files to delete on failure of compilation.  */
#ifndef OSK_TARGET
struct temp_file *failure_delete_queue;
#else /* OSK_TARGET */
struct temp_file *failure_delete_queue = 0;
#endif /* OSK_TARGET */

#ifdef OSK_TARGET
/* Queue of files to delete on success of compilation.  (A.S.) */
/* success_delete_mark_queue contains file names to delete on success in next
   stage.
   success_delete_queue contains file names to delete on success in current
   stage.
   success_delete_after_link_queue contains file names to delete on success in
   link stage.  (A.S.) */
struct temp_file *success_delete_mark_queue = 0;
struct temp_file *success_delete_queue = 0;
struct temp_file *success_delete_after_link_queue = 0;

#endif /* OSK_TARGET */
/* Record FILENAME as a file to be deleted automatically.
   ALWAYS_DELETE nonzero means delete it if all compilation succeeds;
   otherwise delete it in any case.
   FAIL_DELETE nonzero means delete it if a compilation step fails;
   otherwise delete it in any case.  */

#ifdef OSK_TARGET
/* Use enum delete_condition in second argument.  (A.S.) */

#endif /* OSK_TARGET */
void
#ifndef OSK_TARGET
record_temp_file (filename, always_delete, fail_delete)
     char *filename;
     int always_delete;
     int fail_delete;
#else /* OSK_TARGET */
record_temp_file (filename, cond, cond_next, this_is_output_file)
     char *filename;
     enum delete_condition cond, cond_next;
     int this_is_output_file;
#endif /* OSK_TARGET */
{
  register char *name;
#ifdef OSK_TARGET
  register struct temp_file *temp, **queue;
#endif /* OSK_TARGET */
  name = (char *) xmalloc (strlen (filename) + 1);
  strcpy (name, filename);

#ifndef OSK_TARGET
  if (always_delete)
#else /* OSK_TARGET */
  if (cond == delete_on_failure)
#endif /* OSK_TARGET */
    {
#ifndef OSK_TARGET
      register struct temp_file *temp;
      for (temp = always_delete_queue; temp; temp = temp->next)
#else /* OSK_TARGET */
      for (temp = failure_delete_queue; temp; temp = temp->next)
#endif /* OSK_TARGET */
	if (! strcmp (name, temp->name))
	  goto already1;
      temp = (struct temp_file *) xmalloc (sizeof (struct temp_file));
#ifndef OSK_TARGET
      temp->next = always_delete_queue;
      temp->name = name;
      always_delete_queue = temp;
    already1:;
    }

  if (fail_delete)
    {
      register struct temp_file *temp;
      for (temp = failure_delete_queue; temp; temp = temp->next)
	if (! strcmp (name, temp->name))
	  goto already2;
      temp = (struct temp_file *) xmalloc (sizeof (struct temp_file));
#endif /* OSK_TARGET */
      temp->next = failure_delete_queue;
      temp->name = name;
      failure_delete_queue = temp;
#ifndef OSK_TARGET
    already2:;
#else /* OSK_TARGET */
    already1:;
#endif /* OSK_TARGET */
    }
#ifdef OSK_TARGET

  if (cond_next == delete_on_success_in_next_stage)
    if (this_is_output_file)
      queue = & success_delete_after_link_queue;
    else
      queue = & success_delete_mark_queue;
  else if (cond_next == delete_always_in_next_stage)
    if (this_is_output_file)
      queue = & always_delete_after_link_queue;
    else
      queue = & always_delete_mark_queue;
  else
    return;

  for (temp = * queue; temp; temp = temp->next)
    if (! strcmp (name, temp->name))
      return;

  temp = (struct temp_file *) xmalloc (sizeof (struct temp_file));
  temp->name = name;
  temp->next = * queue;
  * queue = temp;
#endif /* OSK_TARGET */
}

#ifndef OSK_TARGET
/* Delete all the temporary files whose names we previously recorded.  */
#else /* OSK_TARGET */
/* Delete all the temporary files whose names we previously recorded.
   SUCCESS zero means "delete on failure only" files should be deleted.  */
#endif /* OSK_TARGET */

void
#ifndef OSK_TARGET
delete_temp_files ()
#else /* OSK_TARGET */
delete_temp_files (success)
     int success;
#endif /* OSK_TARGET */
{
  extern int unlink ();
  register struct temp_file *temp;

  for (temp = always_delete_queue; temp; temp = temp->next)
#ifndef OSK_TARGET
    {
#ifdef DEBUG
      int i;
      printf ("Delete %s? (y or n) ", temp->name);
      fflush (stdout);
      i = getchar ();
      if (i != '\n')
	while (getchar () != '\n') ;
      if (i == 'y' || i == 'Y')
#endif /* DEBUG */
	{
	  if (unlink (temp->name) < 0)
	    if (vflag)
	      perror_with_name (temp->name);
	}
    }
#else /* OSK_TARGET */
    if (unlink (temp->name) < 0 && vflag)
      perror_with_name (temp->name);
#endif /* OSK_TARGET */

#ifndef OSK_TARGET
  always_delete_queue = 0;
#else /* OSK_TARGET */
  for (temp = (success ? success_delete_queue : failure_delete_queue);
       temp;
       temp = temp->next)
    if (unlink (temp->name) < 0 && vflag)
      perror_with_name (temp->name);

  success_delete_queue = success_delete_mark_queue;
  always_delete_queue = always_delete_mark_queue;
  failure_delete_queue = 0;
  success_delete_mark_queue = 0;
  always_delete_mark_queue = 0;
#endif /* OSK_TARGET */
}

#ifndef OSK_TARGET
/* Delete all the files to be deleted on error.  */

void
delete_failure_queue ()
{
  extern int unlink ();
  register struct temp_file *temp;

  for (temp = failure_delete_queue; temp; temp = temp->next)
    {
#ifdef DEBUG
      int i;
      printf ("Delete %s? (y or n) ", temp->name);
      fflush (stdout);
      i = getchar ();
      if (i != '\n')
	while (getchar () != '\n') ;
      if (i == 'y' || i == 'Y')
#endif /* DEBUG */
	{
	  if (unlink (temp->name) < 0)
	    if (vflag)
	      perror_with_name (temp->name);
	}
    }
}

#endif /* not OSK_TARGET */
void
clear_failure_queue ()
{
  failure_delete_queue = 0;
}

#ifdef OSK_TARGET
void
init_link_stage_queue ()
{
  success_delete_queue = success_delete_after_link_queue;
  always_delete_queue  = always_delete_after_link_queue;
  success_delete_after_link_queue = success_delete_mark_queue = 0;
  always_delete_after_link_queue  = always_delete_mark_queue  = 0;
}

#endif /* OSK_TARGET */
/* Compute a string to use as the base of all temporary file names.
   It is substituted for %g.  */

#ifdef OSK_TARGET
/* Use user_temp_directory, or environment variable TMPDIR if specified.
  (A.S.) */

#endif /* OSK_TARGET */
void
choose_temp_base ()
{
  extern int access ();
  extern char *mktemp ();
  extern char *getenv ();
#ifndef OSK_TARGET
  char *base = getenv ("TMPDIR");
  int len;

  if (base == (char *)0)
    {
#ifdef P_tmpdir
      if (access (P_tmpdir, R_OK | W_OK) == 0)
	base = P_tmpdir;
#endif
      if (base == (char *)0)
	{
	  if (access ("/usr/tmp", R_OK | W_OK) == 0)
	    base = "/usr/tmp/";
	  else
	    base = "/tmp/";
	}
    }

  len = strlen (base);
  temp_filename = (char *) xmalloc (len + sizeof("/ccXXXXXX"));
  strcpy (temp_filename, base);
  if (len > 0 && temp_filename[len-1] != '/')
    temp_filename[len++] = '/';
  strcpy (temp_filename + len, "ccXXXXXX");

#else /* OSK_TARGET */
  register char *foo = "cc.XXXXXX";
  register char *p = user_temp_directory;

#ifndef OSK
  if (p && *p && !access (p, R_OK | W_OK))
    temp_filename = concat (p, "/", foo);
  else if ((p = getenv ("TMPDIR")) && *p && !access (p, R_OK | W_OK))
    temp_filename = concat (p, "/", foo);
  else
    temp_filename = concat ("", "", foo);
#else
  if (p && *p && !access (p, IS_DIR))
    temp_filename = concat (p, "/", foo);
  else if ((p = getenv ("TMPDIR")) && *p && !access (p, IS_DIR))
    temp_filename = concat (p, "/", foo);
  else
    temp_filename = concat ("", "", foo);
#endif
#endif /* OSK_TARGET */
  mktemp (temp_filename);
  temp_filename_length = strlen (temp_filename);
}

/* Search for an execute file through our search path.
   Return 0 if not found, otherwise return its name, allocated with malloc.  */

/* Use search list constructed in main(). */

static char *
find_exec_file (prog)
     char *prog;
{
  extern int access ();
  char *temp;
  int size = 0;
  struct file_name_list *p;

  /* Allocate space for longest possible file name */

  for (p = exec_prefix_list; p; p = p->next)
    {
       if (strlen (p->fname) > size)
	 size = strlen (p->fname);
    }
  size += strlen (prog) + 1;
  if (machine_suffix)
    size += strlen (machine_suffix);
  temp = (char *) xmalloc (size);

  /* Determine the file name to execute.  */

  for (p = exec_prefix_list; p; p = p->next)
    {
      if (machine_suffix)
	{
	  strcpy (temp, p->fname);
	  strcat (temp, machine_suffix);
	  strcat (temp, prog);
#ifdef OSK_TARGET
	  if (debug_flag)
	    fprintf (stderr, "    examine   %s\n", temp);
#endif /* OSK_TARGET */
	  if (!access (temp, X_OK))
	    break;
	}

      strcpy (temp, p->fname);
      strcat (temp, prog);
#ifdef OSK_TARGET
      if (debug_flag)
	fprintf (stderr, "    examine   %s\n", temp);
#endif /* OSK_TARGET */
      if (!access (temp, X_OK))
	break;
    }

#ifndef OSK_TARGET
  if (p)
    return temp;
  else
    return 0;
#else /* OSK_TARGET */
  if (p)
    {
      if (debug_flag)
	fprintf (stderr, "    FOUND     %s\n", temp);
      return temp;
    }

  if (debug_flag)
    fprintf (stderr, "    NOT FOUND %s\n", prog);
  return 0;
#endif /* OSK_TARGET */
}

/* stdin file number.  */
#define STDIN_FILE_NO 0

/* stdout file number.  */
#define STDOUT_FILE_NO 1

#ifndef OSK
/* value of `pipe': port index for reading.  */
#define READ_PORT 0

/* value of `pipe': port index for writing.  */
#define WRITE_PORT 1

/* Pipe waiting from last process, to be used as input for the next one.
   Value is STDIN_FILE_NO if no pipe is waiting
   (i.e. the next command is the first of a group).  */

int last_pipe_input;
#else /* OSK */
/* Saved path number of this process's stdin and stdout.  (A.S.) */

int saved_stdin  = 0;
int saved_stdout = 0;
#endif /* OSK */

/* Fork one piped subcommand.  FUNC is the system call to use
   (either execv or execvp).  ARGV is the arg vector to use.
   NOT_LAST is nonzero if this is not the last subcommand
   (i.e. its output should be piped to the next one.)  */

#ifndef OSK
static int
pexecute (func, program, argv, not_last)
     char *program;
     int (*func)();
     char *argv[];
     int not_last;
{
  extern int close (), dup (), pipe (), vfork ();
  int pid;
  int pdes[2];
  int input_desc = last_pipe_input;
  int output_desc = STDOUT_FILE_NO;

  /* If this isn't the last process, make a pipe for its output,
     and record it as waiting to be the input to the next process.  */

  if (not_last)
    {
      if (pipe (pdes) < 0)
	pfatal_with_name ("pipe");
      output_desc = pdes[WRITE_PORT];
      last_pipe_input = pdes[READ_PORT];
    }
  else
    last_pipe_input = STDIN_FILE_NO;

  pid = vfork ();

  switch (pid)
    {
    case -1:
      pfatal_with_name ("vfork");
      /*NOTREACHED*/
      break;

    case 0: /* child */
      /* Move the input and output pipes into place, if nec.  */
      if (input_desc != STDIN_FILE_NO)
	{
	  close (STDIN_FILE_NO);
	  dup (input_desc);
	  close (input_desc);
	}
      if (output_desc != STDOUT_FILE_NO)
	{
	  close (STDOUT_FILE_NO);
	  dup (output_desc);
	  close (output_desc);
	}

      /* Close the parent's descs that aren't wanted here.  */
      if (last_pipe_input != STDIN_FILE_NO)
	close (last_pipe_input);

      /* Exec the program.  */
      (*func) (program, argv);
      perror_exec (program);
      exit (-1);
      /*NOTREACHED*/

    default:
      /* In the parent, after forking.
	 Close the descriptors that we made for this child.  */
      if (input_desc != STDIN_FILE_NO)
	close (input_desc);
      if (output_desc != STDOUT_FILE_NO)
	close (output_desc);

      /* Return child's process number.  */
      return pid;
    }
}
#else /* OSK */
/* FUNC is always os9exec, so this argument is removed.
   Almost all codes were rewritten.  (A.S.) */

static int
pexecute (program, argv, not_last)
     char *program;
     char *argv[];
     int not_last;
{
  int pid;
  int not_first = saved_stdin || saved_stdout;
  int stack_size, priority;
  extern int close ();
  extern int dup ();
  extern int create ();
  extern int os9exec ();
  extern int os9forkc ();
  extern char **environ;

  if (not_first || not_last)
    {
      if (not_first)
	{
	  close (STDIN_FILE_NO);
	  dup (STDOUT_FILE_NO);		/* redirect last STDOUT to STDIN */
	}
      else
	{
	  saved_stdin  = dup (STDIN_FILE_NO);
	  saved_stdout = dup (STDOUT_FILE_NO);
	}

      close (STDOUT_FILE_NO);

      if (not_last)			/* redirect STDOUT to pipe */
	{
	  int size;

	  for (size = 4096;
	       create ("/pipe", R_OK | W_OK | ISIZE, R_OK | W_OK, size) < 0;
	       size >>= 1)
	    if (size <= 128)
	      pfatal_with_name ("open pipe");
	}
      else
	{
	  dup (saved_stdout);		/* recover original STDOUT */
	  close (saved_stdout);
	  saved_stdout = 0;
	}
    }

  /* get stack_size and priority */

  get_command_exec_param (program, &stack_size, &priority);

  pid = os9exec (os9forkc, program, argv, environ, stack_size, priority, 3);

  if (pid < 0)
    pfatal_with_name ("os9exec");

  if (!not_last && not_first)
    {
      close (STDIN_FILE_NO);
      dup (saved_stdin);		/* recover original STDIN */
      close (saved_stdin);
      saved_stdin = 0;
    }

  return pid;
}
#endif /* OSK */

/* Execute the command specified by the arguments on the current line of spec.
   When using pipes, this includes several piped-together commands
   with `|' between them.

   Return 0 if successful, -1 if failed.  */

#ifdef OSK
/* Before calling find_exec_file, try to link the module.  If success,
   mark its address in struct command, and unlink after execution.  (A.S.) */

#endif /* OSK */
int
execute ()
{
  int i;
  int n_commands;		/* # of command.  */
  char *string;
  struct command
    {
      char *prog;		/* program name.  */
      char **argv;		/* vector of args.  */
      int pid;			/* pid of process for this command.  */
#ifdef OSK
      mod_exec *modp;		/* module address when prog in memory. (A.S.) */
#endif /* OSK */
    };

  struct command *commands;	/* each command buffer with above info.  */

#ifdef OSK
  extern mod_exec *modlink ();
  extern int munlink ();
#endif /* OSK */

  /* Count # of piped commands.  */
  for (n_commands = 1, i = 0; i < argbuf_index; i++)
    if (strcmp (argbuf[i], "|") == 0)
      n_commands++;

  /* Get storage for each command.  */
  commands
    = (struct command *) alloca (n_commands * sizeof (struct command));

  /* Split argbuf into its separate piped processes,
     and record info about each one.
     Also search for the programs that are to be run.  */

  commands[0].prog = argbuf[0]; /* first command.  */
  commands[0].argv = &argbuf[0];
#ifndef OSK
  string = find_exec_file (commands[0].prog);
  if (string)
    commands[0].argv[0] = string;
#else /* OSK */
  if ((int)(commands[0].modp = modlink (commands[0].prog, 0)) < 0)
    {
      commands[0].modp = NULL;
      string = find_exec_file (commands[0].prog);
      if (string)
	commands[0].argv[0] = string;
    }
#endif /* OSK */

  for (n_commands = 1, i = 0; i < argbuf_index; i++)
    if (strcmp (argbuf[i], "|") == 0)
      {				/* each command.  */
	argbuf[i] = 0;	/* termination of command args.  */
	commands[n_commands].prog = argbuf[i + 1];
	commands[n_commands].argv = &argbuf[i + 1];
#ifndef OSK
	string = find_exec_file (commands[n_commands].prog);
	if (string)
	  commands[n_commands].argv[0] = string;
#else /* OSK */
	if ((int)(commands[n_commands].modp = modlink (commands[n_commands].prog, 0)) < 0)
	  {
	    commands[n_commands].modp = NULL;
	    string = find_exec_file (commands[n_commands].prog);
	    if (string)
	      commands[n_commands].argv[0] = string;
	  }
#endif /* OSK */
	n_commands++;
      }

  argbuf[argbuf_index] = 0;

  /* If -v, print what we are about to do, and maybe query.  */

#ifndef OSK_TARGET
  if (vflag)
#else /* OSK_TARGET */
  if (vflag || debug_flag)
#endif /* OSK_TARGET */
    {
      /* Print each piped command as a separate line.  */
      for (i = 0; i < n_commands ; i++)
	{
	  char **j;
#ifdef OSK
	  int  p, s;
#endif /* OSK */

	  for (j = commands[i].argv; *j; j++)
	    fprintf (stderr, " %s", *j);

#ifdef OSK
	  get_command_exec_param (commands[i].prog, &s, &p);
	  if (s)
	    fprintf (stderr, " #%dK", s / 1024);
	  if (p)
	    fprintf (stderr, " ^%d", p);
#endif /* OSK */

	  /* Print a pipe symbol after all but the last command.  */
	  if (i + 1 != n_commands)
	    fprintf (stderr, " |");
	  fprintf (stderr, "\n");
	}
      fflush (stderr);
#ifndef OSK_TARGET
#ifdef DEBUG
      fprintf (stderr, "\nGo ahead? (y or n) ");
      fflush (stderr);
      i = getchar ();
      if (i != '\n')
	while (getchar () != '\n') ;
      if (i != 'y' && i != 'Y')
	return 0;
#endif /* DEBUG */
#else /* OSK_TARGET */
      if (debug_flag)
	{
#ifdef OSK
	  for (i = 0; i < n_commands; ++i)
	    if (commands[i].modp)
	      munlink (commands[i].modp);
#endif /* OSK */
	  return 0;
	}
#endif /* OSK_TARGET */
    }

  /* Run each piped subprocess.  */

#ifndef OSK
  last_pipe_input = STDIN_FILE_NO;
  for (i = 0; i < n_commands; i++)
    {
      extern int execv(), execvp();
      char *string = commands[i].argv[0];

      commands[i].pid = pexecute ((string != commands[i].prog ? execv : execvp),
				  string, commands[i].argv,
				  i + 1 < n_commands);
#else /* OSK */
  for (i = 0; i < n_commands; i++)
    {
      char *string = commands[i].argv[0];

      commands[i].pid = pexecute (string, commands[i].argv, i + 1 < n_commands);
#endif /* OSK */

      if (string != commands[i].prog)
	free (string);
    }

  execution_count++;

  /* Wait for all the subprocesses to finish.
     We don't care what order they finish in;
     we know that N_COMMANDS waits will get them all.  */

  {
    int ret_code = 0;

    for (i = 0; i < n_commands; i++)
      {
	int status;
	int pid;
	char *prog;
#ifndef OSK

	pid = wait (&status);
	if (pid < 0)
	  abort ();

	if (status != 0)
	  {
	    int j;
	    for (j = 0; j < n_commands; j++)
	      if (commands[j].pid == pid)
		prog = commands[j].prog;

	    if ((status & 0x7F) != 0)
	      fatal ("Program %s got fatal signal %d.", prog, (status & 0x7F));
	    if (((status & 0xFF00) >> 8) >= MIN_FATAL_STATUS)
	      ret_code = -1;
	  }
      }
#ifdef OSK_TARGET
    delete_temp_files (ret_code == 0);
#endif
#else /* OSK */
	int j;

	pid = wait (&status);

	for (j = 0; j < n_commands; j++)
	  if (commands[j].pid == pid)
	    {
	      if (commands[j].modp)
		munlink (commands[j].modp);
	      if (status != 0)
		{
		  prog = commands[j].prog;
		  if ((status & 0xFFFF) != 0)
		    error ("Program %s got fatal signal %d.", prog, (status & 0xFFFF));
		  ret_code = -1;
		}
	      break;
	    }
      }
    delete_temp_files (ret_code == 0);

    if (ret_code != 0 && ignore_error == 0)
      exit (1);

#endif /* OSK */
    return ret_code;
  }
}

/* Find all the switches given to us
   and make a vector describing them.
   The elements of the vector a strings, one per switch given.
   If a switch uses the following argument, then the `part1' field
   is the switch itself and the `part2' field is the following argument.
   The `valid' field is nonzero if any spec has looked at this switch;
   if it remains zero at the end of the run, it must be meaningless.  */

struct switchstr
{
  char *part1;
  char *part2;
  int valid;
};

struct switchstr *switches;

int n_switches;

/* Also a vector of input files specified.  */

char **infiles;

int n_infiles;

/* And a vector of corresponding output files is made up later.  */

char **outfiles;

#ifdef OSK_TARGET
/* A vector of input library files specified.  (A.S.) */

char **libfiles;

int n_libfiles;

#endif /* OSK_TARGET */
/* Create the vector `switches' and its contents.
   Store its length in `n_switches'.  */

void
process_command (argc, argv)
     int argc;
     char **argv;
{
  register int i;
  n_switches = 0;
  n_infiles = 0;
#ifdef OSK_TARGET
  n_libfiles = 0;
#endif /* OSK_TARGET */

  /* Scan argv twice.  Here, the first time, just count how many switches
     there will be in their vector, and how many input files in theirs.
     Here we also parse the switches that cc itself uses (e.g. -v).  */

  for (i = 1; i < argc; i++)
    {
#ifndef OSK_TARGET
      if (argv[i][0] == '-' && argv[i][1] != 'l')
	{
#else /* OSK_TARGET */
      if (argv[i][0] == '-' && argv[i][1] == 'l')
	{
	  n_libfiles++;
	  if (argv[i][2] == 0)
	    i++;
	}
      else if (argv[i][0] == '-' && argv[i][1])
	{
#endif /* OSK_TARGET */
	  register char *p = &argv[i][1];
	  register int c = *p;

	  switch (c)
	    {
#ifdef OSK_TARGET
	    case '?':
	      usage ();
	      exit (0);

#endif /* OSK_TARGET */
	    case 'b':
	      machine_suffix = p + 1;
	      break;

	    case 'B':
	      user_exec_prefix = p + 1;
	      break;

#ifdef OSK_TARGET
	    case 'L':
	      {
		struct file_name_list *dirtmp;

		dirtmp = (struct file_name_list *)
		  xmalloc (sizeof (struct file_name_list));
		dirtmp->next = 0; /* New one goes on the end */
		if (startfile_prefix_list == 0)
		  startfile_prefix_list = dirtmp;
		else
		  last_startfile_prefix->next = dirtmp;
		last_startfile_prefix = dirtmp; /* Tail follows the last one */
		dirtmp->fname = (char *) xmalloc (strlen (p+1) + 2);
		strcpy (dirtmp->fname, p+1);
		strcat (dirtmp->fname, "/");
	      }
	      break;

	    case 'T':
	      user_temp_directory = p + 1;
	      break;

#endif /* OSK_TARGET */
#ifdef OSK
	    case 'F':
	      set_command_exec_param (p + 1);
	      break;

#endif /* OSK */
	    case 'v':	/* Print our subcommands and print versions.  */
	      vflag++;
	      n_switches++;
	      break;

	    default:
#ifdef OSK_TARGET
              if (!strcmp(p, "debug"))
	        {
                  debug_flag = 1;
                  break;
                }

#endif /* OSK_TARGET */
	      n_switches++;

	      if (SWITCH_TAKES_ARG (c) && p[1] == 0)
		i++;
#ifndef OSK_TARGET
	      else if (WORD_SWITCH_TAKES_ARG (p))
		i++;
#endif /* OSK_TARGET */
	    }
	}
      else
	n_infiles++;
    }

  /* Then create the space for the vectors and scan again.  */

  switches = ((struct switchstr *)
	      xmalloc ((n_switches + 1) * sizeof (struct switchstr)));
  infiles = (char **) xmalloc ((n_infiles + 1) * sizeof (char *));
#ifdef OSK_TARGET
  libfiles = (char **) xmalloc ((n_libfiles + 1) * sizeof (char *));
#endif /* OSK_TARGET */
  n_switches = 0;
  n_infiles = 0;
#ifdef OSK_TARGET
  n_libfiles = 0;
#endif /* OSK_TARGET */

  /* This, time, copy the text of each switch and store a pointer
     to the copy in the vector of switches.
     Store all the infiles in their vector.  */
#ifdef OSK_TARGET
  /* And store all the libfiles in their vector.  (A.S.) */
#endif /* OSK_TARGET */

  for (i = 1; i < argc; i++)
    {
#ifndef OSK_TARGET
      if (argv[i][0] == '-' && argv[i][1] != 'l')
#else /* OSK_TARGET */
      if (argv[i][0] == '-' && argv[i][1] == 'l')
	libfiles[n_libfiles++] = (argv[i][2] ? &argv[i][2] : argv[++i]);
      else if (argv[i][0] == '-' && argv[i][1])
#endif /* OSK_TARGET */
	{
	  register char *p = &argv[i][1];
	  register int c = *p;

#ifndef OSK_TARGET
	  if (c == 'B' || c == 'b')
	    continue;
	  switches[n_switches].part1 = p;
	  if ((SWITCH_TAKES_ARG (c) && p[1] == 0)
	      || WORD_SWITCH_TAKES_ARG (p))
#else /* OSK_TARGET */
#ifndef OSK
	  if (c == 'B' || c == 'b' || c == 'L' || c == 'T')
#else
	  if (c == 'B' || c == 'b' || c == 'L' || c == 'T' || c == 'F')
#endif
	    continue;
	  if (! strcmp (p, "debug"))
	    continue;
	  switches[n_switches].part1 = p;
	  if (SWITCH_TAKES_ARG (c) && p[1] == 0)
#endif /* OSK_TARGET */
	    switches[n_switches].part2 = argv[++i];
	  else
	    switches[n_switches].part2 = 0;
	  switches[n_switches].valid = 0;
	  n_switches++;
	}
      else
	infiles[n_infiles++] = argv[i];
    }

  switches[n_switches].part1 = 0;
  infiles[n_infiles] = 0;
#ifdef OSK_TARGET
  libfiles[n_libfiles] = 0;
#endif /* OSK_TARGET */
}

#ifdef OSK
/* To get the same effect of the shell command line specification
     $ l68 ... #32K ^50
   give gcc the option -Fl68s32p50.  (A.S.) */

void
set_command_exec_param (arg)
     char *arg;
{
  extern int atoi ();
  register int i;

  for (i = 0; i < sizeof (exec_param_tab) / sizeof (exec_param_tab[0]); ++i)
    if (! strncmp (arg, exec_param_tab[i].name, exec_param_tab[i].length))
      {
	arg += exec_param_tab[i].length;
	while (*arg)
	  switch (*arg)
	    {
	    case 'p':
	      exec_param_tab[i].priority = atoi (++arg);
	      while (isdigit (*arg))
	        ++arg;
	      break;
	    case 's':
	      exec_param_tab[i].stack_size = atoi (++arg) * 1024;
	      while (isdigit (*arg))
	        ++arg;
	      break;
	    default:
	      return;
	    }
	return;
      }
}

void
get_command_exec_param (program, stack_size_p, priority_p)
     char *program;
     int  *stack_size_p, *priority_p;
{
  register int i;
  char *name = (char *) index (program, '\0');

  *stack_size_p = 0;
  *priority_p   = 0;

  for (i = 0; i < sizeof (exec_param_tab) / sizeof (exec_param_tab[0]); ++i)
    if (! strcmp (name - exec_param_tab[i].length, exec_param_tab[i].name))
      {
	*stack_size_p = exec_param_tab[i].stack_size;
	*priority_p   = exec_param_tab[i].priority;
	break;
      }

  return;
}
#endif /* OSK */

/* Process a spec string, accumulating and running commands.  */

/* These variables describe the input file name.
   input_file_number is the index on outfiles of this file,
   so that the output file name can be stored for later use by %o.
   input_basename is the start of the part of the input file
   sans all directory names, and basename_length is the number
   of characters starting there excluding the suffix .c or whatever.  */

char *input_filename;
int input_file_number;
int input_filename_length;
int basename_length;
char *input_basename;

/* These are variables used within do_spec and do_spec_1.  */

/* Nonzero if an arg has been started and not yet terminated
   (with space, tab or newline).  */
int arg_going;

/* Nonzero means %d or %g has been seen; the next arg to be terminated
   is a temporary file name.  */
#ifndef OSK_TARGET
int delete_this_arg;
#else /* OSK_TARGET */
/* Use enum delete_condition.  (A.S.) */
/* Add delete_this_arg_in_next_stage.  (A.S.) */
enum delete_condition delete_this_arg, delete_this_arg_in_next_stage;
#endif /* OSK_TARGET */

/* Nonzero means %w has been seen; the next arg to be terminated
   is the output file name of this compilation.  */
int this_is_output_file;

/* Nonzero means %s has been seen; the next arg to be terminated
   is the name of a library file and we should try the standard
   search dirs for it.  */
int this_is_library_file;

#ifdef OSK_TARGET
/* Nonzero means %/ has been seen; the next arg to be terminated
   is a file name relative to default working directory and we should
   convert the file name into absolute path list.  (A.S.) */
int make_absolute_path;
#endif /* OSK_TARGET */

/* Process the spec SPEC and run the commands specified therein.
   Returns 0 if the spec is successfully processed; -1 if failed.  */

int
do_spec (spec)
     char *spec;
{
  int value;

  clear_args ();
  arg_going = 0;
  delete_this_arg = 0;
#ifdef OSK_TARGET
  delete_this_arg_in_next_stage = 0;
#endif /* OSK_TARGET */
  this_is_output_file = 0;
  this_is_library_file = 0;
#ifdef OSK_TARGET
  combine_switch_with_arg = 0;
  make_absolute_path = 0;
#endif /* OSK_TARGET */

#ifndef OSK_TARGET
  value = do_spec_1 (spec, 0);
#else /* OSK_TARGET */
  value = do_spec_1 (spec, 0, 0);
#endif /* OSK_TARGET */

  /* Force out any unfinished command.
     If -pipe, this forces out the last command if it ended in `|'.  */
  if (value == 0)
    {
      if (argbuf_index > 0 && !strcmp (argbuf[argbuf_index - 1], "|"))
	argbuf_index--;

      if (argbuf_index > 0)
	value = execute ();
    }

  return value;
}

/* Process the sub-spec SPEC as a portion of a larger spec.
   This is like processing a whole spec except that we do
   not initialize at the beginning and we do not supply a
   newline by default at the end.
   INSWITCH nonzero means don't process %-sequences in SPEC;
   in this case, % is treated as an ordinary character.
   This is used while substituting switches.
   INSWITCH nonzero also causes SPC not to terminate an argument.

   Value is zero unless a line was finished
   and the command on that line reported an error.  */

int
#ifndef OSK_TARGET
do_spec_1 (spec, inswitch)
     char *spec;
     int inswitch;
#else /* OSK_TARGET */
do_spec_1 (spec, inswitch, switcharg)
     char *spec;
     int inswitch;
     char *switcharg;
#endif /* OSK_TARGET */
{
  register char *p = spec;
  register int c;
  char *string;

  while (c = *p++)
    /* If substituting a switch, treat all chars like letters.
       Otherwise, NL, SPC, TAB and % are special.  */
    switch (inswitch ? 'a' : c)
      {
      case '\n':
	/* End of line: finish any pending argument,
	   then run the pending command if one has been started.  */
	if (arg_going)
	  {
	    obstack_1grow (&obstack, 0);
	    string = obstack_finish (&obstack);
	    if (this_is_library_file)
	      string = find_file (string);
#ifndef OSK_TARGET
	    store_arg (string, delete_this_arg, this_is_output_file);
#else /* OSK_TARGET */
	    if (make_absolute_path)
	      string = absolute_path_of (string);
	    store_arg (string, delete_this_arg, delete_this_arg_in_next_stage, this_is_output_file);
#endif /* OSK_TARGET */
	    if (this_is_output_file)
	      outfiles[input_file_number] = string;
	  }
	arg_going = 0;

	if (argbuf_index > 0 && !strcmp (argbuf[argbuf_index - 1], "|"))
	  {
	    int i;
	    for (i = 0; i < n_switches; i++)
	      if (!strcmp (switches[i].part1, "pipe"))
		break;

	    /* A `|' before the newline means use a pipe here,
	       but only if -pipe was specified.
	       Otherwise, execute now and don't pass the `|' as an arg.  */
	    if (i < n_switches)
	      {
		switches[i].valid = 1;
		break;
	      }
	    else
	      argbuf_index--;
	  }

	if (argbuf_index > 0)
	  {
	    int value = execute ();
	    if (value)
	      return value;
	  }
	/* Reinitialize for a new command, and for a new argument.  */
	clear_args ();
	arg_going = 0;
	delete_this_arg = 0;
#ifdef OSK_TARGET
	delete_this_arg_in_next_stage = 0;
#endif /* OSK_TARGET */
	this_is_output_file = 0;
	this_is_library_file = 0;
#ifdef OSK_TARGET
        combine_switch_with_arg = 0;
	make_absolute_path = 0;
#endif /* OSK_TARGET */
	break;

      case '|':
	/* End any pending argument.  */
	if (arg_going)
	  {
	    obstack_1grow (&obstack, 0);
	    string = obstack_finish (&obstack);
	    if (this_is_library_file)
	      string = find_file (string);
#ifndef OSK_TARGET
	    store_arg (string, delete_this_arg, this_is_output_file);
#else /* OSK_TARGET */
	    if (make_absolute_path)
	      string = absolute_path_of (string);
	    store_arg (string, delete_this_arg, delete_this_arg_in_next_stage, this_is_output_file);
#endif /* OSK_TARGET */
	    if (this_is_output_file)
	      outfiles[input_file_number] = string;
	  }

	/* Use pipe */
	obstack_1grow (&obstack, c);
	arg_going = 1;
	break;

      case '\t':
      case ' ':
	/* Space or tab ends an argument if one is pending.  */
	if (arg_going)
	  {
	    obstack_1grow (&obstack, 0);
	    string = obstack_finish (&obstack);
	    if (this_is_library_file)
	      string = find_file (string);
#ifndef OSK_TARGET
	    store_arg (string, delete_this_arg, this_is_output_file);
#else /* OSK_TARGET */
	    if (make_absolute_path)
	      string = absolute_path_of (string);
	    store_arg (string, delete_this_arg, delete_this_arg_in_next_stage, this_is_output_file);
#endif /* OSK_TARGET */
	    if (this_is_output_file)
	      outfiles[input_file_number] = string;
	  }
	/* Reinitialize for a new argument.  */
	arg_going = 0;
	delete_this_arg = 0;
#ifdef OSK_TARGET
	delete_this_arg_in_next_stage = 0;
#endif /* OSK_TARGET */
	this_is_output_file = 0;
	this_is_library_file = 0;
#ifdef OSK_TARGET
        combine_switch_with_arg = 0;
	make_absolute_path = 0;
#endif /* OSK_TARGET */
	break;

      case '%':
	switch (c = *p++)
	  {
	  case 0:
	    fatal ("Invalid specification!  Bug in cc.");

	  case 'b':
	    obstack_grow (&obstack, input_basename, basename_length);
	    arg_going = 1;
	    break;

	  case 'd':
#ifndef OSK_TARGET
	    delete_this_arg = 2;
#else /* OSK_TARGET */
	    delete_this_arg_in_next_stage = delete_on_success_in_next_stage;
#endif /* OSK_TARGET */
	    break;

#ifdef OSK_TARGET
	  case 'D':
	    delete_this_arg = delete_on_failure;
	    break;

#endif /* OSK_TARGET */
	  case 'e':
	    /* {...:%efoo} means report an error with `foo' as error message
	       and don't execute any more commands for this file.  */
	    {
	      char *q = p;
	      char *buf;
	      while (*p != 0 && *p != '\n') p++;
	      buf = (char *) alloca (p - q + 1);
	      strncpy (buf, q, p - q);
	      buf[p-q] = 0;
	      error ("%s", buf);
	      return -1;
	    }
	    break;

	  case 'g':
	    obstack_grow (&obstack, temp_filename, temp_filename_length);
#ifndef OSK_TARGET
	    delete_this_arg = 1;
#else /* OSK_TARGET */
	    delete_this_arg = delete_on_failure;
	    delete_this_arg_in_next_stage = delete_always_in_next_stage;
#endif /* OSK_TARGET */
	    arg_going = 1;
	    break;

#ifdef OSK_TARGET
	  case 't':
	    obstack_grow (&obstack, temp_filename, temp_filename_length);
	    arg_going = 1;
	    break;

#endif /* OSK_TARGET */
	  case 'i':
	    obstack_grow (&obstack, input_filename, input_filename_length);
	    arg_going = 1;
	    break;

	  case 'o':
	    {
	      register int f;
	      for (f = 0; f < n_infiles; f++)
#ifndef OSK_TARGET
		store_arg (outfiles[f], 0, 0);
#else /* OSK_TARGET */
		store_arg (outfiles[f], nomore_delete, nomore_delete, 0);
#endif /* OSK_TARGET */
	    }
	    break;

#ifdef OSK_TARGET
	  case 'O':
	    {
	      register int f;
	      for (f = 0; f < n_libfiles; f++)
		store_arg (concat ("-l=", find_file (libfiles[f]), ""), nomore_delete, nomore_delete, 0);
	    }
	    break;

#endif /* OSK_TARGET */
	  case 's':
	    this_is_library_file = 1;
	    break;

	  case 'w':
	    this_is_output_file = 1;
#ifdef OSK_TARGET
	    delete_this_arg = delete_on_failure;
#endif /* OSK_TARGET */
	    break;

	  case '{':
	    p = handle_braces (p);
	    if (p == 0)
	      return -1;
	    break;

#ifdef OSK_TARGET
	  case '=':
	    combine_switch_with_arg = 1;
	    break;

#endif /* OSK_TARGET */
	  case '%':
	    obstack_1grow (&obstack, '%');
	    break;

#ifdef OSK_TARGET
	  case 'r':
	    if (switcharg)
	      do_spec_1 (switcharg, 1, 0);
	    break;

	  case '/':
	    make_absolute_path = 1;
	    break;

#endif /* OSK_TARGET */
/*** The rest just process a certain constant string as a spec.  */

	  case '1':
#ifndef OSK_TARGET
	    do_spec_1 (CC1_SPEC, 0);
#else /* OSK_TARGET */
	    do_spec_1 (CC1_SPEC, 0, 0);
#endif /* OSK_TARGET */
	    break;

	  case 'a':
#ifndef OSK_TARGET
	    do_spec_1 (ASM_SPEC, 0);
#else /* OSK_TARGET */
	    do_spec_1 (ASM_SPEC, 0, 0);
#endif /* OSK_TARGET */
	    break;

	  case 'c':
#ifndef OSK_TARGET
	    do_spec_1 (SIGNED_CHAR_SPEC, 0);
#else /* OSK_TARGET */
	    do_spec_1 (SIGNED_CHAR_SPEC, 0, 0);
#endif /* OSK_TARGET */
	    break;

	  case 'C':
#ifndef OSK_TARGET
	    do_spec_1 (CPP_SPEC, 0);
#else /* OSK_TARGET */
	    do_spec_1 (CPP_SPEC, 0, 0);
#endif /* OSK_TARGET */
	    break;

	  case 'l':
#ifndef OSK_TARGET
	    do_spec_1 (LINK_SPEC, 0);
#else /* OSK_TARGET */
	    do_spec_1 (LINK_SPEC, 0, 0);
#endif /* OSK_TARGET */
	    break;

	  case 'L':
#ifndef OSK_TARGET
	    do_spec_1 (LIB_SPEC, 0);
#else /* OSK_TARGET */
	    do_spec_1 (LIB_SPEC, 0, 0);
#endif /* OSK_TARGET */
	    break;

	  case 'p':
#ifndef OSK_TARGET
	    do_spec_1 (CPP_PREDEFINES, 0);
#else /* OSK_TARGET */
	    do_spec_1 (CPP_PREDEFINES, 0, 0);
#endif /* OSK_TARGET */
	    break;

	  case 'P':
	    {
	      char *x = (char *) alloca (strlen (CPP_PREDEFINES) * 2 + 1);
	      char *buf = x;
	      char *y = CPP_PREDEFINES;

	      /* Copy all of CPP_PREDEFINES into BUF,
		 but put __ after every -D and at the end of each arg,  */
	      while (1)
		{
		  if (! strncmp (y, "-D", 2))
		    {
		      *x++ = '-';
		      *x++ = 'D';
		      *x++ = '_';
		      *x++ = '_';
		      y += 2;
		    }
		  else if (*y == ' ' || *y == 0)
		    {
		      *x++ = '_';
		      *x++ = '_';
		      if (*y == 0)
			break;
		      else
			*x++ = *y++;
		    }
		  else
		    *x++ = *y++;
		}
	      *x = 0;

#ifndef OSK_TARGET
	      do_spec_1 (buf, 0);
#else /* OSK_TARGET */
	      do_spec_1 (buf, 0, 0);
#endif /* OSK_TARGET */
	    }
	    break;

	  case 'S':
#ifndef OSK_TARGET
	    do_spec_1 (STARTFILE_SPEC, 0);
#else /* OSK_TARGET */
	    do_spec_1 (STARTFILE_SPEC, 0, 0);
#endif /* OSK_TARGET */
	    break;

	  default:
	    abort ();
	  }
	break;

      default:
	/* Ordinary character: put it into the current argument.  */
	obstack_1grow (&obstack, c);
	arg_going = 1;
      }

  return 0;		/* End of string */
}

/* Return 0 if we call do_spec_1 and that returns -1.  */

char *
handle_braces (p)
     register char *p;
{
  register char *q;
  char *filter;
  int pipe = 0;
  int negate = 0;

  if (*p == '|')
    /* A `|' after the open-brace means,
       if the test fails, output a single minus sign rather than nothing.
       This is used in %{|!pipe:...}.  */
    pipe = 1, ++p;

  if (*p == '!')
    /* A `!' after the open-brace negates the condition:
       succeed if the specified switch is not present.  */
    negate = 1, ++p;

  filter = p;
  while (*p != ':' && *p != '}') p++;
  if (*p != '}')
    {
      register int count = 1;
      q = p + 1;
      while (count > 0)
	{
	  if (*q == '{')
	    count++;
	  else if (*q == '}')
	    count--;
	  else if (*q == 0)
	    abort ();
	  q++;
	}
    }
  else
    q = p + 1;

  if (p[-1] == '*' && p[0] == '}')
    {
      /* Substitute all matching switches as separate args.  */
      register int i;
      --p;
      for (i = 0; i < n_switches; i++)
	if (!strncmp (switches[i].part1, filter, p - filter))
	  give_switch (i);
    }
  else
    {
      /* Test for presence of the specified switch.  */
      register int i;
      int present = 0;

      /* If name specified ends in *, as in {x*:...},
	 check for presence of any switch name starting with x.  */
      if (p[-1] == '*')
	{
	  for (i = 0; i < n_switches; i++)
	    {
	      if (!strncmp (switches[i].part1, filter, p - filter - 1))
		{
		  switches[i].valid = 1;
		  present = 1;
		}
	    }
	}
      /* Otherwise, check for presence of exact name specified.  */
      else
	{
	  for (i = 0; i < n_switches; i++)
	    {
	      if (!strncmp (switches[i].part1, filter, p - filter)
		  && switches[i].part1[p - filter] == 0)
		{
		  switches[i].valid = 1;
		  present = 1;
		  break;
		}
	    }
	}

      /* If it is as desired (present for %{s...}, absent for %{-s...})
	 then substitute either the switch or the specified
	 conditional text.  */
      if (present != negate)
	{
	  if (*p == '}')
	    {
	      give_switch (i);
	    }
	  else
	    {
#ifndef OSK_TARGET
	      if (do_spec_1 (save_string (p + 1, q - p - 2), 0) < 0)
#else /* OSK_TARGET */
	      if (do_spec_1 (save_string (p + 1, q - p - 2), 0, switches[i].part2) < 0)
#endif /* OSK_TARGET */
		return 0;
	    }
	}
      else if (pipe)
	{
	  /* Here if a %{|...} conditional fails: output a minus sign,
	     which means "standard output" or "standard input".  */
#ifndef OSK_TARGET
	  do_spec_1 ("-", 0);
#else /* OSK_TARGET */
	  do_spec_1 ("-", 0, 0);
#endif /* OSK_TARGET */
	}
    }

  return q;
}

/* Pass a switch to the current accumulating command
   in the same form that we received it.
   SWITCHNUM identifies the switch; it is an index into
   the vector of switches gcc received, which is `switches'.
   This cannot fail since it never finishes a command line.  */

void
give_switch (switchnum)
     int switchnum;
{
#ifndef OSK_TARGET
  do_spec_1 ("-", 0);
  do_spec_1 (switches[switchnum].part1, 1);
  do_spec_1 (" ", 0);
#else /* OSK_TARGET */
  do_spec_1 ("-", 0, 0);
  do_spec_1 (switches[switchnum].part1, 1, switches[switchnum].part2);
  do_spec_1 (" ", 0, 0);
#endif /* OSK_TARGET */
  if (switches[switchnum].part2 != 0)
    {
#ifndef OSK_TARGET
      do_spec_1 (switches[switchnum].part2, 1);
      do_spec_1 (" ", 0);
#else /* OSK_TARGET */
      do_spec_1 (switches[switchnum].part2, 1, 0);
      do_spec_1 (" ", 0, 0);
#endif /* OSK_TARGET */
    }
  switches[switchnum].valid = 1;
}

/* Search for a file named NAME trying various prefixes including the
   user's -B prefix and some standard ones.
   Return the absolute pathname found.  If nothing is found, return NAME.  */

#ifdef OSK_TARGET
/* Use -L dir, dir via environment variable, and prefix
   standard_startfile_prefix*. But never -B prefix (A.S.) */

#endif /* OSK_TARGET */

/* Use search lists constructed in process_command() and main(). */

char *
find_file (name)
     char *name;
{
  extern int access ();
  int size = 0;
  char *temp;
  struct file_name_list *p;

#ifdef OSK_TARGET
  /* If name is an absolute path, do nothing and return name itself (A.S.) */

  if (*name == '/')
    return name;
#endif /* OSK_TARGET */

  /* Compute maximum size of NAME plus any prefix we will try.  */

#ifndef OSK_TARGET
  for (p = exec_prefix_list; p; p = p->next)
    {
       if (strlen (p->fname) > size)
	 size = strlen (p->fname);
    }
#endif /* not OSK_TARGET */

  for (p = startfile_prefix_list; p; p = p->next)
    {
       if (strlen (p->fname) > size)
	 size = strlen (p->fname);
    }
  size += strlen (name) + 1;
  if (machine_suffix)
    size += strlen (machine_suffix);

  temp = (char *) alloca (size);

  /* Determine library file name */

#ifndef OSK_TARGET
  for (p = exec_prefix_list; p; p = p->next)
    {
      if (machine_suffix)
	{
	  strcpy (temp, p->fname);
	  strcat (temp, machine_suffix);
	  strcat (temp, name);
	  if (!access (temp, R_OK))
	    break;
	}

      strcpy (temp, p->fname);
      strcat (temp, name);
      if (!access (temp, R_OK))
	break;
    }

  if (p)
    return save_string (temp, strlen (temp));
#endif /* not OSK_TARGET */

  for (p = startfile_prefix_list; p; p = p->next)
    {
      if (machine_suffix)
	{
	  strcpy (temp, p->fname);
	  strcat (temp, machine_suffix);
	  strcat (temp, name);
#ifdef OSK_TARGET
	  if (debug_flag)
	    fprintf (stderr, "    examine   %s\n", temp);
#endif /* OSK_TARGET */
	  if (!access (temp, R_OK))
	    break;
	}

      strcpy (temp, p->fname);
      strcat (temp, name);
#ifdef OSK_TARGET
      if (debug_flag)
	fprintf (stderr, "    examine   %s\n", temp);
#endif /* OSK_TARGET */
      if (!access (temp, R_OK))
	break;
    }

#ifndef OSK_TARGET
  if (p)
    return save_string (temp, strlen (temp));
  return name;
}
#else /* OSK_TARGET */
  if (p)
    {
      if (debug_flag)
	fprintf (stderr, "    FOUND     %s\n", temp);
      return save_string (temp, strlen (temp));
    }

  if (debug_flag)
    fprintf (stderr, "    NOT FOUND %s\n", name);

  return name;
}

/* Convert file name into absolute path.  (A.S.) */
char *
absolute_path_of (name)
     char *name;
{
  /* Absolute path of current working directory. (A.S.) */
  static char *path_of_cwd = NULL;
#ifndef OSK
  extern char *getwd ();
#else
  extern int getcd ();
#endif

  if (*name == '/')
    return name;

  if (path_of_cwd == NULL)
    {
      path_of_cwd = (char *) xmalloc (1024);

#ifndef OSK
      if (getwd (path_of_cwd) == NULL)
	fatal ("can't getwd.");
#else
      if (getcd (path_of_cwd, 1024, "d") < 0)
	fatal ("can't getcd.");
#endif
    }

  return concat (path_of_cwd, "/", name);
}
#endif /* OSK_TARGET */

/* On fatal signals, delete all the temporary files.  */

void
fatal_error (signum)
     int signum;
{
  extern int kill ();
  extern int getpid ();
#ifndef OSK

  signal (signum, SIG_DFL);
#else /* OSK */
  extern int tsleep ();
  extern int intercept ();

  /* Although it seems more safe, don't exchange following 2 lines.
     intercept(0) (F$Icpt with a0 = 0) does not work if P$SigLvl != 0 (A.S.) */

  tsleep (1);		/* Unmasking signal (P$SigLvl = 0) (A.S.) */
  intercept (0);	/* As signal(*, SIG_DFL) (A.S.) */

#endif /* OSK */
#ifndef OSK_TARGET
  delete_failure_queue ();
  delete_temp_files ();
#else /* OSK_TARGET */
  delete_temp_files (0);
#endif /* OSK_TARGET */
  /* Get the same signal again, this time not handled,
     so its normal effect occurs.  */
  kill (getpid (), signum);
  /*NOTREACHED*/
}

int
main (argc, argv)
     int argc;
     char **argv;
{
  extern char *getenv ();
#ifdef OSK
  extern int intercept ();
#endif /* OSK */
  register int i;
  int value;
  int error_count = 0;
  int linker_was_run = 0;
  char *explicit_link_files;

  programname = argv[0];

#ifndef OSK
  if (signal (SIGINT, SIG_IGN) != SIG_IGN)
    signal (SIGINT, fatal_error);
  if (signal (SIGHUP, SIG_IGN) != SIG_IGN)
    signal (SIGHUP, fatal_error);
  if (signal (SIGTERM, SIG_IGN) != SIG_IGN)
    signal (SIGTERM, fatal_error);
#else /* OSK */
  intercept (fatal_error);	/* any signal is fatal (A.S.) */
#endif /* OSK */

  argbuf_length = 10;
  argbuf = (char **) xmalloc (argbuf_length * sizeof (char *));

  obstack_init (&obstack);

  /* Make a table of what switches there are (switches, n_switches).
     Make a table of specified input files (infiles, n_infiles).  */

  /* To get -Ttempdir,
     first call process_command and next call choose_temp_base. (A.S.) */

  process_command (argc, argv);

  choose_temp_base ();

  /* Add user exec file prefix to the list of exec file prefixes */

  if (user_exec_prefix)
    {
      register struct file_name_list *dirtmp;

      dirtmp = (struct file_name_list *) xmalloc (sizeof (*dirtmp));
      dirtmp->next = 0; /* New one goes on the end */
      if (exec_prefix_list == 0)
	exec_prefix_list = dirtmp;
      else
	last_exec_prefix->next = dirtmp;
      last_exec_prefix = dirtmp; /* Tail follows the last one */
      dirtmp->fname = user_exec_prefix;
    }

  /* Add exec file prefixes from environment variable "GCC_EXEC_PREFIX".
     Multiple prefixes are separated by colons. */

  {
    register char *bp,*ep, c;
    register struct file_name_list *dirtmp;

    if ((bp = getenv ("GCC_EXEC_PREFIX")) && *bp)
      {
	do {
	  ep = bp;
	  while ((c = *ep++) && c != ':')
	    ;
	  dirtmp = (struct file_name_list *) xmalloc (sizeof (*dirtmp));
	  dirtmp->next = 0; /* New one goes on the end */
	  if (exec_prefix_list == 0)
	    exec_prefix_list = dirtmp;
	  else
	    last_exec_prefix->next = dirtmp;
	  last_exec_prefix = dirtmp; /* Tail follows the last one */
	  dirtmp->fname = (char *) xmalloc (ep-bp);
	  strncpy (dirtmp->fname, bp, ep-bp-1);
	  dirtmp->fname[ep-bp-1] = 0;
	  bp = ep;
	} while (c);
      }
  }

  /* Add defaults to list of exec file prefixes */

  if (exec_prefix_list == 0)
    exec_prefix_list = exec_defaults;
  else
    last_exec_prefix->next = exec_defaults;

#ifdef OSK_TARGET
  /* Add start file directories from environment variable "GCCLIB" to the
     list of start file prefixes.  Multiple directories are separated by
     colons. */

  {
    register char *bp,*ep, c;
    register struct file_name_list *dirtmp;

    if ((bp = getenv ("GCCLIB")) && *bp)
      {
	do {
	  ep = bp;
	  while ((c = *ep++) && c != ':')
	    ;
	  dirtmp = (struct file_name_list *) xmalloc (sizeof (*dirtmp));
	  dirtmp->next = 0; /* New one goes on the end */
	  if (startfile_prefix_list == 0)
	    startfile_prefix_list = dirtmp;
	  else
	    last_startfile_prefix->next = dirtmp;
	  last_startfile_prefix = dirtmp; /* Tail follows the last one */
	  dirtmp->fname = (char *) xmalloc (ep-bp+1);
	  strncpy (dirtmp->fname, bp, ep-bp-1);
	  dirtmp->fname[ep-bp-1] = '/';
	  dirtmp->fname[ep-bp] = 0;
	  bp = ep;
	} while (c);
      }
  }
#endif /* OSK_TARGET */

  /* Add defaults to list of start file prefixes */

  if (startfile_prefix_list == 0)
    startfile_prefix_list = startfile_defaults;
  else
    last_startfile_prefix->next = startfile_defaults;

  if (vflag)
    {
      extern char *version_string;
      fprintf (stderr, "gcc version %s\n", version_string);
      if (n_infiles == 0)
	exit (0);
    }

  if (n_infiles == 0)
    fatal ("No input files specified.");

  /* Make a place to record the compiler output file names
     that correspond to the input files.  */

  outfiles = (char **) xmalloc (n_infiles * sizeof (char *));
  bzero (outfiles, n_infiles * sizeof (char *));

  /* Record which files were specified explicitly as link input.  */

  explicit_link_files = (char *) xmalloc (n_infiles);
  bzero (explicit_link_files, n_infiles);

  for (i = 0; i < n_infiles; i++)
    {
      register struct compiler *cp;
      int this_file_error = 0;

      /* Tell do_spec what to substitute for %i.  */

      input_filename = infiles[i];
      input_filename_length = strlen (input_filename);
      input_file_number = i;

      /* Use the same thing in %o, unless cp->spec says otherwise.  */

      outfiles[i] = input_filename;

      /* Figure out which compiler from the file's suffix.  */

      for (cp = compilers; cp->spec; cp++)
	{
	  if (strlen (cp->suffix) < input_filename_length
	      && !strcmp (cp->suffix,
			  infiles[i] + input_filename_length
			  - strlen (cp->suffix)))
	    {
	      /* Ok, we found an applicable compiler.  Run its spec.  */
	      /* First say how much of input_filename to substitute for %b  */
	      register char *p;

	      input_basename = input_filename;
	      for (p = input_filename; *p; p++)
		if (*p == '/')
		  input_basename = p + 1;
	      basename_length = (input_filename_length - strlen (cp->suffix)
				 - (input_basename - input_filename));
	      value = do_spec (cp->spec);
	      if (value < 0)
		this_file_error = 1;
	      break;
	    }
	}

      /* If this file's name does not contain a recognized suffix,
	 record it as explicit linker input.  */

      if (! cp->spec)
	explicit_link_files[i] = 1;

      /* Clear the delete-on-failure queue, deleting the files in it
	 if this compilation failed.  */

      if (this_file_error)
#ifndef OSK_TARGET
	{
	  delete_failure_queue ();
	  error_count++;
	}
#else /* OSK_TARGET */
	error_count++;

#endif /* OSK_TARGET */
      /* If this compilation succeeded, don't delete those files later.  */
      clear_failure_queue ();
    }

#ifdef OSK_TARGET
  input_filename = input_basename = "";		/* (A.S.) */
  input_filename_length = basename_length = 0;	/* (A.S.) */

#endif /* OSK_TARGET */
  /* Run ld to link all the compiler output files.  */

  if (error_count == 0)
    {
      int tmp = execution_count;
#ifdef OSK_TARGET
      init_link_stage_queue ();			/* (A.S.) */
#endif /* OSK_TARGET */
      value = do_spec (link_spec);
      if (value < 0)
	error_count = 1;
      linker_was_run = (tmp != execution_count);
    }

  /* If options said don't run linker,
     complain about input files to be given to the linker.  */

  if (! linker_was_run && error_count == 0)
    for (i = 0; i < n_infiles; i++)
      if (explicit_link_files[i])
	error ("%s: linker input file unused since linking not done",
	       outfiles[i]);

  /* Set the `valid' bits for switches that match anything in any spec.  */

  validate_all_switches ();

  /* Warn about any switches that no pass was interested in.  */
  
  for (i = 0; i < n_switches; i++)
    if (! switches[i].valid)
      error ("unrecognized option `-%s'", switches[i].part1);

#ifndef OSK_TARGET
  /* Delete some or all of the temporary files we made.  */

  if (error_count)
    delete_failure_queue ();
  delete_temp_files ();
#endif /* OSK_TARGET */

  exit (error_count);
  /*NOTREACHED*/
}

char *
xmalloc (size)
     int size;
{
  extern char *malloc ();
  register char *value = malloc (size);
  if (value == 0)
#ifndef OSK
    fatal ("Virtual memory full.");
#else /* OSK */
    fatal ("Memory full.");
#endif /* OSK */
  return value;
}

char *
xrealloc (ptr, size)
     int ptr, size;
{
  extern char *realloc ();
  register char *value = realloc (ptr, size);
  if (value == 0)
#ifndef OSK
    fatal ("Virtual memory full.");
#else /* OSK */
    fatal ("Memory full.");
#endif /* OSK */
  return value;
}

/* Return a newly-allocated string whose contents concatenate those of s1, s2, s3.  */

char *
concat (s1, s2, s3)
     char *s1, *s2, *s3;
{
  int len1 = strlen (s1), len2 = strlen (s2), len3 = strlen (s3);
  char *result = (char *) xmalloc (len1 + len2 + len3 + 1);

  strcpy (result, s1);
  strcpy (result + len1, s2);
  strcpy (result + len1 + len2, s3);
  *(result + len1 + len2 + len3) = 0;

  return result;
}

char *
save_string (s, len)
     char *s;
     int len;
{
  register char *result = (char *) xmalloc (len + 1);

  bcopy (s, result, len);
  result[len] = 0;
  return result;
}

void
pfatal_with_name (name)
     char *name;
{
  extern int errno, sys_nerr;
  extern char *sys_errlist[];
  char *s;

  if (errno < sys_nerr)
    s = concat ("%s: ", sys_errlist[errno], "");
  else
    s = "cannot open %s";
  fatal (s, name);
  /*NOTREACHED*/
}

void
perror_with_name (name)
     char *name;
{
  extern int errno, sys_nerr;
  extern char *sys_errlist[];
  char *s;

  if (errno < sys_nerr)
    s = concat ("%s: ", sys_errlist[errno], "");
  else
    s = "cannot open %s";
  error (s, name);
}

void
perror_exec (name)
     char *name;
{
  extern int errno, sys_nerr;
  extern char *sys_errlist[];
  char *s;

  if (errno < sys_nerr)
    s = concat ("installation problem, cannot exec %s: ",
		sys_errlist[errno], "");
  else
    s = "installation problem, cannot exec %s";
  error (s, name);
}

/* More 'friendly' abort that prints the line and file.
   config.h can #define abort fancy_abort if you like that sort of thing.  */

void
fancy_abort ()
{
  fatal ("Internal gcc abort.");
}

#ifdef HAVE_VPRINTF

/* Output an error message and exit */

void
fatal (va_alist)
     va_dcl
{
  va_list ap;
  char *format;
  
  va_start(ap);
  format = va_arg (ap, char *);
  vfprintf (stderr, format, ap);
  va_end (ap);
  fprintf (stderr, "\n");
  delete_temp_files (0);
  exit (1);
  /*NOTREACHED*/
}  

void
error (va_alist) 
     va_dcl
{
  va_list ap;
  char *format;

  va_start(ap);
  format = va_arg (ap, char *);
  fprintf (stderr, "%s: ", programname);
  vfprintf (stderr, format, ap);
  va_end (ap);

  fprintf (stderr, "\n");
}

#else /* not HAVE_VPRINTF */

void
fatal (msg, arg1, arg2)
     char *msg, *arg1, *arg2;
{
  error (msg, arg1, arg2);
  delete_temp_files (0);
  exit (1);
  /*NOTREACHED*/
}

void
error (msg, arg1, arg2)
     char *msg, *arg1, *arg2;
{
  fprintf (stderr, "%s: ", programname);
  fprintf (stderr, msg, arg1, arg2);
#ifdef OSK
  if (input_filename)
    fprintf (stderr, " (%s)", input_filename);
#endif /* OSK */
  fprintf (stderr, "\n");
}

#endif /* not HAVE_VPRINTF */


void
validate_all_switches ()
{
  struct compiler *comp;
  register char *p;
  register char c;

  for (comp = compilers; comp->spec; comp++)
    {
      p = comp->spec;
      while (c = *p++)
	if (c == '%' && *p == '{')
	  /* We have a switch spec.  */
	  validate_switches (p + 1);
    }

  p = link_spec;
  while (c = *p++)
    if (c == '%' && *p == '{')
      /* We have a switch spec.  */
      validate_switches (p + 1);

  /* Now notice switches mentioned in the machine-specific specs.  */

#ifdef ASM_SPEC
  p = ASM_SPEC;
  while (c = *p++)
    if (c == '%' && *p == '{')
      /* We have a switch spec.  */
      validate_switches (p + 1);
#endif

#ifdef CPP_SPEC
  p = CPP_SPEC;
  while (c = *p++)
    if (c == '%' && *p == '{')
      /* We have a switch spec.  */
      validate_switches (p + 1);
#endif

#ifdef SIGNED_CHAR_SPEC
  p = SIGNED_CHAR_SPEC;
  while (c = *p++)
    if (c == '%' && *p == '{')
      /* We have a switch spec.  */
      validate_switches (p + 1);
#endif

#ifdef CC1_SPEC
  p = CC1_SPEC;
  while (c = *p++)
    if (c == '%' && *p == '{')
      /* We have a switch spec.  */
      validate_switches (p + 1);
#endif

#ifdef LINK_SPEC
  p = LINK_SPEC;
  while (c = *p++)
    if (c == '%' && *p == '{')
      /* We have a switch spec.  */
      validate_switches (p + 1);
#endif

#ifdef LIB_SPEC
  p = LIB_SPEC;
  while (c = *p++)
    if (c == '%' && *p == '{')
      /* We have a switch spec.  */
      validate_switches (p + 1);
#endif

#ifdef STARTFILE_SPEC
  p = STARTFILE_SPEC;
  while (c = *p++)
    if (c == '%' && *p == '{')
      /* We have a switch spec.  */
      validate_switches (p + 1);
#endif
}

/* Look at the switch-name that comes after START
   and mark as valid all supplied switches that match it.  */

void
validate_switches (start)
     char *start;
{
  register char *p = start;
  char *filter;
  register int i;

  if (*p == '|')
    ++p;

  if (*p == '!')
    ++p;

  filter = p;
  while (*p != ':' && *p != '}') p++;

  if (p[-1] == '*')
    {
      /* Mark all matching switches as valid.  */
      --p;
      for (i = 0; i < n_switches; i++)
	if (!strncmp (switches[i].part1, filter, p - filter))
	  switches[i].valid = 1;
    }
  else
    {
      /* Mark an exact matching switch as valid.  */
      for (i = 0; i < n_switches; i++)
	{
	  if (!strncmp (switches[i].part1, filter, p - filter)
	      && switches[i].part1[p - filter] == 0)
	    switches[i].valid = 1;
	}
    }
}
#ifdef OSK_TARGET

void
usage ()
{
  extern char *version_string;

#ifndef OSK
  fprintf (stderr, "GNU C Compiler for OS-9/68000 (Version %s)\n",
    version_string);
  fprintf (stderr, "\
Usage: gccos9 {options} {files} {options}\n");
#else /* OSK */
  fprintf (stderr, "GNU C Compiler (Version %s)\n", version_string);
  fprintf (stderr, "\
Usage: gcc {options} {files} {options}\n");
#endif /* OSK */
  fprintf (stderr, "\
Options:  (Do not concatenate single letter options)\n\
\n\
Control compile stages\n\
  -c           not run linker\n\
  -o68         use o68 before assemble\n\
  -S           only compile source files\n\
  -E           only preprocess source files\n\
  -M           only print dependencies\n\
  -MM          only print dependencies sans system header files\n\
  -pipe        connect preprocessor and compiler via pipe\n\
  -debug       not execute but only print command to execute\n");
  fprintf (stderr, "\
  -v           print version and commands to execute\n\
  -Q           not quiet mode\n\
  -BPREFIX     use PREFIX for commands\n\
  -bPREFIX     use machine dependent PREFIX for commands\n\
  -LDIR        search DIR for library files\n\
  -TDIR        specify DIR of temp files\n");
#ifdef OSK
  fprintf (stderr, "\
  -FPROGsSIZEpPRIO\n\
               fork PROGram (one of cccp cc1 o68 r68(020) l68) with\n\
               additional stack SIZE and PRIOrity\n");
#endif /* OSK */
  fprintf (stderr, "\
\n\
Output\n\
  -o FILE      output to FILE\n");
#ifdef OSK
  fprintf (stderr, "\
  -x           put executable file into default execution directory\n");
#endif /* OSK */
  fprintf (stderr, "\
\n\
Warning\n\
  -W           issue warnings\n\
  -WCASE       CASE is one of\n\
                 implicit return-type unused switch comment trigraphs all\n\
                 shadow id-clash-LEN pointer-arith cast-qual write-strings\n\
  -w           inhibit all warnings\n\
\n\
Portability\n\
  -ansi         support ANSI standard\n\
  -traditional  try to imitate traditional C compiler\n\
  -pedantic     support pedantic ANSI standard\n\
\n");
  fprintf (stderr, "\
Preprocessor\n\
  -DMACRO[=DEF] define MACRO (by DEF)\n\
  -UMACRO       undefine MACRO\n\
  -IDIR         search include file in DIR\n\
  -I-           dir specified by the -Idir before -I- applies to only user\n\
                include files\n\
  -iFILE        get only #define's in FILE\n\
  -nostdinc     do not use standard directory of include files\n\
  -C            include comments in preprocessor output\n\
  -trigraphs    support ANSI trigraphs\n\
\n");
  fprintf (stderr, "\
Compiler\n\
  -O            optimize\n\
  -p            generate profile code too\n\
  -a            generate block profile code too\n\
  -mMACHINESPEC MACHINESPEC is one of\n\
                (c)68000 (c)68020 68881 soft-float short (no)bitfield\n\
                rtd (no)remote (no)stack-check (no)gss\n\
  -fFLAG        FLAG is one of\n\
                  caller-saves combine-regs cond-mismatch float-store\n\
                  force-addr force-mem inline-functions keep-inline-functions\n\
                  omit-frame-pointer pcc-struct-return strength-reduce\n\
                  unsigned-char volatile writable-strings asm defer-pop\n\
                  function-cse signed-char delayed-branch\n\
                and the above with prefix no- and\n\
                  fixed-REG call-used-REG call-saved-REG\n\
  -dLETTERS     dump debug info in various stages.  LETTER is one of\n\
                  y r j s L f c l g J d m\n\
\n");
  fprintf (stderr, "\
Linker\n\
  -lFILE        use library FILE\n\
  -nostdlib     do not use any standard library files and startup file\n\
  -p (or -a)    link profile dump library\n\
  -g            output symbol table too\n\
  -cio          use cio trap handler\n\
  -j            inhibit to make jump table\n\
  -ghost        output ghost module\n\
  -s SIZE       specify addtional stack SIZE of output module\n\
  -e NUMBER     specify edition NUMBER of output module\n\
  -n NAME       specify output module NAME\n\
  -P HEX        specify permission of output module in HEX\n");
}
#endif /* OSK_TARGET */
