/* Subroutines needed by GCC output code on some machines.  */
/* Compile this file with the OSK C compiler!  */


#ifdef L_eprintf
#include <stdio.h>
/* This is used by the `assert' macro.  */
void
__eprintf (string, expression, line, filename)
     char *string;
     char *expression;
     int line;
     char *filename;
{
  fprintf (stderr, string, expression, line, filename);
}
#endif

#ifdef L_umulsi3
#asm
__umulsi3:
	bra _T$UMul
#endasm
#endif

#ifdef L_mulsi3
#asm
__mulsi3:
	bra _T$LMul
#endasm
#endif

#ifdef L_udivsi3
#asm
__udivsi3:
	bra _T$UDiv
#endasm
#endif

#ifdef L_divsi3
#asm
__divsi3:
	bra _T$LDiv
#endasm
#endif

#ifdef L_umodsi3
#asm
__umodsi3:
	bra _T$UMod
#endasm
#endif

#ifdef L_modsi3
#asm
__modsi3:
	bra _T$LMod
#endasm
#endif

#ifdef L_lshrsi3
__lshrsi3 (a, b)
     unsigned a, b;
{
  return a >> b;
}
#endif

#ifdef L_lshlsi3
__lshlsi3 (a, b)
     unsigned a, b;
{
  return a << b;
}
#endif

#ifdef L_ashrsi3
__ashrsi3 (a, b)
     int a, b;
{
  return a >> b;
}
#endif

#ifdef L_ashlsi3
__ashlsi3 (a, b)
     int a, b;
{
  return a << b;
}
#endif

#ifdef L_divdf3
#asm
__divdf3:
	link a5,#-8
	movem.l d2-d3,(a7)
	movem.l 8(a5),d2-d3
	bsr _T$DDiv
	movem.l (a7),d2-d3
	unlk a5
	rts
#endasm
#endif

#ifdef L_muldf3
#asm
__muldf3:
	link a5,#-8
	movem.l d2-d3,(a7)
	movem.l 8(a5),d2-d3
	bsr _T$DMul
	movem.l (a7),d2-d3
	unlk a5
	rts
#endasm
#endif

#ifdef L_negdf2
#asm
__negdf2:
	bra _T$DNeg
#endasm
#endif

#ifdef L_adddf3
#asm
__adddf3:
	link a5,#-8
	movem.l d2-d3,(a7)
	movem.l 8(a5),d2-d3
	bsr _T$DAdd
	movem.l (a7),d2-d3
	unlk a5
	rts
#endasm
#endif

#ifdef L_subdf3
#asm
__subdf3:
	link a5,#-8
	movem.l d2-d3,(a7)
	movem.l 8(a5),d2-d3
	bsr _T$DSub
	movem.l (a7),d2-d3
	unlk a5
	rts
#endasm
#endif

#ifdef L_cmpdf2
#asm
__cmpdf2:
	link a5,#-8
	movem.l d2-d3,(a7)
	movem.l 8(a5),d2-d3
	bsr _T$DCmp
	beq.b _cmpdf22
	blt.b _cmpdf21
	moveq.l #1,d0
	bra.b _cmpdf23
_cmpdf21
	moveq.l #-1,d0
	bra.b _cmpdf23
_cmpdf22
	moveq.l #0,d0
_cmpdf23
	movem.l (a7),d2-d3
	unlk a5
	rts
#endasm
#endif

#ifdef L_fixunsdfsi
#asm
__fixunsdfsi:
	bra _T$DtoU
#endasm
#endif

#ifdef L_fixdfsi
#asm
__fixdfsi:
	bra _T$DtoL
#endasm
#endif

#ifdef L_floatsidf
#asm
__floatsidf:
	bra _T$LtoD
#endasm
#endif


#ifdef L_addsf3
#asm
__addsf3:
	bra _T$FAdd
#endasm
#endif

#ifdef L_negsf2
#asm
__negsf2:
	bra _T$FNeg
#endasm
#endif

#ifdef L_subsf3
#asm
__subsf3:
	bra _T$FSub
#endasm
#endif

#ifdef L_cmpsf2
#asm
__cmpsf2:
	link a5,#0
	bsr _T$FCmp
	beq.b _cmpsf22
	blt.b _cmpsf21
	moveq.l #1,d0
	bra.b _cmpsf23
_cmpsf21
	moveq.l #-1,d0
	bra.b _cmpsf23
_cmpsf22
	moveq.l #0,d0
_cmpsf23
	unlk a5
	rts
#endasm
#endif

#ifdef L_mulsf3
#asm
__mulsf3:
	bra _T$FMul
#endasm
#endif

#ifdef L_divsf3
#asm
__divsf3:
	bra _T$FDiv
#endasm
#endif

#ifdef L_truncdfsf2
#asm
__truncdfsf2:
	bra _T$DtoF
#endasm
#endif

#ifdef L_extendsfdf2
#asm
__extendsfdf2:
	bra _T$FtoD
#endasm
#endif

/* frills for C++ */

#ifdef L_builtin_new
typedef void (*vfp)();

extern vfp __new_handler;

char *
__builtin_new (sz)
     long sz;
{
  char *p;

  p = (char *)malloc (sz);
  if (p == 0)
    (*__new_handler) ();
  return p;
}
#endif

#ifdef L_builtin_gNew
typedef void (*vfp)();

static void
default_new_handler ();

vfp __new_handler = default_new_handler;

char *
__builtin_vec_new (p, maxindex, size, ctor)
     char *p;
     int maxindex, size;
     void (*ctor)();
{
  int i, nelts = maxindex + 1;
  char *rval;

  if (p == 0)
    p = (char *)__builtin_new (nelts * size);

  rval = p;

  for (i = 0; i < nelts; i++)
    {
      ctor (p);
      p += size;
    }

  return rval;
}

vfp
__set_new_handler (handler)
     vfp handler;
{
  vfp prev_handler;

  prev_handler = __new_handler;
  if (handler == 0) handler = default_new_handler;
  __new_handler = handler;
  return prev_handler;
}

vfp
set_new_handler (handler)
     vfp handler;
{
  return __set_new_handler (handler);
}

static void
default_new_handler ()
{
  /* don't use fprintf (stderr, ...) because it may need to call malloc.  */
  write (2, "default_new_handler: out of memory... aaaiiiiiieeeeeeeeeeeeee!\n", 65);
  /* don't call exit () because that may call global destructors which
     may cause a loop.  */
  _exit (-1);
}
#endif

#ifdef L_builtin_del
typedef void (*vfp)();

void
__builtin_delete (ptr)
     char *ptr;
{
  if (ptr)
    free (ptr);
}

void
__builtin_vec_delete (ptr, maxindex, size, dtor, auto_delete_vec, auto_delete)
     char *ptr;
     int maxindex, size;
     void (*dtor)();
     int auto_delete;
{
  int i, nelts = maxindex + 1;
  char *p = ptr;

  ptr += nelts * size;

  for (i = 0; i < nelts; i++)
    {
      ptr -= size;
      dtor (ptr, auto_delete);
    }

  if (auto_delete_vec)
    free (p);
}
#endif

#ifdef OSK
#ifdef L_stack_check
#asm
__stack_check:
	neg.l d0
	bsr _stkcheck
	rts
#endasm
#endif
#endif
