/*
CMPR - Compare OS-9/68000 Relocatable Modules

Julian Blake, CERN, 1211 Geneva 23, Switzerland.
October 1990.

Compares two files, ignoring the time stamp in bytes 12 to 17.
Returns exit status 0 if the files are identical, 1 otherwise.
*/

#include <stdio.h>

int
main(argc, argv)
int argc;
char *argv[];
{
	register FILE *fd1, *fd2;
	register int ch1, ch2, count = -1;

	if (argc != 3) {
		fprintf(stderr, "Usage: cmpr file1 file2\n");
		exit(1);
	}
	if (!strcmp(argv[1], argv[2])) {
		fprintf(stderr, "cmpr: File names are identical\n");
		exit(1);
	}
	if (!strcmp(argv[1], "-")) fd1 = stdin;
	else {
		fd1 = fopen(argv[1], "r");
		if (fd1 == NULL) {
			fprintf(stderr, "cmpr: Cannot open %s\n", argv[1]);
			exit(1);
		}
	}
	if (!strcmp(argv[2], "-")) fd2 = stdin;
	else {
		fd2 = fopen(argv[2], "r");
		if (fd2 == NULL) {
			fprintf(stderr, "cmpr: Cannot open %s\n", argv[2]);
			exit(1);
		}
	}
	do {
		count++;
		ch1 = getc(fd1);
		ch2 = getc(fd2);
	} while (((ch1 == ch2) || ((count >= 12) && (count <= 17)))
		&& (ch1 != EOF));
	if (fd1 != stdin) fclose(fd1);
	if (fd2 != stdin) fclose(fd2);
	if (ch1 != ch2) {
		fprintf(stderr,
			"cmpr: Files \"%s\", \"%s\" differ at byte %d\n",
			argv[1], argv[2], count);
		exit(1);
	}
	exit(0);
}
