/*
 *  gcpp.c :  Convert cpp options to cccp options and fork cccp.
 *
 *  If this source is compiled to an executable file with module name
 *  `cpp', you can use gnu cccp from MicroWare's CC.  (A.S.)
 *
 *  Option conversion table
 *
 *  cpp               cccp
 *
 *  -a                -P -C
 *  -Dsymbol[=value]  no change
 *  -E=num -e=num     -enum
 *  -g                no change
 *  -l                no change
 *  -o=path           outpath
 *  -usymbol          -Usymbol
 *  -v=directory      -Idirectory
 *
 */

#include <stdio.h>

extern int  os9forkc ();
extern char **environ;

char **cccp_argv;
char *infile  = NULL;
char *outfile = NULL;

void *xmalloc ();

main (argc, argv)
     int  argc;
     char **argv;
{
  register int i, j;
  int proc_id;
  unsigned int status;

  cccp_argv = (char **) xmalloc ((argc + 2) * (sizeof (char *)));

  j = 0;
  cccp_argv[j++] = "cccp";
  cccp_argv[j++] = "-K";

  for (i = 1; i < argc; ++i)
    if (argv[i][0] == '-')
      switch (argv[i][1])  /* option switch */
	{
	case 'a':
	  cccp_argv[j++] = "-P";
	  cccp_argv[j++] = "-C";
	  break;
	case 'D':
	  cccp_argv[j++] = argv[i];
	  break;
	case 'E':
	case 'e':
	  cccp_argv[j] = (char *) xmalloc (strlen (argv[i]) + 1);
	  strcpy (cccp_argv[j], "-e");
	  strcpy (cccp_argv[j++] + 2, argv[i] + 3);
	  break;
	case 'g':
	  cccp_argv[j++] = "-g";
	  break;
	case 'l':
	  cccp_argv[j++] = "-l";
	  break;
	case 'o':
	  outfile = argv[i] + 3;
	  break;
	case 'u':
	  cccp_argv[j] = (char *) xmalloc (strlen (argv[i]) + 1);
	  strcpy (cccp_argv[j], argv[i]);
	  cccp_argv[j++][1] = 'U';
	  break;
	  case 'v':
	cccp_argv[j] = (char *) xmalloc (strlen (argv[i]) + 1);
	  strcpy (cccp_argv[j], "-I");
	  strcpy (cccp_argv[j++] + 2, argv[i] + 3);
	  break;
	default:
	  break;
	}
    else    /* input file */
      infile = argv[i];

    if (infile == NULL && outfile != NULL)
      infile = "-";

    cccp_argv[j++] = infile;

    if (outfile)
      cccp_argv[j++] = outfile;

    cccp_argv[j++] = NULL;

    proc_id = os9exec (os9forkc, cccp_argv[0], cccp_argv, environ, 0, 0, 3);

    if (proc_id < 0)
      exit (1);
    while (proc_id != wait (&status))
      ;
    if (status != 0)
      exit (1);
    else
      exit (0);
}

void *xmalloc (s)
     int s;
{
  void *p = (void *) malloc (s);

  if (p == NULL)
    {
      fprintf (stderr, "Memory exhausted\n");
      exit (1);
    }

  return p;
}
