/*  getcd  by K.Ishikawa (original taken from `Interface' 1989/08 */

#include <stdio.h>
#include <direct.h>
#include <modes.h>

#define MAXPATHLEN 1024
#define MAXDEPTH 128

getcd (obuffer, olength, mode)
     char *obuffer;
     int  olength;
     char *mode;
{
  int	fd;
  long	cur, parent, here;
  int	found = 0;
  int	cp;
  struct dirent ent;
  char	buffer[sizeof (ent)];
  char	pathlist[MAXPATHLEN];
  char	dir[MAXDEPTH];
  int	open_mode = (*mode == 'x' ? S_IEXEC : 0) | S_IFDIR | S_IREAD;

  cp = sizeof (pathlist) - 1;
  *(pathlist + cp) = '\0';

  strcpy (dir, ".");
  fd = open (dir, open_mode);
  if (fd < 0)
    return -1;

  read (fd, &ent, sizeof (ent));	/* read ".." */
  read (fd, &ent, sizeof (ent));	/* read "." */
  here = ent.dir_addr;

  do {
    close (fd);
    fd = open (strcat (dir, "."), open_mode);
    if (fd < 0)
      return -1;
    read (fd, &ent, sizeof (ent)); /* read ".." */
    parent = ent.dir_addr;
    read (fd, &ent, sizeof (ent)); /* read "." */
    cur = ent.dir_addr;
    if (cur == parent)
      found++;
    while (read (fd, &ent, sizeof (ent)) == sizeof (ent))
      {
	if (ent.dir_name[0] && ent.dir_addr == here)
	  {
	    strhcpy (buffer, ent.dir_name);
	    cp -= strlen (buffer);
	    memcpy (pathlist + cp, buffer, strlen (buffer));
	    *(pathlist + --cp) = '/';
	    here = cur;
	    break;
	  }
      }
  } while (!found);

  _gs_devn (fd, buffer);	/* get device name */
  close (fd);
  cp -= strlen (buffer);
  memcpy (pathlist + cp, buffer, strlen (buffer));
  *(pathlist + --cp) = '/';

  if (strlen (pathlist + cp) >= olength)
    return -1;

  strcpy (obuffer, pathlist + cp);
  return 1;
}
