/*  move_if_change new_file old_file
 *
 *  If new_file and old_file have the same contents, remove new_file,
 *  othewise remove old_file and rename new_file to old_file.  (A.S.)
 *
 */

#include <stdio.h>

extern int errno;

main (argc, argv)
     int  argc;
     char *argv[];
{
  int  ch_new, ch_old;
  FILE *new, *old;

  if (argc != 3)
    usage ();

  if ((new = fopen(argv[1], "r")) == NULL)
    {
      fprintf(stderr, "%s : can't open %s (errno %d)\n", argv[0], argv[1], errno);
      exit(1);
    }

  if ((old = fopen(argv[2], "r")) == NULL)
    {
      if (errno == 216)
	{
	  fclose (new);
	  rename (argv[1], argv[2]);
	  exit (0);
	}
      else
	{
	  fprintf (stderr, "%s : can't open %s (errno %d)\n", argv[0], argv[2], errno);
	  exit (1);
	}
    }

  if (_gs_size (fileno (new)) != _gs_size (fileno (old)))
    {
      fclose (new);
      fclose (old);
      unlink (argv[2]);
      rename (argv[1], argv[2]);
      exit (0);
    }

  while (1)
    {
      ch_new = getc (new);
      ch_old = getc (old);
      if (ch_new != ch_old)
        {
	  fclose (new);
	  fclose (old);
	  unlink (argv[2]);
	  rename (argv[1], argv[2]);
	  exit (0);
	}
      else if (ch_new == -1)
        {
	  fclose (new);
	  fclose (old);
	  unlink (argv[1]);
	  exit (0);
	}
    }
}

rename (new, old)
     char *new, *old;
{
  char *cmd;

  cmd = (char *) malloc (strlen (new) + strlen (old) + 32);
  if (cmd == NULL)
    {
      fprintf (stderr, "Memory exhausted\n");
      exit (1);
    }
  sprintf (cmd, "rename %s %s", new, old);
  system (cmd);
}

usage ()
{
    fprintf (stderr, "Usage : move_if_change new_file old_file\n");
    exit (1);
}
