#include <stdio.h>

extern int errno;

static char undoc[] = "undocumented error";

char *sys_errlist[] = {
	undoc,
	undoc,
	"keyboard quit",
	"keyboard interrupt",
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	"illegal function code (math)",
	"ascii->numeric format conversion error (math)",
	"not a number (math)",
	"illegal argument (usually math)",
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	"bus trap",
	"address trap",
	"illegal instruction",
	"divide by zero",
	"\"chk\" instruction trap",
	"\"trapv\" instruction trap",
	"privileged instruction",
	"trace exception",
	"illegal instruction (1010)",
	"illegal instruction (1111)",
	"exception 12",
	"coprocessor protocol violation",
	"system stack frame format error",
	"exception 15",
	"exception 16",
	"exception 17",
	"exception 18",
	"exception 19",
	"exception 20",
	"exception 21",
	"exception 22",
	"exception 23",
	"an unitialized user TRAP (1-15) was executed",
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	"fpcp unordered condition",
	"fpcp inexact result",
	"fpcp divide by zero",
	"fpcp underflow",
	"fpcp operand error",
	"fpcp overflow",
	"fpcp not a number",
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	"no permission",
	"arguments to F$ChkNam didn't match",
	"system stack overflow",
	"invalid event ID number",
	"event not found",
	"the event is busy",
	"impossible event parameters",
	"system data structures have been damaged",
	"module revision is incompatable with operating system",
	"path became lost because network node was down",
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	undoc,
	"the path table is full",
	"bad path number",
	"system IRQ table is full",
	"bad I/O mode",
	"system device table is full",
	"bad module header",
	"system module directory is full",
	"memory full",
	"unknown service code",
	"non-sharable module is busy",
	"bad page address",
	"end of file",
	"IRQ vector is busy",
	"non-existing segment",
	"file not accessible",
	"bad pathlist",
	"file not found",
	"file segment list is full",
	"creating an existing file",
	"illegal memory block address",
	"modem data carrier lost",
	"module not found",
	"system clock not running",
	"deleting stack memory",
	"illegal process ID",
	"bad IRQ parameter",
	"no children",
	"invalid trap number",
	"process has aborted",
	"system process table is full",
	"illegal fork parameter",
	"known module",
	"bad module CRC",
	"unprocessed signal pending",
	"non executable module",
	"bad name",
	"bad module header parity",
	"no RAM available",
	"directory is not empty",
	"no available task number",
	"illegal unit (drive) number",
	"bad sector number",
	"media is write protected",
	"I/O error - bad check sum",
	"read error",
	"write error",
	"device not ready",
	"seek error",
	"media full",
	"incompatable media",
	"device busy",
	"disk media has changed",
	"record is busy",
	"non-sharable file/device is busy",
	"I/O deadlock error",
	"device is format protected"
};

int sys_nerr = sizeof (sys_errlist) / sizeof (sys_errlist[0]);

char *strerror (n)
     int n;
{
  char *mes = (0 < n && n < sys_nerr ? sys_errlist[n] : undoc);

  if (mes != undoc)
    return mes;
  else
    {
      static char message [32];
      sprintf (message, "Error #%03d:%03d", n >> 8, n & 0xff);
      return message;
    }
}

void perror (s)
     char *s;
{
  if (s)
    fprintf (stderr, "%s:", s);

  fprintf (stderr, " %s\n", strerror (errno));
}
