/*
 *  really_new arg1 arg2 ... argn
 *
 *  If file arg1 is older than one of file arg2 ... argn then exit (0),
 *  otherwise exit (1).  (A.S.)
 *
 */

#include <direct.h>

char *get_mtime ();

main (argc, argv)
     int argc;
     char *argv[];
{
  register int i;
  static char base_time[5];

  memcpy (base_time, get_mtime (argv[1]), 5);

  for (i = 2; i < argc; ++i)
    if (timecmp (get_mtime (argv[i]), base_time) >= 0)
      exit (0);

  exit (1);
}

char *
get_mtime (name)
     char *name;
{
  int path;
  static struct fildes buf;
  static char zerotime[5];

  if ((path = open (name, 0)) < 0)
    return &zerotime[0];

  if ((_gs_gfd (path, &buf, sizeof (struct fildes))) < 0)
    {
      close (path);
      return &zerotime[0];
    }

  close (path);
  return &(buf.fd_date[0]);
}

timecmp (p, q)
     char *p, *q;
{
  if (*p > *q)
    return 1;
  else if (*p < *q)
    return -1;

  ++p; ++q;
  if (*p > *q)
    return 1;
  else if (*p < *q)
    return -1;

  ++p; ++q;
  if (*p > *q)
    return 1;
  else if (*p < *q)
    return -1;

  ++p; ++q;
  if (*p > *q)
    return 1;
  else if (*p < *q)
    return -1;

  ++p; ++q;
  if (*p > *q)
    return 1;
  else if (*p < *q)
    return -1;
  else
    return 0;
}
