#include <direct.h>
#include <sgstat.h>
#include <types.h>
#include <time.h>
#include <stat.h>

stat (path, buf)
     char *path;
     struct stat *buf;
{
  int fd, res;

  if ((fd = open (path, 0)) < 0
      && (fd = open (path, S_IFDIR)) < 0)
    return -1;
  res = fstat (fd, buf);
  close (fd);
  return res;
}

fstat (fd, buf)
     int fd;
     struct stat *buf;
{
  struct sgbuf tmp_sg;
  struct fildes tmp_fd;
  struct tm tmp_tm;

  if (_gs_opt (fd, &tmp_sg) < 0)
    return -1;

  buf->st_mode  = tmp_sg.sg_class * 256;
  if (tmp_sg.sg_class != 1)	/* if not RBF */
    {
      buf->st_dev = tmp_sg.sg_tbl;
      return 0;
    }

  buf->st_dev   = tmp_sg.sg_dvt;
  if (_gs_gfd (fd, &tmp_fd, sizeof(struct fildes)) < 0)
    return -1;

  buf->st_ino   = tmp_sg.sg_fdpsn;
  buf->st_nlink = tmp_fd.fd_link;
  buf->st_mode += tmp_fd.fd_att;

  buf->st_gid = tmp_fd.fd_own[0];
  buf->st_uid = tmp_fd.fd_own[1];
  memcpy (&(buf->st_size), &(tmp_fd.fd_fsize[0]), 4);

  tmp_tm.tm_sec   = 0;
  tmp_tm.tm_min   = tmp_fd.fd_date[4];
  tmp_tm.tm_hour  = tmp_fd.fd_date[3];
  tmp_tm.tm_mday  = tmp_fd.fd_date[2];
  tmp_tm.tm_mon   = tmp_fd.fd_date[1] - 1;
  tmp_tm.tm_year  = tmp_fd.fd_date[0];
  tmp_tm.tm_isdst = -1;
  if ((buf->st_atime = buf->st_mtime = mktime (&tmp_tm)) < 0)
    return -1;

  tmp_tm.tm_min   = 0;
  tmp_tm.tm_hour  = 0;
  tmp_tm.tm_mday  = tmp_fd.fd_dcr[2];
  tmp_tm.tm_mon   = tmp_fd.fd_dcr[1] - 1;
  tmp_tm.tm_year  = tmp_fd.fd_dcr[0];
  tmp_tm.tm_isdst = -1;
  if ((buf->st_ctime = mktime (&tmp_tm)) < 0)
    return -1;

  return 0;
}
