/* varargs.h for GCC and MicroWare C.  (A.S.)  */

#ifndef __VARARGS_H
#define __VARARGS_H

#define va_alist	__reg_parm, __stack_parm
#define va_dcl		double __reg_parm; int __stack_parm;

typedef char * va_list;

#define va_start(AP)	((AP) = (va_list) & __reg_parm)

#define __va_rounded_size(TYPE)  \
  (((sizeof (TYPE) + sizeof (int) - 1) / sizeof (int)) * sizeof (int))

#define va_arg(AP, TYPE)						\
  ((AP) += __va_rounded_size (TYPE),					\
   (AP) < (va_list) & __stack_parm + __va_rounded_size (TYPE)		\
     && (AP) > (va_list) & __reg_parm + sizeof (__reg_parm)		\
     && ((AP) = (va_list) & __stack_parm + __va_rounded_size (TYPE)),	\
   * (TYPE *) ((AP) - __va_rounded_size (TYPE)))

#define va_end(AP)

#endif /* not defined(__VARARGS_H) */
