
/*********************************************************************
*
* Name        : generate.c
*
* Version     : 1.0
*
* Description : Program generates unique pairs of numbers required to make 
*               the tiles in a puzzle. 
*
* Written by  : Aju John & Dhruve Shah.
*
* e-mail      : mach@cs.wpi.edu
*
* Address     : Mach Research Group
*               Worcester Polytechnic Institute
*               Computer Science Department
*               100 Institute Road,
*               Worcester MA 01609.
*               U.S.A
*               (508) 831-5357
*
* Rev History : 
*   $Log$
************************************************************************/


/* include files */
#include <stdio.h>
#include <math.h>
#include "glob.h"       /* file containing global declarations */
#include "defines.h"    /* file containing global definitions  */

char rcsid[] = "$Id$";


main(argc, argv)
int argc;
char *argv[];

{
  int size_of_jigsaw;
  char input_file[20];
  if (argc > 1)
    {
      strcpy(input_file,argv[1]);
      if (strncmp(input_file,"random.out",10) == 0 )
	  {
	    printf("File: random.out comes with the standard distribution.\nPlease use an alternate filename.\n");
	    exit(-1);
	  }
	  else
	  {
	    printf("Data file is %s. Use this as the argument for jigsaw\n\n",
		   input_file);
	  }
  }
  else
    {
      printf("Usage: %s <datafile>\n", argv[0]);
      exit(0);
    }


  size_of_jigsaw = read_in_size();

  printf ("\nGenerating pairs of numbers for a %dx%d jigsaw puzzle\n", 
	  size_of_jigsaw, size_of_jigsaw);
  generate_pairs(size_of_jigsaw, input_file);


}


/**  Gets the size of the jigsaw puzzle from the user interactively.  **/

/*****************************************************************************
 read_in_size:  Reads the size of the puzzle matrix.

 Input(s): void
 Returns : the required size of the puzzle.
 Output  : none
 routines called: none    
                    
 ****************************************************************************/

read_in_size()
{
  int size_of_jigsaw;
  printf ("Note: Sizes greater than 48x48 will take a long time.\n\n");
  printf ("Enter the size of the puzzle (eg, 16 for 16x16):");
  scanf ("%d", &size_of_jigsaw);
  return(size_of_jigsaw);

 }

/*****************************************************************************
 generate_pairs():  Generates n1 and n2 pairs (the numbers for joining the 
                    left and right hand tile edges )
 Input(s): Size of jigsaw-puzzle matrix.
 Returns : void
 Output  : A textfile "random.out" with the generated pairs of n1 & n2.
 routines called:   randomize() 
                    check()
 ****************************************************************************/

generate_pairs(  size_of_jigsaw, data_file)
int size_of_jigsaw;
char *data_file;
{

  SET_PTR   pair;
  int total_pairs;
  int i, a, b;
  FILE *file;

  total_pairs = 2 * pow((float)size_of_jigsaw,2.);

  if (!(pair = (SET *) calloc (total_pairs, sizeof(SET))))
    {
      printf ("Error in calloc at X01 \n");
      exit(-1);
    }
  
  file = fopen(data_file,"w");
  if (file == NULL)
    {
      printf("Error: X02 - Cannot open file:random.out.\n");
      exit(-1);
    }
  for(i = 0; i < total_pairs; i++)
    {
      do
	{
	  a = randomize(1);
	  b = randomize(KEY);
	  pair[i].n1 = a*b + KEY;
	  pair[i].n2 = b;
	} while( check(pair, i) == TRUE );
      fprintf(file,"%d %d\n",pair[i].n1,pair[i].n2);
      printf ("Completed %d of %d pairs.\r",i+1,total_pairs);
    }
  printf ("\n");
  fclose(file);
}


/*****************************************************************************
 randomize(x): Generates random numbers "a" and "b" for each matching edge,
               which are used to form n1 and n2. It uses a multiplicative 
               congruential random number generator [ rand(_) ] with
               period 2E32 to return successive pseudo-random numbers in 
               the range from  0 to 2(E31)-1. The low bits of the numbers 
               generated are not  very  random; so the middle  bits are used
               using randomize().
 Input(s): x - either 1 or KEY
 Returns : s - which corresponds to "a" or "b" in the calling function.
 Output  : none
 routines called:  none.
                   
 ****************************************************************************/

randomize(x)
int x;
{
  register double max, max16, s1;
  register int s;
  
  max = pow(2., 31.);
  max16 = pow(2., 15.);
  s1 = max16/max ;
  
  do 
    s = floor(s1*rand());
  while(s <= x);

  return(s);
}


/*****************************************************************************
 check (): Checks for the uniqueness of the n1, n2 pair generated. 
                
 Input(s): address to the structure of n1 & n2 pairs and the index. 
 Returns : TRUE if n1%n2 or n2%n1 equals the key, else false.
 Output  : None.
 routines called: None.  
                   
 ****************************************************************************/

check(pair, i)
     SET *pair;
     int i;
{
  register int j,k;
 
  for(j=0; j<i; j++)
    if ( pair[j].n1 % pair[i].n2 == KEY ) 
      return(TRUE);

  for(j=0; j<i; j++)
    if ( pair[i].n1 % pair[j].n2 == KEY) 
      return(TRUE);

 return(FALSE);
}










