

/*********************************************************************
*
* Name        : timing.h
*
* Version     : 1.1
*
* Description : Common Standard Portable Timing Routine.
*
* Written  by : Brad B. Nichols
*
* e-mail      : mach@cs.wpi.edu
*
* Address     : Mach Research Group
*               Worcester Polytechnic Institute
*               Computer Science Department
*               100 Institute Road,
*               Worcester MA 01609.
*               U.S.A
*               (508) 831-5357

* Rev History : Originally developed by Bradford Nichols,
*               late modified to make it in an include file,
                Sep 1990.
*                 
************************************************************************/
/*********************** SELECT TIMING METHOD ***********************/
/*                            systems
    timing          MACH 2.5    MACH 3.0   SCO V.3   SYS V.4
    ---------------------------------------------------------
    gettimeofday        X          X                    X
    getrusage           X          X                    
    ftime               X          X          X
    time                X          X          X         X
    times               X          X          X         X
    clock                                     X         X
*/

/* #define GETTIMEOFDAY */
/* #define GETRUSAGE */
#define FTIME   
/* #define TIME */
/* #define TIMES */
/* #define CLOCK  */
/*****************************************************************/


/************* DEFINE TIMING PARAMETERS AND INCLUDES *************/
#ifdef GETTIMEOFDAY
#include <sys/time.h>     
  struct timeval  gtime_start, gtime_end;
  struct timezone gtzp;
  double          gtime_elapsed;
  int             gtime_diff;
#endif
#ifdef GETRUSAGE  
#include <sys/time.h>      
#include <sys/resource.h>  
  struct rusage   rusage_start, rusage_end;
  double          rusage_utime, rusage_stime;
  int             rusage_udiff, rusage_sdiff;
#endif
#ifdef FTIME
#include <sys/timeb.h>     
  struct timeb    ftime_start, ftime_end;
  unsigned long   ftime_sec1, ftime_sec2, ftime_millisec1, ftime_millisec2;
  unsigned long   ftime_diff;
#endif
#ifdef TIME
#include <sys/times.h>    
  time_t          time_start, time_end;
  int             time_tdiff;
#endif
#ifdef TIMES
#include <sys/times.h>    
#include <sys/param.h>        
  struct tms      times_start, times_end;
  long            times_utime, times_stime;
  int             times_udiff, times_sdiff;
#endif 
#ifdef CLOCK
  long            clock_start, clock_end;
  int             clock_diff;
#endif

