
/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-client.c=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/

/*********************************************************************
*
* Name        : client.c   / * of sdbase * /
*
* Version     : $Revision: 1.0 $
*
* Description : Client process for the synthetic database - Sdbase
*
* Written by  : Aju John
*
* e-mail      : mach@cs.wpi.edu
*
* Address     : Mach Research Group
*               Worcester Polytechnic Institute (WPI)
*               Computer Science Department
*               100 Institute Road,
*               Worcester MA 01609.
*               U.S.A
*               (508) 831-5357
*
************************************************************************/


/******************************************************************************
 *  This benchmark was originally  written using Mach ipc features, but
 *  later modified to have only SVID calls to make it highly portable. 
 *  Certain principles are taken with permission from
 *  The BYTE UNIX Benchmarks - Release 2
 *          Module: dbmscli.c   SID: 2.4 1/17/90 15:52:05
 *          
 ******************************************************************************
 * Sdbase
 * ======
 * 
 * Multi-user database simulation benchmark
 * Uses the CLIENT - SERVER PARADIGM.
 * Services multiple clients concurrently
 */

/*
 * NOTE: This version assumes TCP / IP compatibility.
 */
static char rcsid[] = "$ld$";
#define TRUE 1
#define FALSE 0
#define DEFAULTASKS 1 /* default number of sub clients */

#include <stdio.h>
#include <ctype.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/signal.h>
#include <sys/param.h>
#include <arpa/nameser.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include <resolv.h>
#include "defines.h"

#define SERVPORT        3278
#define BUFSIZE         512
#define MAXNAME         20
#define CMDLEN          80
#define WHITE           " \t\n"



#define ERROR	(-1)
/*
** Record definitions.
*/

#define IDLEN 5
#define NAMELEN 20
#define ADDRLEN 40
#define PHONLEN 10
#define RECLEN  75	/* Sum of the above. */

/*
** Message types.
*/
#define READREQ	1		/* Read a record */
#define WRITEREQ 2		/* Write a record */
#define ADDREQ 3		/* Add a new record */
#define GETLREQ 4		/* Get largest record number */
#define DIEREQ 99		/* Orders server to terminate. */

#define	MAXDATA	20

/*
** Return codes from the server.
*/
#define AOK 1			/* Request met ok */
#define DERR_RNF 2		/* Record not found */
#define DERR_RAE 3		/* Record already exists */
#define DERR_WRD 4		/* Unexplainable error */
#define DERR_UNK 9		/* Unknown request type */


typedef struct {
	char id[IDLEN];
	char name[NAMELEN];
	char address[ADDRLEN];
	char phone[PHONLEN];
} 
dbrec;

typedef struct {
	int sseed;
	int iter;
	int my_port;
} 
client_args;



typedef struct {
	int request;		/* Request type and response code */
	char recdat[RECLEN];	/* DBMS record data */
} 
msgdata;

/* global declarations */
/*
** Structure instances.
*/
dbrec myrec;		/* Data record */

char myreq_data[RECLEN+10];

typedef long key_t;

struct session{
  char hostname[30];
  struct sockaddr_in remote_addr;
  int sock;
}sessions;


FILE *log_file;

struct state orig;
extern int h_errno;



int ntasks = DEFAULTASKS;	/* Number of tasks */
int sleeptime = 0;		/* Time to sleep */
int iters = ITERATIONS;	        /* iterations */
unsigned long errcnt;		/* Error count */
int rid;			/* ID chosen at random */

/*
**  Externs and function defs.
*/

long randnum(), randwc();
int slave_client();
int count;         /* number of slaves active */
char host[32];

long maximum_size;

unsigned long time_diff;

/**********************************main.c*************************************/

main(argc,argv)
int argc;
char *argv[];

{

	int             my_port;
	int             request = 0;
	double          client_elapsed = 0;
	int             client_diff = 0;
	char            hostname[32];
	int             arg1, arg2;
	struct          sockaddr_in rm_task;
	char            task_buf[3];
	int             task_sock, over_head;

	/************* process command line parameters ************/

	begin_timing();

	/* processing the command line parameters */

	if (argc > 1) 
	  arg1 = atoi(argv[1]); /* if argv[1] is a name, arg1 = 0 */
	else
	  arg1 = -1;

        if( 0 == arg1 ) /* check to see if remote host is a string */
	  {
	    strcpy(hostname,argv[1]);
	    over_head = 1;
	    printf("Using specified hostname: %s \n", hostname);
	    if (argc > 2)
	      arg1 = atoi(argv[2]); /* grab the number of sub-clients */
	    else 
	      arg1 = -1;
	    if (argc >3)
	      {
		arg2 =  atoi(argv[3]); /* grab the no. of iterations */
		if (arg2 == 0) arg2 = -1;
	      }
	    else
	      arg2 = -1;
	    
	  }
	else
	  {
	    gethostname(hostname, 32); /* Oh! no remote host specified */
	    over_head = 0;
	    printf("Server assumed to be on host: %s\n", hostname);
	    /* using infinite wisdom to assume that server is local */
	    if (argc > 2)
	      arg2 = atoi(argv[2]);
	    if( 0 == arg2 )
	      arg2 = -1;
	  }
	if ( arg1 > 0 )
	  ntasks = arg1;
	else
	  { /* Instructions on how to type the command line */

	    fprintf(stderr,"**Unrealistic # of clients\n");
	    fprintf(stderr,"usage:%s [hostname] #clients #iterations\n",
		    argv[0]); 
	    exit(1);
	  }
	strcpy (host, hostname);
	if (arg2 > 0)
	  iters = arg2;
	maximum_size = 0L;

	/* clearing some temporary files */
	system("rm -f dbc_* *_r *_w");

	/* echoing the user's request back to her/him */
	printf("Iterations per client:%d,  # of clients:%d\n",
	iters, ntasks);
	if (ntasks == 0) ntasks = CLIENTS;
	client_diff = 0;

	/* setup portion over, calculating setup overheads */
	end_timing();
	client_diff += time_diff;
	
	/*****
	  Note
	  ****
	  Printf statements within #ifdef-#endif  provide additional
	  level of documentation. So they have not been removed.
	  */

#ifdef DEBUG
	printf("Client set-up time = %d msec\n",(int) time_diff);
#endif
	begin_timing();

	/* establishing sockets and TCP connections. Uses
           AF_INET mode. See utils.c for details */

	task_sock = initialize_client(hostname, &rm_task);
	task_buf[0] = ntasks;
	task_buf[1] = 0;
	/* informing server of the number of clients to expect */
	send_data ( task_sock, task_buf, 3);

	my_port = SERVPORT;

	/* calling the master client program, which creates sub-clients */
	master_client(ntasks,iters,my_port,hostname);
	clearrec(myreq_data);

	cl_anl(ntasks,iters,over_head);
	end_timing();
	client_diff += time_diff;
	
	printf("Total client (real) time is: %d milliseconds.\n" , client_diff );
	/* G'bye */
	exit(0);


}


/*
 * The master spawns a given number of slaves and then waits for them all to 
 * finish.
 */


master_client(nslaves,iter, my_port, host)
int nslaves;
int iter;			/* Number of iterations */
int my_port;
char *host;

{
#include <sys/wait.h>

	int i;
	int sseed = 0;
	int child_pid;
	int pid;
	int status;

	/* forking sub-clients */
	count = 0;
	for (i = 1; i <= nslaves; i += 1) 
	  {
	    if ( ( child_pid = fork()) < 0)
	      {
		bailout("Server:vfork error");
		exit(-1);
	      }
	    else if (child_pid == 0)
	      {
#ifdef DEBUG
		printf("Sub client process forked.\n");
#endif
		slave_client(iter, i);
		_exit(0);
	      }
	  printf("Sub-client %d started\n", i);
          printf("[%d]   %d\n", i, child_pid);
	  }

	/* waiting for the sub-clients to finish */
	for (i = 1; i <= nslaves; i += 1) 
	  {
	     wait(&status);
	   }

#ifdef VERBOSE
	printf("All %d slave_clients have finished.\n", nslaves);
#endif
	return;
}


/**************************** slave_client *************************
** Execute tests.
** Input number acts as seed for random number generator.
** Returns -1 if failure.
********************************************************************/
#define START 0
#define STOP 1


slave_client (slave_args, clientID)
int slave_args;
int clientID;
{
  
  unsigned long timing();
  
  unsigned long time_difference = 0;
  unsigned long client_time = 0;
  unsigned long init_time = 0;
  unsigned long getlen_time = 0;
  unsigned long read_time = 0;
  unsigned long write_time = 0;
  unsigned long append_time = 0;
  
  
  long Cclient_time = 0;
  long Cinit_time = 0;
  long Cgetlen_time = 0;
  long Cread_time = 0;
  long Cwrite_time = 0;
  long Cappend_time = 0;
  long tmp_store;
  
  extern char host[];
  int sock;
  char buf[RECLEN+10];
  struct sockaddr_in *rm;
  FILE            *fp;
  long randnum(), randwc();

  unsigned long rd_cnt = 0,           /* read request counter */
  wr_cnt = 0,           /* write request counter */
  ad_cnt = 0,           /* add request counter */
  gt_cnt = 0,           /* get request counter */
  rs_cnt = 0;           /* result request counter */
  unsigned long s_cl_time = 0;
  char time_stamp[10], server_time[10], last_record[10];
  int i,j;	/* Loop variables */
  long maxid;	/* Max ID currently in database */
  long mypid;	/* Get my process id */
  int request;           /* service request */
  char * reply_string;
  int client_error = FALSE;
  int sseed, iter;
  extern struct session sessions;
  char            c[5], tmp[6];
  char            disk[30];
  
  iter = slave_args;
  sseed = clientID;
  
  randnum((unsigned long)sseed);
  client_error = FALSE;		        
#ifdef DEBUG
  printf("slave received host name: %s\n", host);
#endif DEBUG
  strcpy( sessions.hostname, host);
  rm  = &sessions.remote_addr;
  sessions.sock =  initialize_client(host, rm);
  
  
  
  /*
   ** Initialize error count and timer stuff.
   */
  errcnt=0;
  
  /*
   ** I need to know my process id.
   */
  mypid = (long)getpid();
  
  /*
   ** Find out what the maximum id in the database
   ** is.
   */
  
  timing(START);
  
  /* first thing to do is to find out how many records are
   * there in the database. So, request for the last record
   * number in the database managed by the server process.
   */

  request=GETLREQ;
  
  ++gt_cnt; /* counter to record the number of requests */
#ifdef VERBOSE
  printf(" The GETREQ request \n");
#endif
  /* setting up the request */
  buf[0] = request;
  buf[1] = 0;
#ifdef VERBOSE
  printf( "sending a GETREQUEST\n");
#endif
  send_data ( sessions.sock, buf, 3);
#ifdef VERBOSE
  printf("receiving reply\n");
#endif
  receive_data  (sessions.sock, buf);

  /* the reply has the status code indicating the success or
     failure of the operation and the time taken by the server
     to service the request. Next few lines are used to extract
     these info from the reply */

  strcpy (server_time , (char *) strtok(buf ,":"));
  strcpy (last_record , (char *)strtok (NULL, ":"));

#ifdef VERBOSE
  printf("last record is %s time %s\n", last_record, server_time);
#endif

  time_difference = timing(STOP);
  getlen_time += time_difference;

  /* checking for possible timing errors */
  if ( atol(server_time) > time_difference)
    {
      client_error = TRUE; 
      
    }
  
  getlen_time += time_difference;
  tmp_store = (time_difference - atoi(server_time));
  Cgetlen_time += tmp_store;
  
#ifdef DEBUG
  printf("++++Last rec is %d\n",atol(last_record));
  printf("++++Time from server is %d\n",atol(server_time));
  printf("++++Time from client is %d\n",time_difference);
  printf("++++Comm Time from client is %d\n",tmp_store);
  printf("++++Comm Time total is %d\n",Cgetlen_time);
#endif

/* The last record number is called maxid */
  maxid=atol(last_record);
  maximum_size = (int)maxid;
  
#ifdef DEBUG
  printf("maxid = %d\n",maxid);
  printf("Entering loops\n");
  printf("Iterations passed : %d \n", iter);      
#endif

  /*     
   ** Now loop through the tests iter times.
   */
  for(i=0;i<iter;i++)
    { 
#ifdef DEBUG
      printf ("iter %d\n", i);
      printf("In outer loop of client\n");
#endif
      /* Do 4 reads */
      for(j=0;j<4;j++)
	{

/* Now is the time to read some records */
	  
#ifdef DEBUG
	  printf("In inner loop of client\n");
#endif
	  /* select a record at random, but within the range of maxid */

	  rid=(int)randwc((int)maxid)+1;
	  sprintf(tmp,"%5d\0",rid);
	  request=READREQ;

	  
#ifdef DEBUG
	  printf("About to read\n");
#endif

#ifdef VERBOSE
	  printf("The READREQ request \n");
#endif
	  
	  /**** communication begins ****/
	  time_difference = timing(START);
	  ++rd_cnt;
	  
	  buf[0] = request;
	  buf[1] = 0;
	  strcat(buf,tmp); /* append record number */
	  
	  
	  
#ifdef DEBUG
	  printf("sending READREQ\n");
#endif
	  send_data ( sessions.sock, buf, 7);
	  
#ifdef DEBUG
	  printf("receving READ REPLY\n");
#endif
	  receive_data  (sessions.sock, buf);
	  
	  strcpy (server_time , (char *) strtok(buf ,":"));
	  
#ifdef DEBUG
	  printf("Time is %s\n", server_time);
#endif
	  
	  time_difference = timing(STOP);
	  read_time += time_difference;
	  tmp_store = (time_difference - atoi(server_time));
	  Cread_time += tmp_store;
	  
	  /**** communication ends    ****/
	  /* Did we get what we should? */
	  errcnt+=verify();
	}
      
      
      
      time_difference = timing(START);
      /* Do 1 write */
      rid=(int)randwc((int)maxid)+1;
      clearrec(myreq_data);
      sprintf(myreq_data,"%5d",rid);
      loadrec((rid-1)%10);
      strncpy(myreq_data+5,myrec.name,RECLEN-5);
      request=WRITEREQ;
      
#ifdef VERBOSE
      printf(" The WRITEREQ request for:%s\n", myreq_data);
#endif
      ++wr_cnt;
      
      /***** comm starts ***/
      buf[0] = request;
      buf[1] = 0;
      strcat(buf, myreq_data);
      send_data ( sessions.sock, buf, sizeof(buf));
      receive_data  (sessions.sock, buf);
      strcpy (server_time , (char *) strtok(buf,":"));
      time_difference = timing(STOP);
      
      write_time += time_difference;
      tmp_store = (time_difference - atoi(server_time));
      Cwrite_time += tmp_store;
      
      
      /*************comm ends ********/
      
#ifdef DEBUG
      printf("Message recieved\n");
#endif
      
      
      
      
      
#ifdef DEBUG
      printf ("APPEND\n");
#endif
      
      /* Do an append every 10 times through the loop */
      if((i%10)==0)
	{
	  time_difference =  timing(START);
	  request=GETLREQ;
	  
	  
	  
#ifdef VERBOSE
	  printf(" The GETREQ request \n");
#endif
	  
	  
	  /**** communication begins ****/
	  buf[0] = request;
	  buf[1] = 0;
	  send_data ( sessions.sock, buf, 3);
	  receive_data  (sessions.sock, buf);
	  
#ifdef DEBUG
	  printf("GETLREQ of append got\n");
#endif
	  ++gt_cnt; 
	  strcpy (server_time , (char *) strtok(buf,":"));
	  strcpy (last_record , (char *)strtok (NULL, ":"));
	  time_difference = timing(STOP);
	  
	  
	  if ( atol(server_time) > time_difference)
	    {
	      client_error = TRUE; 
	    }
	  
	  getlen_time += time_difference;
	  tmp_store = (time_difference - atoi(server_time));
	  Cgetlen_time += tmp_store;
#ifdef DEBUG
	  printf ("****Last rec is %d\n",atol(last_record));
	  printf("****Time from server is %d\n",atol(server_time));
	  printf("****Time from client is %d\n",time_difference);
	  
	  printf("***Comm Time client is %d\n",tmp_store);
	  printf("***Comm Time total is %d\n",Cgetlen_time);
#endif
	  /* The adding of the record */
	  
	  
	  time_difference = timing(START);    
	  ++ad_cnt;
	  
	  maxid=atol(last_record);
	  rid=(maxid+=1);
	  clearrec(myreq_data);
	  sprintf(myreq_data,"%#05d",rid);
	  loadrec((rid-1)%10);
	  strncpy(myreq_data+5,myrec.name,RECLEN-5);
	  request=ADDREQ;
	  
	  /***** comm starts ***/
	  strcpy (server_time , (char *) strtok(buf ,":"));
	  buf[0] = request;
	  buf[1] = 0;
	  strcat(buf, myreq_data );
	  send_data ( sessions.sock, buf, sizeof(buf));
	  receive_data  (sessions.sock, buf);
	  time_difference = timing(STOP);
	  strcpy (server_time , (char *) strtok(buf,":"));
	  if ( atol(server_time) > time_difference)
	    {
	      client_error = TRUE;
	      
	    }
	  append_time += time_difference;
	  tmp_store = (time_difference - atoi(server_time));
	  Cappend_time +=  tmp_store;
	  
	  
	}
      
      
      
    } /* iter for loop*/
  
  request=DIEREQ;
  
  /***** comm starts ***/
  buf[0] = request;
  buf[1] = 0;
  strcat(buf, myreq_data );
  send_data ( sessions.sock, buf, sizeof(buf));
  
  
  
  /*************comm ends ********/
  
  
  
  
  strcpy(disk,"dbc_");
  sprintf( c, "%d", clientID);
  strcat(disk, c);
  fp = fopen ( disk, "a");
  if (fp == NULL)
    {
      printf("Can't open %s\n", disk);
    }
  
  
  s_cl_time =    read_time + write_time + append_time + getlen_time;
  fprintf(fp, " %d", s_cl_time);
  fprintf( fp, " %d %d %d %d",
	  rd_cnt, wr_cnt, ad_cnt, gt_cnt);
  fprintf( fp," %d %d %d %d",
	  read_time, write_time, append_time, getlen_time);
  fprintf( fp," %d %d %d %d",
	  Cread_time, Cwrite_time, Cappend_time, Cgetlen_time);
  fprintf( fp," %d", maximum_size);
  fclose(fp);
  
#ifdef OUTPUT
  fprintf(stdout, "------------------------------------------------\n");
  fprintf(stdout, "\t read \t write \t append\t get_last_record \n");
  fprintf(stdout, "------------------------------------------------\n");
  fprintf(stdout, "Number of operations\n");
  fprintf(stdout, "\t %d \t %d \t %d \t %d \n",
	  rd_cnt, wr_cnt, ad_cnt, gt_cnt);
  fprintf(stdout, "Total time for each  operation (Time in msecs)\n");
  fprintf(stdout, "\t %ld \t %ld \t %ld \t %ld \n",
	  read_time, write_time, append_time, getlen_time);
  fprintf(stdout, "Average time for each  operation (Time in msecs)\n");
  fprintf(stdout, "\t %.2f  %.2f  %.2f  %.2f \n",
	  (float)read_time/(float)rd_cnt,  
	  (float)write_time/(float)wr_cnt,
	  (float)append_time/(float)ad_cnt,
	  (float)getlen_time/(float)gt_cnt);
  
  fprintf(stdout, "Total time for communication (Time in msecs)\n");
  fprintf(stdout, "\t %ld \t %ld \t %ld \t %ld \n",
	  Cread_time, Cwrite_time, Cappend_time, Cgetlen_time);
  fprintf(stdout, "Average time for communication (Time in msecs)\n");
  
  fprintf(stdout, "\t %.2f  %.2f  %.2f  %.2f \n",
	  (float)Cread_time/(float)rd_cnt, 
	  (float)Cwrite_time/(float)wr_cnt, 
	  (float)Cappend_time/(float)ad_cnt,  
	  (float)Cgetlen_time/(float)gt_cnt);
  client_time = init_time + getlen_time + read_time + write_time +
    append_time;
  fprintf(stdout, "------------------------------------------------\n");
  if (client_error)
    fprintf(stdout, "***WARNING*** Possible timing errors.\n");
  client_error = FALSE;
  
  fprintf(stdout,"Total sub-client time for operations  = %ld milliseconds\n",s_cl_time);
  
#endif
  
  close(sessions.sock);
  
  
#ifndef OUTPUT
  
  printf( "Client %d completed.\n", clientID);
  printf( "[%d]    Done\n", clientID);
#endif
  
  
  return;
  
}


/*
 ** verify
 */
int verify()
{
  char buffr[80];
  
  return(0);
}


/*
 ** Clear a record
 */
clearrec(rptr)
     char *rptr;
{
  int i;
  
  for(i=0;i<RECLEN;++i)
    *rptr++='\0';
  
  return;
}

/*
 ** Load the record up with random data.
 */
loadrec(sel)
     int sel;		/* Select which fake record */
     
{
  
  char *nname;
  char *naddr;
  char *nphon;
  
  switch(sel)
    {
    case 0:	
      nname="Tom Thompson        ";
      naddr="9401 Leads Road, Apt2                   ";
      nphon="3334442222";
      break;
    case 1: 
      nname="Aju John            ";
      naddr="CS-Worcester Polytechnic Inst., MA 01609";
      nphon="5088315005";
      break;
    case 2: 
      nname="Droo Bhabha         ";
      naddr="27 Joditoad Hollow Way                  ";
      nphon="3332221111";
      break;
    case 3: 
      nname="Elvis Presley       ";
      naddr="Return to sender; Address unknown       ";
      nphon="9995556666";
      break;
    case 4: 
      nname="Aaron Struggles     ";
      naddr="Highway 40 OverPass, Second Pylon       ";
      nphon="8883339999";
      break;
    case 5: 
      nname="Benjamin Peterson   ";
      naddr="Under The Bridge, HeavyWater City       ";
      nphon="7773229988";
      break;
    case 6: 
      nname="Doyle Woolston      ";
      naddr="4040 Pleasant Way, WICAT Central        ";
      nphon="2228332299";
      break;
    case 7: 
      nname="John Doe            ";
      naddr="Big Oak Tree Behind Barsodie's          ";
      nphon="32244566657";
      break;
    case 8: 
      nname="Harley Davidson     ";
      naddr="7000 Aloth Cove                         ";
      nphon="2118332929";
      break;
    case 9: 
    default: 
      nname="Blind Willy Chitlins";
      naddr="Unavailable Until Further Notice        ";
      nphon="3456789012";
      break;
    }
  
  strncpy(myrec.name,nname,NAMELEN);
  strncpy(myrec.address,naddr,ADDRLEN);
  strncpy(myrec.phone,nphon,PHONLEN);
  
  return;
}


/**************************** badnews **************************/
int bad_news() /* things are messed up */
{
  fprintf(stderr,"TIMED OUT\n");
  exit(1);
}


/***********************initialize client **********************/


initialize_client(host, remote_addr)
     struct sockaddr_in *remote_addr;
     char *host;
{
  int sock, t;
  
  mk_sock_addrin(remote_addr, host);
  sock = create_socket();
  t = connect_to_socket(sock, remote_addr);
  if (t < 0) bailout("socket not connected");
  return(sock);
}




/*********************************************************************
 * Name        : cl_anl
 * Description : client output analyzer program - Sdbase
 *                calculates the lock overheads too!
 *
 ************************************************************************/


cl_anl(no_of_clients, itrs, ov_head)
     int   no_of_clients;
     int   ov_head;
     
{
  unsigned long rd_cnt, 		/* read request counter */
  wr_cnt,		/* write request counter */
  ad_cnt,		/* add request counter */
  gt_cnt,		/* get request counter */
  rs_cnt;		/* result request counter */
  
  unsigned long errcnt;		/* Total error count */
  
  unsigned long time_diff;
  unsigned long total_tasks;	/* Total number of tasks logged in */
  unsigned long client_time;
  unsigned long init_time;
  unsigned long getlen_time;
  unsigned long read_time;
  unsigned long write_time;
  unsigned long append_time;
  
  
  
  unsigned long Cclient_time = 0;
  unsigned long Cinit_time = 0;
  unsigned long Cgetlen_time = 0;
  unsigned long Cread_time = 0;
  unsigned long Cwrite_time = 0;
  unsigned long Cappend_time = 0;
  
  int       i,j,k,iter;
  char      c[5];
  char      disk[30], tmp[10];
  long      tot_client_time, tot_rd_cnt,tot_wr_cnt,tot_ad_cnt,tot_gt_cnt;
  long      tot_read_time, tot_write_time, tot_append_time, tot_getlen_time;
  int       l_rid;
  long      tot_Cread_time, tot_Cwrite_time, tot_Cappend_time,tot_Cgetlen_time;
  long      rd_ovhd, wr_ovhd, ap_ovhd, gt_ovhd, tot_ovhd;
  long      maximum_sz[100];
  FILE      *fp;
  long randnum(), randwc();  

  printf("*** Client data Analyzer ***\n");
  
  tot_client_time=tot_rd_cnt=tot_wr_cnt=tot_ad_cnt=tot_gt_cnt=0L;
  tot_read_time= tot_write_time= tot_append_time= tot_getlen_time=0L;
  tot_Cread_time= tot_Cwrite_time=  tot_getlen_time = tot_Cappend_time = 0L; 
  rd_ovhd =  wr_ovhd =  ap_ovhd =  gt_ovhd == 0L;
  
  printf("Analyzing Data for %d clients\n", no_of_clients);
  
  for(i=1; i<=no_of_clients; i++)
    {
      strcpy(disk,"dbc_");
      sprintf( c, "%d", i);
      strcat(disk, c);
      fp = fopen ( disk, "r");
      if (fp == NULL)
	{
	  printf("Error: Can't open %s\n\n", disk);
	  printf("*** Only %d files analyzed\n", i);
	  break;
	}
      fscanf(fp, " %d", &client_time);
      fscanf( fp, " %d %d %d %d",
	     &rd_cnt, &wr_cnt, &ad_cnt, &gt_cnt);
      fscanf( fp," %d %d %d %d",
	     &read_time, &write_time, &append_time, &getlen_time);
      fscanf( fp," %d %d %d %d",
	     &Cread_time, &Cwrite_time, &Cappend_time, &Cgetlen_time);
      fscanf( fp," %d", &maximum_size);
      maximum_sz[i] = maximum_size;
      Cclient_time +=  Cgetlen_time + Cread_time + Cwrite_time +
	Cappend_time;
      
      
      fclose(fp);
      tot_client_time += client_time;
      tot_rd_cnt += rd_cnt;
      tot_wr_cnt += wr_cnt;
      tot_ad_cnt += ad_cnt;
      tot_gt_cnt += gt_cnt;
      tot_read_time += read_time;
      tot_write_time += write_time;
      tot_append_time += append_time;
      tot_getlen_time += getlen_time;
      tot_Cread_time += Cread_time;
      tot_Cwrite_time += Cwrite_time;
      tot_Cappend_time += Cappend_time;
      tot_Cgetlen_time += Cgetlen_time;
      
    }
  
  if(tot_rd_cnt == 0) anl_error();
  if(tot_wr_cnt == 0) anl_error();
  if(tot_ad_cnt == 0) anl_error();
  if(tot_gt_cnt == 0) anl_error();
  
  wpi_banner("Synthetic Database: database client", "v1.0" );
  printf( "------------------TOTAL-TIME--------------------\n");
  printf( "\t read \t write \t append\t get_last_record \n");
  printf( "------------------------------------------------\n");
  printf( "Number of operations\n");
  printf( "\t %d \t %d \t %d \t %d \n",
	 tot_rd_cnt, tot_wr_cnt, tot_ad_cnt, tot_gt_cnt);
  printf( "Total time for each  operation (Time in msecs)\n");
  printf( "%14d%8d%8d%8d \n",
	 tot_read_time, tot_write_time,tot_append_time,tot_getlen_time);
  printf( "Average time  (Time in msecs)\n");
  printf( "\t %.2f  %.2f  %.2f  %.2f \n",
	 (float)tot_read_time/(float)tot_rd_cnt,
	 (float)tot_write_time/(float)tot_wr_cnt,
	 (float)tot_append_time/(float)tot_ad_cnt,
	 (float)tot_getlen_time/(float)tot_gt_cnt);
  printf( "Average time for Communications (Time in msecs)\n");
  printf( "\t %.2f  %.2f  %.2f  %.2f \n",
	 (float)tot_Cread_time/(float)tot_rd_cnt,
	 (float)tot_Cwrite_time/(float)tot_wr_cnt,
	 (float)tot_Cappend_time/(float)tot_ad_cnt,
	 (float)tot_Cgetlen_time/(float)tot_gt_cnt);
  
  printf( "------------------------------------------------\n");
  i--;
  printf( "Total client time = %d milliseconds\n",tot_client_time);
  printf( "(Total client time)/%d (for any client) = %d ms\n",i,tot_client_time/i);
  printf( "Total communication time = %d milliseconds\n",Cclient_time);
  printf( "(Total commun. time)/%d = %d ms\n",i,Cclient_time/i);
  printf( "*** Analysis of %d clients.\n", i);
  
  /* normalizing the lock overheads */
  
  
#ifndef NOLOCKS
  if (! (ov_head)) return;
  system("rm -f *_#s *_#r *_#w _ap_lck.dbs");
  
  printf(stderr,"Calculating lock over-heads...");
  for(i=1; i<=no_of_clients; i++)
    {
      gt_ovhd += dum_dotell();
      randnum((unsigned long)i);
      for (j=0; j<iters; j++)
	{
	  for(k=0;k<4;k++)
	    {
	      l_rid=(int)randwc((int)maximum_sz[i])+1;
	      sprintf(tmp,"%5d\0",l_rid);
	      rd_ovhd += dum_doread(tmp);
	      
	    }
	  l_rid=(int)randwc(maximum_sz[i])+1;
	  sprintf(tmp,"%5d\0",l_rid);
	  wr_ovhd += dum_dowrite(tmp);
	  if((j%10)==0)
	    {
	      gt_ovhd += dum_dotell();
	      ap_ovhd += dum_doadd();
	    }
	}
    }

  tot_ovhd = rd_ovhd + wr_ovhd + ap_ovhd + gt_ovhd;
  
  fp = fopen ( "tmp#ovhd", "w+");
  if (fp == NULL)
    {
      printf("Error: Can't open temp files\n\n");
      return(1);
    }
  fprintf(fp, " %d %d %d %d %d", rd_ovhd, wr_ovhd, ap_ovhd, gt_ovhd, tot_ovhd);
  fclose(fp);
  return(0);
  
  fprintf (stderr,"Lock overheads(msec):\nread:\t%8d\nwrite:\t%8d\nappend:\t%8d\ngtlast:\t%8d\n",rd_ovhd, wr_ovhd, ap_ovhd, gt_ovhd);
  fsync(stderr);
#endif NOLOCKS
}


anl_error()
{
  
  printf (" *** Error in Analysis ***\n");
  printf ("\tPossible cause:\n\t\t");
  printf ("Could not create intermediate data files\n\n");
  
}

/***********************program : client.c ends *************************/



