

/*********************************************************************
*
* Name        : dummy_ops.c   / * of sdbase * /
*
* Version     : $Revision: 1.0 $
*
* Description : dummy operations to calculate the lock overheads
*
* Written by  : Aju John
*
* e-mail      : mach@cs.wpi.edu
*
* Address     : Mach Research Group
*               Worcester Polytechnic Institute (WPI)
*               Computer Science Department
*               100 Institute Road,
*               Worcester MA 01609.
*               U.S.A
*               (508) 831-5357
*
************************************************************************/


#define ERROR (-1)




/**************************** dummy doread *********************
 ** Perform a read request.(just for the locks)
 *********************************************************/

#include<stdio.h>
#include <sys/file.h>
#include "makedbms.h"
dum_doread(idnum)
     char *idnum;
{
  
  long offset;
  char lockname[IDLEN+5], sema_lock[IDLEN+5];
  int ret, sema_ret, failed, one, value, maxid;
  FILE *rd_lock;
  unsigned long bg_time, end_time, dum_rd_blkd;
  unsigned long local_timing();
  /*
   ** Calculate offset.
   */
  bg_time = end_time = dum_rd_blkd = 0L;
  
  
#ifndef NOLOCKS
  
  
  strcpy(lockname,idnum);
  strcpy(sema_lock,idnum);
  strcat(lockname, "_#w");
  strcat(sema_lock, "_#s");
  ret = ERROR;
  
  bg_time = local_timing();
  while ( ret < 0)
    {
      ret = open(lockname, O_CREAT | O_EXCL);
    }
  
  
  rd_lock = NULL;
  close(ret);
  unlink(lockname);
  strcpy(lockname,idnum);
  strcat(lockname, "_#r");
  rd_lock = fopen(lockname, "r");
  if (rd_lock == NULL)
    {
      rd_lock = fopen(lockname, "w+");
      one = 1;
      fprintf( rd_lock, "%d" ,one );
      fclose (rd_lock);
    }
  else
    {
      
      fclose (rd_lock);
      sema_ret = -1;
      
      while(sema_ret == -1)
	{
	  sema_ret = open(sema_lock, O_CREAT | O_EXCL);
	}			
      
      dum_rd_blkd += (end_time - bg_time);
      close(sema_ret);
      
      rd_lock =  fopen(lockname, "r+");
      fscanf( rd_lock, "%d", &value);
      value ++;
      rewind( rd_lock);
      fprintf ( rd_lock, "%d", value);
      fclose(rd_lock);
      unlink (sema_lock);
    }
  
  sema_ret = -1;
  while(sema_ret == -1)
    {
      sema_ret = open(sema_lock, O_CREAT | O_EXCL);
    }
  close(sema_ret);
  
  rd_lock =  fopen(lockname, "r+");
  fscanf (rd_lock, "%d", &value);
  if (value == 1)
    {
      fclose(rd_lock);
      unlink(lockname);
    }
  else
    {
      value--;
      rewind(rd_lock);
      fprintf ( rd_lock, "%d", value);
      fclose(rd_lock);
    }
  end_time = local_timing();
  unlink (sema_lock);
  dum_rd_blkd += (end_time - bg_time);
  
#endif NOLOCKS
  
  return(dum_rd_blkd);				/* No problems */
}

/**************************** dowrite *********************
 ** Perform a write request.
 *************************************************************/
dum_dowrite(idnum)
     char *idnum;
{
  
  long offset;
  char lockname_r[IDLEN+5];
  char lockname_w[IDLEN+5];
  int ret_r , ret_w, maxid;
  unsigned long end_time , bg_time, dum_wr_blkd;
  unsigned long local_time();
  
  
  
  /*
   ** Calculate offset.
   */
  bg_time = end_time = dum_wr_blkd = 0L;
  
#ifndef NOLOCKS
  bg_time = local_timing();
  strcpy(lockname_w,idnum);
  strcpy(lockname_r,idnum);
  strcat(lockname_w, "_#w");
  
  ret_w = -1;
  while ( ret_w < 0)
    {
      /* first capture the write lock */
      ret_w = open(lockname_w, O_CREAT | O_EXCL);
    }
  
  close(ret_w);
  strcat(lockname_r, "_#r");
  ret_r = -1;
  while( ret_r < 0)
    {
      ret_r = open(lockname_r, O_CREAT | O_EXCL);
    }
  close(ret_r);
  unlink(lockname_r);
  unlink(lockname_w);
  end_time = local_timing();
  dum_wr_blkd += (end_time - bg_time);
#endif NOLOCKS
  
  return(dum_wr_blkd);
}

/**************************** doadd *********************
 ** Perform an add request.
 *************************************************************/
dum_doadd()
     
{
  char lockname[12];
  long offset;
  unsigned long end_time , bg_time, dum_ap_blkd;
  unsigned long local_time();
  int ret;
#ifndef NOLOCKS
  
  dum_ap_blkd = 0L;
  strcpy(lockname,"_ap_lck.dbs");
  bg_time = end_time = 0L;
  
  ret = -1;
  bg_time = local_timing();
  while ( ret < 0)
    {
      ret = open(lockname, O_CREAT | O_EXCL);
    }
  close(ret);
  end_time = local_timing();
#endif NOLOCKS
  /* Seek to the end of the file. */
  /* Get offset -- we presume caller has proper id set */
  
  dum_ap_blkd += (end_time - bg_time);
#ifndef NOLOCKS
  unlink(lockname);
#endif NOLOCKS
  return(dum_ap_blkd);
}

/**************************** dotell *********************
 ** Perform a "tell" request.
 ** Returns highest current id number in file.
 *************************************************************/
dum_dotell()
{
  
  char lockname[12];
  long offset;
  int ret;
  unsigned long end_time , bg_time;
  unsigned long local_time();
  unsigned dum_gt_blkd;
  
  dum_gt_blkd = 0L;
#ifndef NOLOCKS
  bg_time = end_time = 0L;
  strcpy(lockname,"_ap_lck.dbs");
  ret = -1;
  bg_time = local_timing();
  while ( ret < 0)
    {
      ret = open(lockname, O_CREAT | O_EXCL);
    }
  close(ret);
#endif NOLOCKS
  /* Seek to the end of the file. */
  /* Get offset and calculate new id number */
#ifndef NOLOCKS
  unlink(lockname);
#endif NOLOCKS
  end_time = local_timing();
  dum_gt_blkd += (end_time - bg_time);
  return(dum_gt_blkd);
}

