/*********************************************************************
*
* Name        : makedbms.c   ;; of sdbase
*
* Version     : Extended version
*
* Description : Simple database generator program for sdbase.
*               It was modified to create larger databases, from
*               the Byte version.
*
* e-mail      : mach@cs.wpi.edu
*
* Address     : Mach Research Group
*               Worcester Polytechnic Institute (WPI)
*               Computer Science Department
*               100 Institute Road,
*               Worcester MA 01609.
*               U.S.A
*               (508) 831-5357
*************************************************************************
*  This program is a modified version of the original program developed by
*  The BYTE UNIX Benchmarks - Release 2 Module: buildbms.c   SID: 2.4 1/17/90
*************************************************************************
* Database has the form:
* IIIIINNNNNNNNNNNNNNNNNNNNAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAPPPPPPPPPP
* Where IIIII is the 5-digit id number (0-padded)
*       NN... is the 20-character name
*       AA... is the 40-character address
*       PP... is the 10-character phone number
* Records are accessed by ID number (1 is the 0th record, 2 is 1st..etc.)
*
* Execute this program with:
*    buildbms <filename> <n>
*      where <filename> is the name of the database file and
*            <n> is the number of records to create in the database.
****************************************************************************/
#include <stdio.h>;
#include "makedbms.h";
FILE *dbfp;			/* Pointer for database file */


main(argc,argv)
int argc;
char *argv[];

{

	int i,j, selection;		/* Loop variables */

	/* see if there is a filename and number of records in cmd-line */
	if(argc!=3)
	{
		fprintf(stderr,"usage: %s <filename> <#records>\n",argv[0]);
		exit(1);
	}
	/*
	** Create the file. 
	*/
	if((dbfp=fopen(argv[1],"w"))==NULL)
	{
		fprintf(stderr,"**Open error on: %s\n",argv[1]);
		exit(1);
	}

	j=atoi(argv[2]);
	for(i=0;i<j;i++)
	{
		sprintf(myrec.id,"%#05d",i+1);
		selection = i%15;
		choose(selection);
		fwrite((char *)&myrec,RECLEN,1,dbfp);
	}

	fclose(dbfp);
	exit(0);
}

/*
** Load the record up with random data.
** Disclaimer: All these names and addresses are fictional.
** Any resemblence to reality is a coincidence.
*/


choose(option)
int option;
{

	char *nname;
	char *naddr;
	char *nphon;

	switch(option)
	{
	case 0:	nname="Elvis Thompson        ";
		naddr="9401 Lombard St San Fransisco CA 90343  ";
		nphon="3334442222";
		break;
	case 1: nname="Aju John            "; /* not fictitious */
		naddr="28 Lancaster Street Apt 2L Worc Ma 01609";
		nphon="5087551697";
		break;
	case 2: nname="Scott Grey          ";
		naddr="27 Split Brook Way NH 00000             ";
		nphon="3336756111";
		break;
	case 3: nname="Jude  Dutton        ";
		naddr="Apt 3, WallState Building, Mill Rd, Ma  ";
		nphon="9995556666";
		break;
	case 4: nname="Aaron Pinto         ";
		naddr="Cathedral Road, Tangasseri, Quilon IN   "; 
		nphon="8883339999";
		break;
	case 5: nname="Cheetham & Steele   ";
		naddr="01 MADison Ave, NY 10002                ";
		nphon="7773229988";
		break;
	case 6: nname="Dayle McAulffe      ";
		naddr="40 Pleasant St, Worcester Ma 01609.     ";
		nphon="2228332299";
		break;
	case 7: nname="Andrew Shaw         ";
		naddr="29 Yorkshire Court, Shrewsberry MA 01785";
		nphon="32244566657";
		break;
	case 8: nname="Steve Taylor        ";
		naddr="Address Unknown                         ";
		nphon="21345182929";
		break;
	case 9: nname="John Lennon         ";
		naddr="30 Down Hill Slide, London R34 Ui7      ";
		nphon="00345182929";
		break;
	case 10: nname="John Lennon         ";
		naddr="30 Down Hill Slide, London R34 Ui7      ";
		nphon="71645182929";
		break;
	case 11: nname="June Carson         ";
		naddr="30 Down Hill Rd, Berkeley CA 98545      ";
		nphon="182929";
		break;
	case 12: nname="Terrence Walker     ";
		naddr="303 West  Hill Av, Lonavla R34 Ui7      ";
		nphon="91345182929";
		break;	
	case 13: nname="Geraldine Gozmio    ";
		naddr="23 Kevbeck's landing, lansing, MI 34545 "; 
		nphon="24445182929";
		break;
	case 14: nname="Lyndon D'Cruz      ";
		naddr="30 Ranch Lane, Sydney AU 564 U57        ";
		nphon="21345182929";
		break;
	default: nname="Return 2 Sender,   ";
		naddr="Unavailable Until Further Notice        ";
		nphon="3456789012";
		break;
	}

	/** Fill the structure with  data. **/

	strncpy(myrec.name,nname,NAMELEN);
	strncpy(myrec.address,naddr,ADDRLEN);
	strncpy(myrec.phone,nphon,PHONLEN);

	return;
}





