
/*********************************************************************
*
* Name        : client.c -- of Sftp
*
* Version     : 1.0
*
* Description : The client process is complimented by a server in transfer
*               -ing data files across machines using TCP/IP protocol.
*
* Written by  : Aju John
*
* Address     : Worcester Polytechnic Institute
*               Computer Science Department
*               100 Institute Road,
*               Worcester MA 01609.
*               U.S.A
*               (508) 831-5005
*
************************************************************************/

/******************************************************************
  This program is a part of a client - server data transfer system
  built to study the effect of different sizes of buffering to the
  transport interface, and to compare the file transfer performance
  using TCP/IP protocol. 
 ******************************************************************/

/***************************   REVISION HISTORY ****************************
 *  $Log:	client.c,v $
 * Revision 1.2  90/11/30  17:18:03  aju
 * The cleaned up, frozen version of client, after dvp on Mach.
 * 
 ***************************************************************************/


#define SERVPORT        3277
#define BLOCKSZ	        512
#define MAXNAME         20
#define CMDLEN          50
#define WHITE           " \t\n"

#include <stdio.h>
#include <sys/types.h>
#include <arpa/nameser.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include <resolv.h>


struct session{
  char hostname[30];
  struct sockaddr_in remote_addr;
  int sock;
}ses_array[10];

int sessions =  -1;

FILE *log_file;

unsigned long time_diff;

struct state orig;
extern struct state _res;
extern int h_errno;

main( argc, argv) /* takes 2 parameters - commandfile buffersize */
     
     int	argc;
     char	**argv;
     
{
  int	i, sock, t, len;
  struct sockaddr_in	remote_addr;
  char *command_str, *last_command;
  char *command; /* [MAXNAME];*/
  char *param1; /*[MAXNAME];*/
  char get_cmd[50];
  int blocksize = BLOCKSZ;
  int buffer_size;
  int interactive = 0;
  int allocerr  = 0;
  FILE *command_file;
  
  /* allocating memory for buffers */
  
  if ( (command_str = (char *) calloc (CMDLEN , sizeof(char))) == NULL ) 
    allocerr = 1;
  if ( (last_command = (char *) calloc (CMDLEN , sizeof(char))) == NULL ) 
    allocerr = 1;
  if ( (command     = (char *) calloc (MAXNAME, sizeof(char))) == NULL ) 
    allocerr = 1;
  if ( (param1  = (char *) calloc (MAXNAME, sizeof(char))) == NULL ) 
    allocerr = 1;
  
  if ( allocerr) 
    {
      printf( "Cannot allocate memory. G'bye.\n");
      exit (-1);
    }

  /* printing WPI banner */
  wpi_banner("Synthetic ftp Benchmark -- Sftp ", "1.0" /* version number*/);


  /* check to see if a command file is used. If not, the client program
     goes into an interactive mode */

  if ((command_file = fopen(argv[1], "r")) == NULL)
    {
      if (argv[1] == NULL)
	printf("Command file not specified.\n");
      else
	printf("Command file:%s not accessible.\n", argv[1]);
      printf("Entering interactive mode. Type quit to exit\n");
      interactive = 1;
    }
  
  strcpy(last_command, "\n");
  
  do{
    if (interactive)
      {
	printf ( ">> "); /* the prompt in i/a mode */
	gets(get_cmd);
	strcpy(command_str, get_cmd);
      } 
    else
      fgets(command_str, CMDLEN, command_file);
    
    /* interpreter engine for parsing the commands */

    if (strncmp(command_str, "!!", 2) == 0) 
      strcpy(command_str, last_command);
    if (strcmp(command_str, "\n") == 0) continue;
    if (strlen(command_str) < 2) continue;
    if (command == NULL) continue;
    strcpy(last_command, command_str);
    command = (char *)strtok(command_str, WHITE);
    param1 = (char *)strtok (NULL, WHITE);
    if (param1 == NULL)
      if ( strcmp(command, "quit")==0 || strcmp(command, "ls")==0)
	printf ("<< %s:  \n", command );
      else
	{
	  printf("Incomplete command. Please retry with a parameter.\n");
	  continue;
	}
    else
      printf ("<< %s: <%s> \n", command , param1);

    /* creating/connecting a socket */
    sock = get_sock_number(command, param1);
    if (sock > 0)
      send_data(sock, command, strlen(command)+1);

    /* calling routines, depending on commands received */
    if (strcmp(command, "ls")==0)
      directory(sock);
    else if (strcmp(command, "put") == 0)
      send_file(sock, param1, blocksize);
    else if (strcmp(command, "get") == 0)
      get_file(sock, param1, blocksize);
    else if (strcmp(command, "open") == 0)
      open_session( param1 );
    else if (strcmp(command, "chdir") == 0)
      chdir(sock, param1);
    else if (strcmp(command, "buffer") == 0)
      blocksize = set_buffer(sock, param1, blocksize);
    else if (strcmp(command, "quit") != 0)
      {
	printf("%s, uh? Sorry, %s is not a known command.\n", command,command);
	printf("Commands are: open buffer get put ls chdir & quit\n");
      }
  }while(strcmp(command, "quit") != 0);
  close( sock );
}

/* routine to change directory on server */
chdir(sock, dir)
     int sock;
     char *dir;
{
  int response;
  char dirname[30];
  
  strcpy ( dirname , dir);
  send_data(sock, dirname, strlen(dirname)+1);
  
  receive_data(sock, &response);
  if (response == 0) 
    printf("chdir: changed  directory to %s\n", dir);
  else 
    printf("directory name wrong\n");
}

/* routine to set transport buffer size on client and server */
set_buffer(sock, buffer_size, oldsize)
     int sock;
     char *buffer_size;
     int oldsize;
{
  int response;
  int newsize;
  
  newsize = atoi(buffer_size);
  if  ( newsize > 63)
    send_data(sock, buffer_size, strlen(buffer_size)+1);
  else
    {
      printf("Buffer size too small. Not changed\n");
      return (oldsize);
    }
  receive_data(sock, &response);
  if (response == 0) 
    printf("Buffer size changed to  %s\n", buffer_size);
  else 
    {
      printf("Server refuses changes. Request ignored.\n");
      return (oldsize);
    }    
  return (newsize);
}


/* to get the directory listing at the server end */
directory(sock)
     int sock;
{
  char fname[30], buf[BLOCKSZ];
  int i, len, dirlen;
  
  if (sock < 0) return;
  receive_data(sock, &dirlen);
  if (dirlen == 0) return;
  
  do{
    len = receive_data(sock, buf);
    dirlen -= len;
    for(i=0; i<len; i++)
      printf("%c", buf[i]);
  }while(dirlen > 0);
  
}


/* routine to send a file to the server */

send_file(sock, fname, blocksz)
     int sock;
     char *fname;
     int blocksz;
{
  
  long get_size();
  char *buf;
  long len, filsiz;
  int  fd;
  char fname1[25];
  int cl_time = 0;
  
  if (sock < 0) return;
  buf = (char *)malloc( blocksz+1, sizeof(char));
  fd = open(fname, 2);
  if (fd < 0){
    printf("file %s cannot be opened\n", fname);
    return;
  }
  else
    printf("file %s  opened\n", fname);
  len = get_size(fname);
  filsiz = len;
  printf ("%s (put): ",fname);
  strncpy(fname1, fname, 24);
  strcat (fname1, "_TFR");
  send_data(sock, fname1, strlen(fname1) + 1);
  send_data(sock, &len, 4);
  len=1;
  cl_time = 0;
  while(len > 0){
    len = read(fd, buf, blocksz);
    if (len > 0)
      {
	time_diff = 0;
	begin_timing();
	send_data(sock, buf, len);
	end_timing();
	cl_time +=  (int)time_diff;
      }
    else if (len < 0) printf("Warning: Incorrect read response.\n..");

  }

  /* printing the statistics of transfer operation */
  
  printf("\n\n  Transferred as %s \n", fname1);
  printf("  Block size: %d, Time: %d msec, File size: %d bytes\n",
	 blocksz, cl_time,filsiz);
  printf("  Data transfer rate = %.2f bytes/sec\n", 
	  60.0*(float)filsiz/(float)cl_time );
  
  len = receive_data(sock, buf);
  buf[len] = 0;
  printf("  Write time at server is %s msec\n", buf);
  cl_time -= atol(buf);
  printf("  Transfer time: %d msec, \n", cl_time);
  if (cl_time > 0)
    printf("  Data transfer rate without I/O overhead  = %.2f bytes/sec\n", 
	  60.0*(float)filsiz/(float)cl_time );
  else
    printf("  Data file too small to compute data transfer rate\n");
}

/* routine to get a file from the server. invoked by get */

get_file(sock, fname, blocksz)
int sock;
char *fname;
int blocksz;
{
  long get_size();
  char *buf;
  int fd;
  long filsiz,len, filelen, size;
  unsigned long  client_time;
  char fname1[25];

  if (sock < 0) return;
  printf("getfile %s size %d \n", fname, strlen(fname));
  send_data(sock, fname, strlen(fname) );
  receive_data(sock, &filelen);
  if (filelen < 0){
    printf("file cannot be opened in remote machine\n");
    return;
  }
  printf ("The file will be %d bytes\n", filelen);
  strncpy(fname1, fname, 24);
  strcat (fname1, "_RCV");
  if ((fd = open(fname1, 2)) < 0)
       fd = creat(fname1, 0666);
  client_time = 0;
  buf = (char *)malloc( blocksz +1, sizeof(char));
  begin_timing();
  len = receive_data(sock, buf);
  end_timing();
  client_time += time_diff;
  write(fd, buf, len);
  filelen  -=  len;
  
  if (buf == 0)
    {
      printf ("error: malloc in get_file\n");
      return;
    }
  while(filelen > 0){
    begin_timing();
    len = receive_data(sock, buf);
    end_timing();
    client_time += time_diff;
    write(fd, buf, len);
    filelen  -=  len;
  }

  close(fd);
  filsiz = get_size(fname1);
  printf("\n\n  Received file as %s \n", fname1);  
  printf("  Block size: %d, Time: %d msec, File size: %d bytes\n",
	 blocksz, client_time,filsiz);
  if (client_time)
    printf("  Data transfer rate = %.2f bytes/sec\n", 
	  60.0*(float)filsiz/(float)client_time );
  else
    printf(" Client time is zero. Cannot compute data rate\n");

  len =  receive_data(sock, buf);
  buf[len]=0;
  printf("  Read time at server is %s msec\n", buf);
  client_time -= atol(buf);
  printf("  Transfer time: %d msec, \n", client_time);
  if (client_time)
    printf("  Data transfer rate without I/O overhead  = %.2f bytes/sec\n\n", 
	  60.0*(float)filsiz/(float)client_time );
  else
    printf("  Data file size too small to compute the transfer rate\n");

}


/* routine for shutting down the server, using a command from the
   client; can assign a location in an array for a socket; can look
   up the array for a matching session in case of multiple sessions
   are used (up to 10 sessions) */

get_sock_number(command , machine)
     char *command , *machine ;

{

  int i;

  if (strcmp(command, "open") != 0)
    if (sessions == -1){
        if (strcmp(command, "quit") != 0)
	  printf("Not connected to any server. Use open first.\n");
      return(-1);
    }
  if (strcmp(command, "open") == 0) return(0);
  if (strcmp(command, "quit") == 0){
    for(i=0; i<= sessions ; i++)
      send_data(ses_array[i].sock, command, strlen(command)+1);
    return(0);
  }

  if (sessions == 0) return(ses_array[0].sock);

  
  for(i=0; i<=sessions; i++){
    if (strcmp(ses_array[i].hostname, machine) == 0)
      return(ses_array[i].sock);
  }

  printf("unknown machine name  %s\n", machine);
  return(-1);
}
  
/* routine for opening a new session with a server */

open_session(server_machine)
char *server_machine;
{
  extern struct session ses_array[10];
  extern int sessions;
  char *host;
  struct sockaddr_in *rm;
  int i;
  char h[32];
  register struct hostent *hp;
 
  ++sessions;  
  strcpy( ses_array[sessions].hostname, server_machine);
  host = ses_array[sessions].hostname;
  rm  = &ses_array[sessions].remote_addr;
   ses_array[sessions].sock = 
           initialize_client(host, rm);


}

/* see hookup.c for the implementation of hookup() */
initialize_client(host, remote_addr)
struct sockaddr_in *remote_addr;
char *host;
{
  int sock, t;

  sock = hookup(host);
  if (sock < 0) bailout("socket not connected");
  return(sock);
}


