/*-=-=-=-=-=-=-=-=-=-=-=-=-sftpdata.c=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/

/************************************************************************

      Original    : sdumpdata.c - creates data for synthetic dump  
      NewName:    : sftpdata.c  - creates one data file of variable length
                                  for synthetic ftp.
  
      Written by  : Aju John  [aju@cs.wpi.edu]                         
                                                                       
      Institution : Dept of CS, Worcester Polytechnic Institute        
                                                                       
      Rev History : Written on      : July 2, 1990.                    
                    Last Modified on: July 4, 1990.                    
                    Version 1.0                                        

		    Modified on     : June 10, 1991.
		    Jonas A. Lehmann (WPI)
                                                                       
************************************************************************/

/******************************************************************
 * PRELIMINARY VERSION: Not for distribution.                     *
 * For final version, send mail to mach@cs.wpi.edu                *
 ******************************************************************/

/*

Inputs :  (command line arguments to this program)
========

First Argument: Filename of the file to be created

Second argument: Size of above data file

*/


#include <stdio.h>


main (argc, argv)
        int     argc;
        char    *argv[];
{
  int filesize, j;
  FILE *fi;


  /* Check Validity of Parameters */
  
  if (argc != 3) 
    {
      printf("\nsftpdata filename filesize\n");
      printf("e.g. create a 1K  file: sftpdata datafile 1024\n");
      printf("     create a 1MB file: sftpdata datafile 1024000\n\n");
      exit(-1);
    }
  
  /* Try to Open file for Writing Only */

  fi = fopen(argv[1],"w"); 

  if (fi == NULL)
    {
      printf("ERROR: Cannot open %s\n",argv[1]);
      exit(-1);
    }
  
  printf("Creating Data File (%s) of length %s ...\n",argv[1],argv[2]); 
  fflush(stdout);
  
  filesize = atoi(argv[2]);

  /* dump data to file */
  
  for (j=0; j<filesize;j++)
    fputc('X',fi);             /* dump character to file */
  
  /* close file */

  close(fi);
}
