


/*********************************************************************
*
* Name        : utils.c --- of Sftp
*
* Version     : 1.0
*
* Description : utilities for transfer
*               -ing data files across machines using TCP/IP protocol.
*
* Written by  : Aju John
*
* Address     : Worcester Polytechnic Institute
*               Computer Science Department
*               100 Institute Road,
*               Worcester MA 01609.
*               U.S.A
*               (508) 831-5005
*
************************************************************************/

/******************************************************************
  This program is a part of a client - server data transfer system
  built to study the effect of different sizes of buffering to the
  transport interface, and to compare the file transfer performance
  using TCP/IP protocol. This was developed as a partial fulfilment
  for the Networks course under Prof. Robert E. Kinicki
 ******************************************************************/


/***************************   REVISION HISTORY ****************************
 *  $Log:	utils.c,v $
 * Revision 1.0  90/11/30  17:19:11  aju
 * 
***************************************************************************/



#define SERVPORT	3277
#define WHITE           " \t\n"

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <arpa/nameser.h>
#include <arpa/ftp.h>
#include <arpa/telnet.h>
#include <sys/socket.h>
#include <signal.h>
#include <errno.h>
#include <netdb.h>
#include <fcntl.h>
#include <pwd.h>
#include <netinet/in.h>
#include <netinet/in.h>
#include <resolv.h>



extern int h_errno;


struct  sockaddr_in hisctladdr;
struct  sockaddr_in data_addr;
int     data = -1;
int     abrtflag = 0;
int     ptflag = 0;
int     connected;
struct  sockaddr_in myctladdr;
uid_t   getuid();

FILE    *cin, *cout;
FILE    *dataconn();
int     verbose;                /* print messages coming back from server */
int     debug;                  /* debugging level */
char    *hostname;              /* name of host connected to */
int     code;                   /* return/reply code  */
extern  int errno;


int
hookup(host)
char *host;
{
        int port, i;
	register struct hostent *hp = 0;
	char h[32];
	register char *ss;
	int s,len;
	static char hostnamebuf[80];
	char host_name[32];

	strcpy(host_name, host);
        port = SERVPORT;
	bzero((char *)&hisctladdr, sizeof (hisctladdr));
	hisctladdr.sin_addr.s_addr = inet_addr(host);
/*	if (hisctladdr.sin_addr.s_addr != -1) {
		hisctladdr.sin_family = AF_INET;
		(void) strcpy(hostnamebuf, host);
	}

        else { */

	  gethostname(h, 32);
	  ss = h;
	  
	  i=0;

	  while(i==0){
	    printf( "getting address...\n");

	    hp = gethostbyname(host_name) ;
	    if ( hp != NULL){
	      i=1;
	      break;
	    }
	    printf("Need complete Internet destination name:");
	    gets(host_name);
	  }


/*      }  if part */

	hisctladdr.sin_family = hp->h_addrtype;
	bcopy(hp->h_addr_list[0],
	      (caddr_t)&hisctladdr.sin_addr, hp->h_length);
	(void) strcpy(hostnamebuf, hp->h_name);

	hostname = hostnamebuf;
        s = socket(hisctladdr.sin_family, SOCK_STREAM, 0);
	if (s < 0) {
		perror("hookup: socket");
		code = -1;
		return (code);
	}
	hisctladdr.sin_port = port;
	while (connect(s, (char *)&hisctladdr, sizeof (hisctladdr)) < 0) {
		if (hp && hp->h_addr_list[1]) {
			int oerrno = errno;
			fprintf(stderr, "ftp: connect to address %s: ",
			inet_ntoa(hisctladdr.sin_addr));
			errno = oerrno;
			perror((char *) 0);
			hp->h_addr_list++;
			bcopy(hp->h_addr_list[0],
			(caddr_t)&hisctladdr.sin_addr, hp->h_length);
			fprintf(stdout, "Trying %s...\n",
			inet_ntoa(hisctladdr.sin_addr));
			(void) close(s);
			s = socket(hisctladdr.sin_family, SOCK_STREAM, 0);
			if (s < 0) {
				perror("hookup: socket");
				code = -1;
				return (code);
			}
			continue;
		}
		perror("sftp: connect");
		code = -1;
		goto bad;
	}
	cin = fdopen(s, "r");
	cout = fdopen(s, "w");
	if (cin == NULL || cout == NULL) {
		fprintf(stderr, "sftp: fdopen failed.\n");
		if (cin)
			(void) fclose(cin);
		if (cout)
			(void) fclose(cout);
		code = -1;
		goto bad;
	}
	printf("Connected to %s.\n", hostname);

#ifdef SO_OOBINLINE
	{
		int on = 1;

		if (setsockopt(s, SOL_SOCKET, SO_OOBINLINE, &on, sizeof(on))
		    < 0 && debug) {
			perror("ftp: setsockopt");
		}
	}
#endif SO_OOBINLINE

	return (s);
bad:
	(void) close(s);
	return (-1);
}



long get_size(file_name)
char *file_name;
{

  int             ret, val;
  int             i;
  long            total_size;
  char            c[5];
#ifndef SCO
  register
#endif
  struct stat     *statinfo;
  char            temp[30];


  total_size = 0;

  statinfo  = (struct stat *)calloc(1, sizeof(struct stat));

  ret =  stat(file_name, statinfo);
  if (ret)
    printf ("get_size: Error in stat: %d. Can't find %s\n", ret, file_name);
  else
    total_size = (long) statinfo->st_size;
  return ( total_size);
}


printanswer(hp)
     register struct hostent *hp;
{
  register char **cp;
/*  extern char *inet_ntoa(); */
  
  printf("Name: %s\n", hp->h_name);
  printf("Address: %s\n", inet_ntoa(*(struct in_addr *)hp->h_addr));
  
}


long
receive_data(s, buf)
int s;
char *buf;
{
  long  t;
  long  len, pos, tlen;

  len = 0;
  if ((t = read(s, &len, sizeof(len))) < 0) perror("read");
  else{
    pos = 0;tlen = len;
    while(tlen > 0){
      if ((t = read(s, buf+pos, tlen)) < 0) printf("read error");
      tlen = tlen -t; pos = pos + t;
    }
  }

  return(len);
}



send_data(s, buf, len)
char *buf;
int s;
long len;
{
  int  t;


  if ((t = write(s, &len, sizeof(len))) < 0)
    perror("send_date");

  else if ((t = write(s, buf, len )) < 0)
    perror( "send: warning" );
  return(t);
}

connect_to_socket(s, remote_addr)
int s;
struct sockaddr_in *remote_addr;
{
  int t;

  if ((t = connect( s, (char *)remote_addr, sizeof(*remote_addr))) < 0)
    bailout( "connect" );
  return(t);
}

bind_sock(sock, host_addr)
int sock;
struct sockaddr_in *host_addr;
{
  int t;

  if ((t = bind( sock, (caddr_t)host_addr, sizeof(*host_addr))) < 0)
      bailout( "bind" );
  return(t);
}


create_socket()
{ 
  int sock;

  if ((sock = socket( AF_INET, SOCK_STREAM, IPPROTO_TCP)) < 0)
     bailout("socket()");
  return(sock);
}



mk_sock_addrin(sock_addr, host)
struct sockaddr_in	*sock_addr;
char host[32];
{

  int i;
  char h[32];
  register struct hostent *hp;
  register char *s;
  gethostname(h, 32);
  s = h;

  i=0;

  while(i==0){
      printf("\nServer machine name=>%s\n", host);
      hp = gethostbyname(host) ;
      if ( hp != NULL){
        i=1;
        break;
      }

      hp = gethostbyname(host) ;
      if ( hp != NULL){
        i=1;
        break;
      }
      printf("Need complete Internet destination name:");
      gets(host);
    }
  printanswer(hp);


  bzero( (char *) sock_addr, sizeof(*sock_addr));
  sock_addr->sin_port = SERVPORT;
  bcopy((char *)hp->h_addr,
        (char *) &(sock_addr->sin_addr),
        hp->h_length);
  sock_addr->sin_family = AF_INET;
}



bailout( s, c)
char	*s;
int	c;
{
  perror( s );
  exit( c );
}



