/****************************************************************************
*
* Name        : client1.c  of X Interprocess Communication(IPC) Benchmark
*
*
* Description : This is the main client synchronization program which updates the 
*               shared file and writes to synchronizing client (server1) at local  
*               host. 
*               The client simulates the test results of actual clients like xdvi,
*               emacs etc by reproducing the sizes of the data sent by client and   
*               server.
*               The client uses data collected by Mr. Ralph E. Drom for the  
*               performance of the X window System Communication Protocol.
*               The client reads this data from a file. This data contains the 
*               number of bytes sent by the client as well as the number of bytes
*               the server has to reply with.
*
* Written by  : Dhruve Shah
*
* e-mail      : mach@cs.wpi.edu
*
* Address     : Mach Research Group
*               Worcester Polytechnic Institute (WPI)
*               Computer Science Department
*               100 Institute Road,
*               Worcester MA 01609.
*               U.S.A
*               (508) 831-5357
*
************************************************************************/



#include <stdio.h>
#include <sys/file.h>
#include <ctype.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/signal.h>
#include <sys/param.h>
#include <arpa/nameser.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include <resolv.h>
#include "defines.h"  
  
  
#define SERV_TCP_PORT   3078

FILE *fp;  

void sync_using_files(); /* Call function to synchoronize start of all client 
                          transactions */


main(argc, argv)
     int argc;
     char *argv[];
{
  
  int syn_sock; /* Socket used by synchronizing client */
  struct sockaddr_in cli_syn; /* structure for remote server address information */
  char temp_buf[100]; /* Temporary buffer for sending string */
  struct sockaddr_in *rmcli;

  
/* Check if syn_client has been called with right number of parameters */
  
  if((argc != 3))
    {
      printf("Usage: syn_client remote_hostname/local_hostname num_clients\n");
      exit(-1);
    }

#ifdef DEBUG  
  printf("Server name is %s\n",argv[1]);
  printf("Number of clients is %d\n",atoi(argv[2]));
#endif DEBUG

  rmcli = &cli_syn;

/* Fill socket_addrin with remote server address information. Make a socket and connect*/

  syn_sock  = initialize_syn_client(argv[1],rmcli);
  
  
  printf("\nConnect synchronizing client succeeded\n\n");

/* Call function to synchronize start of transaction of clients both local and remote */

  sync_using_files(argv);

  printf("\nSynchronizing remote client found value equal to number of clients\n\n");

/* Send a string to local synchronizing client (server1) to let him know all remote
   clients are connected. */

  sprintf(temp_buf,"Hi how are you\n");
  send_data(syn_sock,temp_buf,100);
  
  close(syn_sock); /* Close socket */
  exit(0);
  
}

/**************************************************************************************
 * This function increments an integer in a shared file and then polls to check if    *
 * the integer value equals total number of clients + 1.                              *
 **************************************************************************************/

void sync_using_files(argv)
char **argv;
{
  char lockname[MAXNAME], sema_lock[MAXNAME];
  int iteration_count;
  int ret, sema_ret, value,syn_flag;
  FILE *rd_lock;

  sprintf(lockname,"file_lock");
  strcat(lockname, "_#w");
  sprintf(sema_lock,"file_lock");
  strcat(sema_lock, "_#s");
  strcat(lockname, "_#r");



  rd_lock = fopen(lockname,"r");
  if(rd_lock == NULL)
    {
      rd_lock = fopen(lockname, "w+");
      value = 1;
      fprintf(rd_lock, "%d",value);
      fclose(rd_lock);
    }
  else
    {
      fclose(rd_lock);
      sema_ret = -1;
      while(sema_ret == -1)
	{
	  sema_ret = open(sema_lock, O_CREAT | O_EXCL);
#ifdef DEBUG
	  if(ret < 0)
	    printf("Blocked by spinlocks..... read/write\n");
#endif DEBUG
	}
      close(sema_ret);

      rd_lock = fopen(lockname, "r+");
      if (rd_lock == NULL)
	printf("********* ERROR IN READ LOCK ********\n");
      fscanf(rd_lock,"%d",&value);
      value++;
      rewind(rd_lock);
      fprintf(rd_lock,"%d",value);
#ifdef DEBUG
      printf("value = %d\n",value);
#endif DEBUG
      rewind(rd_lock);
      fclose(rd_lock);
      unlink(sema_lock);
    }
  iteration_count = 0;
  syn_flag = FALSE;
  while(syn_flag == FALSE)
    {
      rd_lock = fopen(lockname, "r");
      if (rd_lock == NULL)
	printf("********* ERROR IN READ LOCK ********\n");
      fscanf(rd_lock,"%d",&value);
      rewind(rd_lock);
#ifdef DEBUG
      printf("value in syn loop = %d\n",value);
#endif DEBUG
      if(value == (atoi(argv[2]) + 1))
	syn_flag = TRUE;
      fclose(rd_lock);
      iteration_count++;
      if(iteration_count >= ITERLIMIT)
	syn_flag = TRUE;
    }


}

/************************************************************************************
 * This function fills structure sockaddr_in with remote server address information.*
 * It creates a socket, connects to remote server and returns socket descriptor to  *
 * calling routine.                                                                 *
 ************************************************************************************/


initialize_syn_client(host, remote_addr)
     struct sockaddr_in *remote_addr;
     char *host;
{
  int sock, t;
  
  mk_syn_sock(remote_addr, host);
  sock = create_socket();
  t = connect_to_socket(sock, remote_addr);
  if(t < 0)
    {
      perror("connect");
      exit(-1);
    }
  return(sock);
}






