static char rcsid[] = "$Id: paren.c,v 1.1 1991/08/21 17:22:17 waite Exp $";
/* Translation to fully-parenthesized form */

#include <stdio.h>
#include "ptg_gen.h"

static PTGNode stack[100];	/* Trandlator stack */
static int top = 0;		/* Initially empty */

void
ExprInt(i)
int i;
/* Place an integer value onto the stack */
{
   top++; if (top == 100) { fprintf(stderr, "Stack overflow\n"); exit(1); }
   stack[top] = PTGValue(i);
}

				/* Computations */
void
ExprPlus()
{ top--; stack[top] = PTGSum(stack[top], stack[top+1]); }

void
ExprMinus()
{ top--; stack[top] = PTGDifference(stack[top], stack[top+1]); }

void
ExprTimes()
{ top--; stack[top] = PTGProduct(stack[top], stack[top+1]); }

void
ExprDiv()
{ top--; stack[top] = PTGQuotient(stack[top], stack[top+1]); }

void
ExprFinl()
/* Calculator finalization: Print the top element of the stack */
{ PTGOut(stack[top], ""); putchar('\n'); }
