static char RCSid[] = "$Id: match.c,v 1.2 1992/08/19 23:11:13 kadhim Exp $";
/* Keyword matching module */
/* Copyright 1992, The Regents of the University of Colorado */

#include <stdio.h>

#define NORETURN 15001	/* hopefully, no one needs this as a token code */

#include "xtables.h"

static char *TokenStart, *TokenEnd;

#if defined(__cplusplus) || defined(__STDC__)
int
glalex(char *v)
#else
int
glalex(v)
char *v;		/* pointer to storage for intrinsic value */
#endif
{
register char c;		/* hold current char */
int     extcode;	/* external token repr */
register unsigned char *scanTbl = ScanTbl;/* this holds the base in a register */
register char *p = TokenEnd;	/* most current working pointer */

#if defined(__cplusplus) || defined(__STDC__)
	char *(*scan)(char *, int);
	void  (*proc)(char *, int, int *, char *);
#else
	char *(*scan)();
	void  (*proc)();
#endif

/* continue/start a new token */
for(;;) {
	switch( CaseTbl[c = *p++]) {
		case 0:	/* sentinel - probably EOB */
		case 1:	/* space */
		case 2:	/* tab */
		case 3:	/* newline */
			return 1;

		/****************************/
		/* generated code goes here */
		/****************************/
#include "xcode.h"

fallback:
	return 1;

	} /* end for ever */
}

/***/
char
match(v)
char *v;
/* Check whether a string is in a given set of tokens
 *    On entry-
 *       v addresses the string to be matched
 *    If the string matched a token completely then on exit-
 *       match=1
 *    Else on exit-
 *       match=0
 ***/
{
	char *dummy;

	TokenStart = TokenEnd = v;
	if (glalex(dummy) && *TokenEnd == '\0')
		return 1;
	return 0;
}
