SHELL	= /bin/sh

CFLAGS	= 

OBJS	= driver.o \
	parse.o \
	err.o \
	source.o \
	glahead.o \
	auxScanEOL.o \
	idn.o \
	csm.o \
	obstack.o \
	int.o \
	pascalStr.o \
	pgs_gen.o \
	treecon.o \
	visitprocs.o \
	ptg_gen.o \
	Coding.o \
	pdl_gen.o \
	deftbl.o \
	envmod.o \
	symbol.o \
	treestack.o \
	attrmain.o \
	dfltclp.o

EXE	= concrete.exe

$(EXE):	$(OBJS)
	$(CC) -o $(EXE) $(CFLAGS) $(OBJS)

objects: $(OBJS)

clean:
	rm -f a.out *.o *.a *~ core ERRS $(EXE)

tidy:
	rm -f core a.out *.o *~ *.a ERRS

driver.o:	driver.c HEAD.h INIT.h FINL.h treecon.h pdl_gen.h deftbl.h ptg_gen.h \
symbol.h envmod.h Coding.h err.h treestack.h
parse.o:	parse.c parse.h pgs_gen.h err.h gla.h gsdescr.h
err.o:	err.c err.h source.h
source.o:	source.c source.h
glahead.o:	glahead.c err.h source.h xtables.h xcode.h
auxScanEOL.o:	auxScanEOL.c err.h gla.h source.h
idn.o:	idn.c err.h idn.h csm.h idntbl.h obstack.h
csm.o:	csm.c csm.h csmtbl.h obstack.h
obstack.o:	obstack.c obstack.h
int.o:	int.c int.h
pascalStr.o:	pascalStr.c err.h gla.h
pgs_gen.o:	pgs_gen.c parse.h HEAD.h err.h gla.h gsdescr.h treecon.h pdl_gen.h \
deftbl.h ptg_gen.h symbol.h envmod.h Coding.h treestack.h
treecon.o:	treecon.c HEAD.h node.h visitprocs.h gsdescr.h obstack.h treecon.h \
pdl_gen.h deftbl.h ptg_gen.h symbol.h envmod.h Coding.h err.h \
treestack.h
visitprocs.o:	visitprocs.c HEAD.h err.h node.h visitprocs.h glattr.h attrpredef.h \
treecon.h pdl_gen.h deftbl.h ptg_gen.h symbol.h envmod.h Coding.h \
treestack.h
ptg_gen.o:	ptg_gen.c ptg_gen.h
Coding.o:	Coding.c err.h csm.h envmod.h deftbl.h pdl_gen.h Coding.h obstack.h \
ptg_gen.h
pdl_gen.o:	pdl_gen.c deftbl.h pdl_gen.h
deftbl.o:	deftbl.c err.h deftbl.h
envmod.o:	envmod.c err.h envmod.h deftbl.h
symbol.o:	symbol.c idn.h
treestack.o:	treestack.c err.h treecon.h treestack.h
attrmain.o:	attrmain.c treecon.h visitprocs.h err.h treestack.h
dfltclp.o:	dfltclp.c source.h
