/*
 * This program can be used to calibrate the clock reading jitter of a
 * particular CPU and operating system. It first tickles every element
 * of an array, in order to force pages into memory, then repeatedly calls
 * gettimeofday() and, finally, writes out the time values for later
 * analysis. From this you can determine the jitter and if the clock ever
 * runs backwards.
 */
#include <sys/time.h>
#include <stdio.h>

main()
{
	struct timeval tp, ts, tr;
	struct timezone tzp;
	long ltemp, mtemp[100000];

	gettimeofday(&ts, &tzp);
	ts.tv_usec = 0;

	/*
	 * force pages into memory
	 */
	for (ltemp = 0; ltemp < 100000; ltemp ++)
		mtemp[ltemp] = 0;

	/*
	 * construct dataset
	 */
	for (ltemp = 0; ltemp < 100000; ltemp ++) {
		gettimeofday(&tp, &tzp);
		tr = tp;
		tr.tv_sec -= ts.tv_sec;
		tr.tv_usec -= ts.tv_usec;
		if (tr.tv_usec < 0) {
			tr.tv_usec += 1000000;
			tr.tv_sec--;
		}
		mtemp[ltemp] = tr.tv_sec * 1000000 + tr.tv_usec;
	}

	/*
	 * write out the goodies
	 */
	for (ltemp = 0; ltemp < 100000; ltemp ++) {
		printf("%lu\n", mtemp[ltemp]);
	}
}

