/*
	Some global definitions.
*/

#define TRUE    1
#define FALSE   0
#define BUFLEN  128
#define DEFWINW 512
#define DEFWINH 512

/*
	NTP global defs
*/

/*
 * Default values we use.
 */
#define DEFTIMEOUT      (5)             /* 5 second time out */
#define DEFSTIMEOUT     (2)             /* 2 second time out after first */
#define DEFDELAY        0x51EB852       /* 20 milliseconds, l_fp fraction */
#define DEFHOST         "localhost"     /* default host name */
#define LENHOSTNAME     256             /* host name is 256 characters long */
#define MAXCMDS         100             /* maximum commands on cmd line */
#define MAXHOSTS        100             /* maximum hosts on cmd line */
#define MAXLINE         512             /* maximum line length */
#define MAXTOKENS       (1+MAXARGS+2)   /* maximum number of usable tokens */
#define MAXVARLEN       256             /* maximum length of a variable name */
#define MAXVALLEN       256             /* maximum length of a variable value */
#define MAXOUTLINE      72              /* maximum length of an output line */

/*
 * Error codes for internal use
 */
#define ERR_UNSPEC              256
#define ERR_INCOMPLETE          257
#define ERR_TIMEOUT             258
#define ERR_TOOMUCH             259

/*
 * Structure to hold association data
 */
struct association {
        u_short assid;
        u_short status;
};

#define MAXASSOC        1024

#define	MAX(a, b)	((a) > (b) ? (a) : (b))
#define	MIN(a, b)	((a) < (b) ? (a) : (b))

/*
 * Structure to hold happy trails (old x,y values for redrawing
 * the history of time changes).
 */

struct ht_info {
	int x,y;
	struct ht_info *next;
};

/*
 * Structure to hold node graphic state.
 */
struct g_info {
	char host[LENHOSTNAME];
	int associd;
	float delay;
	float offset;
	int x,y;	/* circle center */
	int r;		/* radius */
	struct ht_info *head;
};

#define MAXGINFO        512
