#! /bin/sh
:
#ident	"@(#)contrib:RELEASE-3_2_0_109:bouncemail.sh,v 1.1 1997/04/16 02:56:07 woods Exp"
#
#	bouncemail.sh - bounce a mail message
#
# Written by Greg A. Woods while at Nirv Centre / Web Networks <woods@web.net>
# Contributed to the public domain.
#

umask 022

argv0=`basename $0`

USAGE="Usage: $argv0 [-v] message_queue_id"

if [ "$1" = "-v" ] ; then
	verbose="-v"
	shift
fi

if [ $# -ne 1 ] ; then
	echo $USAGE
	exit 2
fi

if expr "`id`" : '^uid=0(root)' >/dev/null ; then
	:
else
	echo "$argv0:  ERROR:  you must be root to do this!"
	exit 1
fi

echo "You are about to bounce the following message back to the sender:"
mailq $verbose $1

echo "Do you want to continue? [n] \c"
read ans junk
case "$ans" in
y*|Y*)
	;;
*)
	echo "$argv0: Aborting..."
	exit 1
	;;
esac

# really should be "spool_dir", but that's empty
#
spool_dir=`smail -bP spool_dirs`

# WARNING: the use of $spool_dir/tmp may be special to our
# local config?
#
tmpconfig=$spool_dir/tmp/tc$$

config_file=`smail -bP config_file`

echo "retry_duration=0" | cat - $config_file > $tmpconfig
trap 'rc=$?; rm -f $tmpconfig; exit $rc' 0 1 2 3 15

smail -oC $tmpconfig -q $verbose $1

exit $?
