#! /bin/sh
#
#	mkRelease.sh -- generate a new release
#
# Once upon a time I did this all by hand, step by step...
#
#ident "@(#)smail:RELEASE-3_2_0_116:mkRelease.sh,v 1.4 2004/03/26 22:50:19 woods Exp"

# NOTE: must be run from within an up-to-date CVS working directory

# by default the new version is the current level less the "-Pre" suffix
#
VERSION=$(awk '/^3/ {sub(/-Pre/, "", $1); print $1;}' level)

# this might not be a good idea -- and if it is it'll need a LOT more work!
# 
# MINOR: increment minor #, go to two levels
# PATCH: increment patch #, go to three levels
#
# and NEXT always goes to BETA of next patch level
#
# How to handle PREV when PREV wasn't a BETA?
#
TYPE=${TYPE:-"BETA"}
case $TYPE in
BETA)
	PREV=$(echo ${VERSION} | awk -F . '{printf("%d.%d.%d.%d\n", $1, $2, $3, $4 - 1);}')
	NEXT=$(echo ${VERSION} | awk -F . '{printf("%d.%d.%d.%d\n", $1, $2, $3, $4 + 1);}')
	;;
*)
	echo "$0: Don't know how to make a ${TYPE} release yet!" 1>&2
	exit 1
esac

TAG=RELEASE-$(echo ${VERSION} | sed 's/\./_/g')
PREV_TAG=RELEASE-$(echo ${PREV} | sed 's/\./_/g')
ARCHIVE_DIR="/most/var/spool/ftp/pub/local"
RELEASE_DIR="/work/woods/release.d"

if [ ! -r level -o ! -d ${RELEASE_DIR} -o ! -d ${ARCHIVE_DIR} ] ; then
	echo "$0: pre-requisite files or directories are missing!" 1>&2
	exit 1
fi

if [ ! -f RELEASE-${VERSION} ] ; then
	echo "$0: you haven't written new ${TYPE} release notes in RELEASE-${VERSION} yet!" 1>&2
	exit 1
fi

(
	sed 1q level
	echo ${VERSION} $(date)
) > level.new
mv level.new level

cvs commit -m "- this is release ${VERSION}" level

cvs tag ${TAG} .

# uses "level" too so must be run before updating "level" again
#
sh ./mkChangeLog.sh

(
	sed 1q level
	echo ${NEXT}-Pre $(date)
) > level.new
mv level.new level

cvs commit -m "- post ${VERSION} -- get ready to preview release ${NEXT}" level

( 
	echo ""
	echo "Release ${VERSION} generated:  $(date)"
) >> RELEASE-${VERSION}

OPWD=$(/bin/pwd)

cd ${RELEASE_DIR} || exit 1

cvs rdiff -u -kv -r ${PREV_TAG} -r ${TAG} m-smail > smail-${PREV}-${VERSION}.diffs
gzip -v smail-${PREV}-${VERSION}.diffs

cvs export -kv -r ${TAG} -d smail-${VERSION} m-smail

# keep a copy of these inside the archive too....
cp ${OPWD}/ChangeLog-${VERSION} smail-${VERSION}/
cp ${OPWD}/RELEASE-${VERSION} smail-${VERSION}/

mv ${OPWD}/RELEASE-${VERSION} smail-${VERSION}-README.FIRST

pax -w -z -f ${ARCHIVE_DIR}/smail-${VERSION}.tar.gz smail-${VERSION}

cp smail-${VERSION}-README.FIRST ${ARCHIVE_DIR}
cp smail-${VERSION}/README ${ARCHIVE_DIR}/smail-${VERSION}-README
cp smail-${VERSION}/ChangeLog-${VERSION} ${ARCHIVE_DIR}/smail-${VERSION}.ChangeLog
cp smail-${PREV}-${VERSION}.diffs.gz ${ARCHIVE_DIR}

cd ${ARCHIVE_DIR} || exit 1

# leave the old README.FIRST
# XXX if making BETA then should leave whatever old RELEASE points to
rm smail-${PREV}.tar.gz smail-${PREV}-README smail-${PREV}.ChangeLog smail-*-${PREV}.diffs.gz

FILES="smail-${VERSION}-README.FIRST smail-${VERSION}-README smail-${VERSION}.tar.gz smail-${PREV}-${VERSION}.diffs.gz"

md5 ${FILES} > smail-${VERSION}.md5

echo rm smail-${TYPE}.tar.gz
echo ln -s smail-${VERSION}.tar.gz smail-${TYPE}.tar.gz
rm smail-${TYPE}.tar.gz
ln -s smail-${VERSION}.tar.gz smail-${TYPE}.tar.gz

echo rm smail.tar.gz
echo ln -s smail-${VERSION}.tar.gz smail.tar.gz
rm smail.tar.gz
ln -s smail-${VERSION}.tar.gz smail.tar.gz

echo rm README-${TYPE}
echo ln -s smail-${VERSION}-README README-${TYPE}
rm README-${TYPE}
ln -s smail-${VERSION}-README README-${TYPE}

echo rm README.FIRST-${TYPE}
echo ln -s smail-${VERSION}-README.FIRST README.FIRST-${TYPE}
rm README.FIRST-${TYPE}
ln -s smail-${VERSION}-README.FIRST README.FIRST-${TYPE}

echo rm README
echo ln -s smail-${VERSION}-README README
rm README
ln -s smail-${VERSION}-README README

echo rm README.FIRST
echo ln -s smail-${VERSION}-README.FIRST README.FIRST
rm README.FIRST
ln -s smail-${VERSION}-README.FIRST README.FIRST

# XXX if making a PATCH or a RELEASE then remove old BETA links...

scp ${FILES} smail-${VERSION}.md5 ftp.planix.com:/u5/ftp/pub/Smail/

echo "First go re-link as above and archive the old version on ftp.planix.com ..."

echo "... then go tell FreshMeat.net and UseNet !!!"
