// $Header: Select.cc,v 1.2 92/06/17 15:53:38 vern Exp $

#include <stdio.h>
#include <osfcn.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/resource.h>

#ifdef masscomp
#include <X11/fd.h>
#endif

#ifdef SABER
#include <libc.h>
#endif

#include "Select.h"


Selector::Selector()
	{
	// You want to do the following - ideally but g++ does not have
	// sysconf - so for now...
	// if ((max_num_fds = sysconf( _SC_OPEN_MAX )) < 0)
	//	Gripe( "sysconf() failed" );

#ifdef NOTDEF
	struct rlimit rl;
	if ( getrlimit( RLIMIT_NOFILE, &rl ) < 0 )
		Gripe( "getrlimit() failed" );

	max_num_fds = rl.rlim_max;
#endif
	max_num_fds = 32;


	selectees = new Selectee* [max_num_fds];

	for ( int i = 0; i < max_num_fds; ++i )
		selectees[i] = 0;

	fdset = new struct fd_set;
	FD_ZERO( fdset );
	}

Selector::~Selector()
	{
	for ( int i = 0; i < max_num_fds; ++i )
		delete selectees[i];

	delete selectees;
	delete fdset;
	}

void Selector::AddSelectee( Selectee* s )
	{
	selectees[s->FD()] = s;
	FD_SET( s->FD(), fdset );
	}

void Selector::DeleteSelectee( int selectee_fd )
	{
	if ( ! FD_ISSET( selectee_fd, fdset ) )
		Gripe( "non-existent selectee in RemoveSelectee()" );

	delete selectees[selectee_fd];
	selectees[selectee_fd] = 0;
	FD_CLR( selectee_fd, fdset );
	}

int Selector::DoSelection()
	{
	fd_set read_mask = *fdset;
	int status;

	if ( (status =
	      select( FD_SETSIZE, &read_mask, (fd_set *) 0, (fd_set *) 0,
		      NULL )) < 0 )
		{
		if ( errno != EINTR )
			Gripe( "error in DoSelection()" );

		return 0;
		}

	for ( int i = 0; status > 0 && i < max_num_fds; ++i )
		{
		if ( FD_ISSET( i, &read_mask ) )
			{
			int selectee_value = selectees[i]->NotifyOfSelection();

			if ( selectee_value )
				return selectee_value;

			--status;
			}
		}

	if ( status != 0 )
		Gripe( "inconsistency in DoSelection()" );

	return 0;
	}

void Selector::Gripe( char* msg )
	{
	fprintf( stderr, "Selector error: %s\n", msg );
	perror( "perror value" );
	exit( 1 );
	}
