// $Header: Select.h,v 1.2 92/05/15 14:31:35 vern Exp $

#ifndef select_h
#define select_h


struct fd_set;

class Selectee {
    public:
	Selectee( int selectee_fd )	{ fd = selectee_fd; }
	virtual ~Selectee()		{ }

	int FD()	{ return fd; }

	// returns non-zero if the selection should stop, zero otherwise
	virtual int NotifyOfSelection()	{ return 0; }

    protected:
	int fd;
	};

class Selector {
    public:
	Selector();
	~Selector();

	void AddSelectee( Selectee* s );
	void DeleteSelectee( int selectee_fd );

	// if selection stops early due to non-zero return from Selectee's
	// NotifyOfSelection(), returns that non-zero value.  Otherwise
	// returns 0.
	int DoSelection();

    protected:
	void Gripe( char* msg );

	int max_num_fds;
	Selectee** selectees;	// array indexed by fd
	struct fd_set* fdset;
	};

#endif	/* select_h */
