#ifndef ISTKltypes_h
#define ISTKltypes_h

/* $Header: ltypes.h,v 1.1 91/12/21 09:30:12 salty Exp $ */

/**************************************************************************
 *                 ****** ISTK Release 1.2 *****                          *
 *                                                                        *
 *                                                                        *
 * This code has been produced by numerous authors at the CERN centre for *
 * high energy physics, Geneve, Switzerland, at the SSC laboratory in     *
 * Dallas, Texas, USA and at the Lawrence Berekeley Laboratory in         *
 * California, USA.                                                       *
 * The latter two institutions perform work under US Government contract. *
 * The intent of the work is to provide useful code for people who need   *
 * it, with an emphasis on free and collaborative exchange of ideas,      *
 * techniques and implementations.                                        *
 * Please read the disclaimer and copyright notices contained in the ISTK *
 * distribution and in distributed applications.                          *
 *                                                                        *
 **************************************************************************/

/* Reference release  Aug 10 1991 - C G Saltmarsh */
/* Has the basics used at CDG & SSC 1988-1991, plus vxworks
   support
*/

/* Some handy structure types in type_list format */

static struct type_list direc_type_list[] = 
  {(long)5,SDS_LONG,
   (long)1,SDS_WORD,
   (long)2,SDS_BYTE,
   (long)1,SDS_LONG,
   (long)0,SDS_RETLIST,
   (long)0,SDS_ENDLIST};

static struct type_list header_type_list[] = 
  {(long)2,SDS_LONG,
   (long)2,SDS_WORD,
   (long)0,SDS_RETLIST,
   (long)0,SDS_ENDLIST};

static struct type_list tlist_type_list[] = 
  {(long)2,SDS_LONG,
   (long)0,SDS_RETLIST,
   (long)0,SDS_ENDLIST};


static struct type_list plot_type_list[] = 
  {(long)1,SDS_LONG,
   (long)4,SDS_FLOAT,
   (long)0,SDS_RETLIST,
   (long)0,SDS_ENDLIST};

/*  This is a template only. When a string is given to the
  system, it will be loaded as a tlist entry of xxx sds_bytes:
  this is such a tlist template, with the -1 ready to be 
  changed to xxx
*/

static struct type_list string_type_list[] =
  {(long)-1,SDS_BYTE,
    (long)0,SDS_RETLIST,
    (long)0,SDS_ENDLIST};

/*  Another template for two-d array (used by
  Fortran) In this case, both nelems and
  elemcod will be loaded.
*/
static struct type_list twod_type_list[] =
  {(long)-1,(long)-1,
    (long)0,SDS_RETLIST,
    (long)0,SDS_ENDLIST};
#endif
