#ifndef sds_externs_h
#define sds_externs_h

/* $Header: sds_externs.h,v 1.2 92/06/11 10:13:16 salty Exp $ */

/**************************************************************************
 *                 ****** ISTK Release 1.2 *****                          *
 *                                                                        *
 *                                                                        *
 * This code has been produced by numerous authors at the CERN centre for *
 * high energy physics, Geneve, Switzerland, at the SSC laboratory in     *
 * Dallas, Texas, USA and at the Lawrence Berekeley Laboratory in         *
 * California, USA.                                                       *
 * The latter two institutions perform work under US Government contract. *
 * The intent of the work is to provide useful code for people who need   *
 * it, with an emphasis on free and collaborative exchange of ideas,      *
 * techniques and implementations.                                        *
 * Please read the disclaimer and copyright notices contained in the ISTK *
 * distribution and in distributed applications.                          *
 *                                                                        *
 **************************************************************************/


#ifdef __cplusplus
extern "C"
{

sds_handle     sds_open(char *);
struct  direc *sds_load_direc(sds_handle);
struct  direc *f2mem(char *);
void           set_sys_vars(sds_handle, struct direc *);
int            sds_namelist(char *, char *, char *);

sds_handle     next_sds();

void           nexpand(char *,char *);
void          *sds_getp(struct direc *,long);
void           fix_sizes_and_aligns(sds_handle);


char          *get_heap(sds_handle);

struct direc  *sds_direc_ptr(sds_handle);

sds_handle     sds_tlist_add(sds_handle,struct type_list *);
sds_handle     object_size(struct direc *, struct type_list *,char *);
sds_handle     object_tlsize(long *,struct direc *,
                                  char *, char *, struct type_list *);
void           sds_alt_resolution_stack();
void           sds_main_resolution_stack();

sds_code       convert(int, sds_odesc *, sds_odesc *, int);


void           sds_rinit();
sds_handle     sds_add_to_heap(sds_handle,char *, char *);
char          *sds_jstr(char *, unsigned long);

struct sds_header   *get_header(sds_handle);
struct type_list    *get_tlist(sds_handle);
struct direc        *header_to_direc(struct header *);

struct direc        *shm_attr(char *);
struct direc        *shm_attw(char *);

unsigned long  tlist_size(struct type_list *);
unsigned long  sds_tlsize(sds_handle, long, char *);
sds_handle     get_heap_size(sds_handle);
sds_handle     offil(sds_handle, char **, int, int*);
unsigned long  sds_sz(struct direc *);
sds_handle     sds_open_file(char *, int);
sds_handle     to_file(sds_handle, int, char *);
sds_handle     sds_mem_header(sds_handle, char *);
int            align_delta(int, char);
sds_handle     sds_write_header(sds_handle, int);
sds_handle     sds_write_object(int, sds_handle, sds_code, void *);
sds_handle     sds_read_object(sds_handle, sds_code,
																			void *, long, unsigned long);
int            sds_write_data(int, char *, int);
sds_handle     sds_write_pattern(int, unsigned long, char);
sds_handle     sds_read_header(sds_handle, struct sds_header *);
sds_handle     sds_vread(int, char *, int);
int            sds_read_data(int, char *, int);
void           sds_close_stream(sds_handle);
sds_handle     sds_which(struct direc *);
sds_handle     write_sds(int, sds_handle);

sds_handle     sds_back(struct direc *, char *);

off_t          fsiz(char *);
}
#else 

extern sds_handle     sds_open();
extern struct  direc *sds_load_direc();
extern struct  direc *f2mem();
extern void           set_sys_vars();
extern int            sds_namelist();

extern sds_handle     next_sds();


extern void           nexpand();
extern void          *sds_getp();
extern void           fix_sizes_and_aligns();

extern char          *get_heap();

extern struct direc  *sds_direc_ptr();

extern sds_handle     sds_tlist_add();
extern sds_handle     object_size();
extern sds_handle     object_tlsize();
extern void           sds_alt_resolution_stack();
extern void           sds_main_resolution_stack();

extern sds_code       convert();

extern void           sds_rinit();
extern sds_handle     sds_add_to_heap();
extern char          *sds_jstr();


extern struct sds_header   *get_header();
extern struct type_list    *get_tlist();
extern struct direc        *header_to_direc();

extern struct direc        *shm_attr();
extern struct direc        *shm_attw();

extern unsigned long  tlist_size();
extern unsigned long  sds_tlsize();
extern sds_handle     get_heap_size();
extern sds_handle     offil();
extern unsigned long  sds_sz();
extern sds_handle     sds_open_file();
extern sds_handle     to_file();
extern sds_handle     sds_mem_header();
extern int            align_delta();
extern sds_handle     sds_write_header();
extern sds_handle     sds_write_object();
extern sds_handle     sds_read_object();
extern int            sds_write_data();
extern sds_handle     sds_write_pattern();
extern sds_handle     sds_read_header();
extern sds_handle     sds_vread();
extern int            sds_read_data();
extern void           sds_close_stream();
extern sds_handle     sds_which();
extern sds_handle     write_sds();

extern sds_handle     sds_back();

extern off_t          fsiz();

#endif
#endif

